(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1490164,      27163]
NotebookOptionsPosition[   1473574,      26650]
NotebookOutlinePosition[   1473993,      26666]
CellTagsIndexPosition[   1473950,      26663]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 6", "Title",
 Editable->False,
 CellChangeTimes->{{3.393757273997875*^9, 3.393757275404125*^9}, 
   3.3998859388906655`*^9, 3.4039606266836433`*^9, 3.4119881674644976`*^9}],

Cell["Stochastic Departures From Randomness", "Subtitle",
 Editable->False,
 CellChangeTimes->{{3.4124161191495295`*^9, 3.4124161277318707`*^9}}],

Cell["\[Copyright]W.W.Sampson, Manchester, 2008", "Subsubtitle",
 Editable->False,
 CellChangeTimes->{{3.412935407213834*^9, 3.412935418490048*^9}}],

Cell[CellGroupData[{

Cell["6.2 Fibre Orientation Distributions", "Section",
 Editable->False,
 CellChangeTimes->{{3.4029054503711824`*^9, 3.402905452954898*^9}, {
  3.4124161372755938`*^9, 3.412416144445904*^9}}],

Cell[CellGroupData[{

Cell["6.2.1 One-parameter Cosine Distribution", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.4029127175608883`*^9, 3.4029127263335023`*^9}, 
   3.4039606404234*^9, {3.412416161670672*^9, 3.412416171484784*^9}}],

Cell[TextData[{
 "We input the probability density for the one-parameter cosine distribution, \
",
 StyleBox["s\[Theta]", "Input"],
 ". The probability density depends only on the eccentricity 0 \[LessEqual] \
\[Epsilon]c \[LessEqual] ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "\[Pi]"], TraditionalForm]]]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124161825607104`*^9, 3.412416268454219*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"s\[Theta]", " ", "=", " ", 
   RowBox[{
    RowBox[{"1", "/", "\[Pi]"}], " ", "-", " ", 
    RowBox[{"\[Epsilon]c", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", "\[Theta]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s\[Theta]", "/.", 
      RowBox[{"\[Epsilon]c", "\[Rule]", "0.1"}]}], ",", 
     RowBox[{"s\[Theta]", "/.", 
      RowBox[{"\[Epsilon]c", "\[Rule]", "0.2"}]}], ",", 
     RowBox[{"s\[Theta]", "/.", 
      RowBox[{"\[Epsilon]c", "\[Rule]", 
       RowBox[{"1", "/", "\[Pi]"}]}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", ".7"}], "}"}]}], "}"}]}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\[Theta]\>\"", ",", " ", "\"\<s(\[Theta]\>\""}], "}"}]}], 
   ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", " ", 
      RowBox[{"{", "}"}], ",", " ", "Dotted"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.4029036481497154`*^9, 3.40290367010128*^9}, {
   3.402905467205389*^9, 3.402905467465763*^9}, {3.402905598193741*^9, 
   3.402905599385454*^9}, 3.402905630710498*^9, {3.4029066446684976`*^9, 
   3.402906652990464*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwl2Xk4Vd/XAHBT7kVSGSohQwlJkakM6ySRFKE0EoqkFDKUsYFMJfOQMckU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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xc81d//AHAr9yqlgUpktKRFRvbrnSQrOyWUWahkFIoU2SQzKhmZESUz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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{0, Small}], 
    LineBox[CompressedData["
1:eJwt2Xk4VN8bAPCxhGgjZN9DKmRLlvtOkj37li2UJVosRUoaZUsSKqFsWUu2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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"\[Theta]\"", TraditionalForm], 
    FormBox["\"s(\[Theta]\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, {0, 0.7}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.4029056262040176`*^9, 3.4029056418965826`*^9}, {
   3.402906678076536*^9, 3.4029066914758034`*^9}, 3.4029079552430115`*^9, 
   3.402914345241378*^9, 3.402914388593715*^9, 3.4029154472159395`*^9, 
   3.402915676545699*^9, 3.402915719457403*^9, 3.402917467000246*^9, 
   3.4029192693819437`*^9, 3.402919346572939*^9, 3.4029198563159137`*^9, 
   3.402920095790261*^9, 3.4029229029066963`*^9, 3.4029229589172354`*^9, 
   3.402923195277104*^9, 3.4029374705625*^9, 3.411390878875*^9, 
   3.411390967984375*^9, 3.411391569890625*^9, 3.4118095409112034`*^9}]
}, Open  ]],

Cell["Typically, we plot the probability density as a polar plot:", "Text",
 Editable->False,
 CellChangeTimes->{{3.412416277567323*^9, 3.4124163009108896`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s\[Theta]", "/.", 
      RowBox[{"\[Epsilon]c", "\[Rule]", "0.1"}]}], ",", 
     RowBox[{"s\[Theta]", "/.", 
      RowBox[{"\[Epsilon]c", "\[Rule]", "0.2"}]}], ",", 
     RowBox[{"s\[Theta]", "/.", 
      RowBox[{"\[Epsilon]c", "\[Rule]", 
       RowBox[{"1", "/", "\[Pi]"}]}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", " ", "0", ",", " ", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", " ", 
      RowBox[{"{", "}"}], ",", " ", "Dotted"}], "}"}]}], ",", " ", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4029040196438975`*^9, 3.4029040547643986`*^9}, {
  3.4029058460301123`*^9, 3.4029058718572493`*^9}, {3.4029066581378655`*^9, 
  3.4029066743011074`*^9}, {3.4029143148677025`*^9, 3.4029143206460114`*^9}}],\


Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwsm3c81e/7xxUZRSRFWiqhIbuMcimjlIQIaSgVSkOIKNlkhYhsQkZEZHPh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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwsm3k0ld/3xyWZCSWliJKkNPLJkDZJ5qGQDJVKKiFkyJh5zDxWQjSgwVym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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{0, Small}], 
    LineBox[CompressedData["
1:eJxcm3c81e/7xxUpRSSjjDLKyEhmJS4JiWwikVBZDRkhkZ1CkeyRmT2SkYzL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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  ImageSize->{85.01504211568658, Automatic},
  PlotRange->{{-0.2450350596067378, 
   0.24503500915341406`}, {-0.6366195036145169, 0.6366195398890077}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.4029040405539646`*^9, 3.402904055515478*^9}, 
   3.402905631621808*^9, {3.402905867140467*^9, 3.4029058727184877`*^9}, 
   3.402906467153243*^9, {3.4029066786373425`*^9, 3.4029066921067104`*^9}, 
   3.40290795610425*^9, {3.402914321767624*^9, 3.4029143459524*^9}, 
   3.40291438967527*^9, 3.4029154480671635`*^9, 3.40291567811796*^9, 
   3.402915720528944*^9, 3.4029174678815136`*^9, 3.402919270133024*^9, 
   3.402919347504278*^9, 3.402919857277296*^9, 3.4029200967816863`*^9, 
   3.4029229038580637`*^9, 3.4029229594580126`*^9, 3.402923196328616*^9, 
   3.4029374715*^9, 3.411390879421875*^9, 3.4113909686875*^9, 
   3.411391570484375*^9, 3.4118095416222258`*^9}]
}, Open  ]],

Cell[TextData[{
 "The distribution is defined to have mean ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["\[Theta]", "_"], " ", "=", " ", 
    FractionBox["\[Pi]", "2"]}], TraditionalForm]]],
 "; we obtain this and the variance in the usual way:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412416309272914*^9, 3.412416350412069*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"\[Theta]bar", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"\[Theta]", " ", "s\[Theta]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"\[Theta]var", " ", "=", " ", 
  RowBox[{"Expand", "[", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Theta]", "-", "\[Theta]bar"}], ")"}], "2"], " ", 
      "s\[Theta]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}]}], "]"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.402906540048061*^9, 3.402906595157304*^9}, {
  3.4029079409925203`*^9, 3.402907942674939*^9}}],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 CellChangeTimes->{3.4029069985173073`*^9, 3.4029079565749264`*^9, 
  3.40291435011839*^9, 3.4029143902260623`*^9, 3.4029154503704753`*^9, 
  3.4029156788089533`*^9, 3.4029157210897503`*^9, 3.4029174706755314`*^9, 
  3.402919274369115*^9, 3.4029193503683968`*^9, 3.4029198603617315`*^9, 
  3.402920099145085*^9, 3.4029229064718227`*^9, 3.4029229596282578`*^9, 
  3.4029231968493648`*^9, 3.402937477375*^9, 3.41139087959375*^9, 
  3.411390969140625*^9, 3.4113915709375*^9, 3.411809542283176*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[Pi]", "2"], "12"], "-", 
  FractionBox[
   RowBox[{"\[Pi]", " ", "\[Epsilon]c"}], "2"]}]], "Output",
 CellChangeTimes->{3.4029069985173073`*^9, 3.4029079565749264`*^9, 
  3.40291435011839*^9, 3.4029143902260623`*^9, 3.4029154503704753`*^9, 
  3.4029156788089533`*^9, 3.4029157210897503`*^9, 3.4029174706755314`*^9, 
  3.402919274369115*^9, 3.4029193503683968`*^9, 3.4029198603617315`*^9, 
  3.402920099145085*^9, 3.4029229064718227`*^9, 3.4029229596282578`*^9, 
  3.4029231968493648`*^9, 3.402937477375*^9, 3.41139087959375*^9, 
  3.411390969140625*^9, 3.4113915709375*^9, 3.4118095434248176`*^9}]
}, Open  ]],

Cell["\<\
The variance of orientation angle decreases as we increase fibre orientation:\
\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412416360456512*^9, 3.412416382408077*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"\[Theta]var", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]c", ",", " ", "0", ",", 
     RowBox[{"1", "/", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(\[Epsilon]\), \(c\)]\)\>\"", ",", " ", 
      "\"\<\!\(\*SuperscriptBox[\(\[Sigma]\), \(2\)]\)(\[Theta])\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4029074832643394`*^9, 3.4029075704497056`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx3881HcAx/Fr1VJDqyiyHrlEJJUjVOOtS93lR5Pa+nFn+dHkR3ESpVk1
1c1DHsnQHSvpXNGv6SFWnRMp4iLke1wO5+cdX2lKxVK2z/54PV6PJzMoyu+n
LxgMxlbS/6eNutip2vVuOSIV/9o2Gt+c+qFyWGSKlV/yn+zzpcH/7Py+RGSD
h4c1thbf0UiQFRhmi9ZCs0378bI3DX3TQLMU0RaY678TZ3Fo7OCWMc+IdkNy
crYyxZXG+N4h6a+iMOSHbfaJsaGhiEjUnhDF4876Ylf3KTQW0VbVejeTMeOz
sn3+jUHs4rZl/tKQjraxyGXFuwZhNZT/esQ6GxVLnljQeoMwnh6dbiTMBR2+
t5NfNAC7OS5Ganke0l5Fe1wIHEAAr2TaaZd8/HxWEao/awDfGzjp0Xk3cGyP
xs2sWIfu0gDBMeo2RoMiKkaCdfCgzKUfpHdQlOTKmGqgQy83hL2JXYQhnXBI
XapFcLRd+KHWu3A5kpLkc0CLkfsNtV+nlkBhoeqdMNaidrKa52FzD6qZf9CC
qn4UBmdZDvbfh42BtHBJZD/iEoaPHsiWIdU9zOqgST+S0i9MnraXQ3D7Kvd4
TR8KahfKDYfKkOlsbVMX3Yd5k6M37X4rh9MEs6TLvA/V1tRgp6QCZu2B/9rX
9iJmRRR7/vFHMBr2nzCL6cXmQkdHsWclkpybJHVLepH7SPfIz/oxNlxO1pM9
68Hi7VUDO8ceI9a91DTyWA9SHwbv8K58AvmcgnbZ8h4IH/zNi8+pApeh9veg
uiFxuPZpJKIavtZnkjNOdWOTq+faK55PcfFgbCxzRTdU5oUyd8safO5hzuW0
dCHtlJty+ZsaqNI27XEQdqEptvSsz/NajPsXBvBXdcFJF6SWXVTA6qm5pViu
QQrrWdSC/c9wmsV7VbBIgzADZu4tdh0iVMzVDtGdiNh/JSxldj24b1oUno0d
eOc7u0E6XI9CD5MeNbMDeQ/y62eUPYf+V1zfj8fbwf7EmLMnqQFp9iNMT40a
jjqLo4dYjbj8+1LBPJYabal8R/+sRuSFcIzDz7dhIyPFrU+vCazYD07rul9C
2mE2FBTXhIHeRfL1a15C/NG9T9jehIwqB7EiQwVfDd+W4/UCNd3KkRfaVmRP
NSy/VfQC7wQhuaEerejIWPx+pkkzOAFRd1ddbUHv8LL4qcJmWCRP2ygYVyJB
WLVF8qoZH6ySbNx2KqHS7g7t4FHwmxSlnCmg0Fi+vZgmNpklvS4gfir2YYwT
dxnfqeYR/+W5QTyXT+GgXQ2DRZz+p3UNhziZP364M5/C1rixZUXElbJd/s7E
VdMzdUJ/CquPmK4cvEpB3nnOIYN4LNHSiyIuvpd04gpx2Tn70HJiSVjCAjmx
97Utkkzik/XBnDfEocr4+WzibzNZ+bwfKeQ4tE1mSyk4Rq4YDSXeB62ZkNiW
Y4U4Yluvty7RxAv/MW09T/wgaFYMh3iMP2VGNbEybZ1uNI/C6zUTfs3Ely5t
nqYh1hq+z+kiDr7ux1QQUxUDThPEbyvCebnEdVk9iXp7Kdyvizt6lvjxofbn
xsQnVYmZccQyr5aFFsScvnNFgcRFSxtDVhMbjGQ3eBP/By8UeW8=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(\[Epsilon]\\), \\(c\\)]\\)\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\(\[Sigma]\\), \\(2\\)]\\)(\[Theta])\"", 
     TraditionalForm]},
  AxesOrigin->{0, 0.4},
  PlotRange->
   NCache[{{0, Pi^(-1)}, {0.3224670436281947, 0.8224670232200315}}, {{
     0, 0.3183098861837907}, {0.3224670436281947, 0.8224670232200315}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.402907572763032*^9, 3.4029079587580657`*^9, 
  3.4029143517907953`*^9, 3.4029143921988993`*^9, 3.402915452173067*^9, 
  3.4029156805514593`*^9, 3.4029157230926304`*^9, 3.402917473649808*^9, 
  3.4029192756008863`*^9, 3.4029193515300674`*^9, 3.402919861573474*^9, 
  3.4029201003367987`*^9, 3.4029229076334925`*^9, 3.4029229606497264`*^9, 
  3.402923198732072*^9, 3.4029374808125*^9, 3.411390880484375*^9, 
  3.411390970359375*^9, 3.411391571890625*^9, 3.4118095448368483`*^9}]
}, Open  ]],

Cell[TextData[{
 "The orientation ratio is given by ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"s", "(", 
     RowBox[{"\[Pi]", "/", "2"}], ")"}], 
    RowBox[{"s", "(", "0", ")"}]], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412416389898848*^9, 3.4124164336417475`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ORc", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"s\[Theta]", "/.", 
       RowBox[{"\[Theta]", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"\[Pi]", "/", "2"}], ")"}]}]}], ")"}], "/", "s\[Theta]"}], "/.",
     
    RowBox[{"\[Theta]", "\[Rule]", "0"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4029078283805923`*^9, 3.402907871712901*^9}, {
  3.4029116137637053`*^9, 3.402911614254411*^9}, {3.402914373121467*^9, 
  3.4029143744834256`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   RowBox[{"\[Pi]", " ", "\[Epsilon]c"}]}], 
  RowBox[{"1", "-", 
   RowBox[{"\[Pi]", " ", "\[Epsilon]c"}]}]]], "Output",
 CellChangeTimes->{3.4029116605810256`*^9, 3.4029143518709106`*^9, 
  3.402914392289029*^9, 3.4029154522331533`*^9, 3.4029156806115456`*^9, 
  3.402915723162731*^9, 3.4029174737299232`*^9, 3.402919275670987*^9, 
  3.4029193515901537`*^9, 3.40291986163356*^9, 3.402920100396885*^9, 
  3.402922907693579*^9, 3.4029229607298417`*^9, 3.4029231988322163`*^9, 
  3.402937480859375*^9, 3.41139088053125*^9, 3.411390970390625*^9, 
  3.41139157190625*^9, 3.4118095448769054`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.2.2 von Mises distribution", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.4029127327427187`*^9, 3.4029127405539503`*^9}, {
  3.412416473348843*^9, 3.412416476102803*^9}}],

Cell[TextData[{
 "We input the probability density for the von Mises distribution as ",
 StyleBox["t\[Theta]", "Input"],
 ". The distribution has free parameter ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Epsilon]", "vm"], TraditionalForm]]]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124165053248224`*^9, 3.4124165651708765`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"t\[Theta]", " ", "=", " ", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[Epsilon]vm"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", "\[Theta]"}], "]"}]}]], "/", 
     RowBox[{"(", 
      RowBox[{"\[Pi]", " ", 
       RowBox[{"BesselI", "[", 
        RowBox[{"0", ",", "\[Epsilon]vm"}], "]"}]}], ")"}]}]}], ";", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t\[Theta]", "/.", 
        RowBox[{"\[Epsilon]vm", "\[Rule]", "1"}]}], ",", 
       RowBox[{"t\[Theta]", "/.", 
        RowBox[{"\[Epsilon]vm", "\[Rule]", "2"}]}], ",", 
       RowBox[{"t\[Theta]", "/.", 
        RowBox[{"\[Epsilon]vm", "\[Rule]", "5"}]}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}], ",", " ",
      
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Dashed", ",", " ", 
        RowBox[{"{", "}"}], ",", " ", "Dotted"}], "}"}]}], ",", " ", 
     RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<\[Theta]\>\"", ",", " ", "\"\<t(\[Theta])\>\""}], 
       "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4029142652964225`*^9, 3.4029142987445183`*^9}, {
   3.40291521570304*^9, 3.402915255309992*^9}, {3.4029152858338833`*^9, 
   3.4029153269530096`*^9}, {3.4029155359034653`*^9, 3.402915537886317*^9}, 
   3.402915702503024*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJw12Xc41d8fAHDEvZdCZZQ9ykiSjLLfn1QKZRUNEUr2VspMZTVkJflGKKNh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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJw12nk0Vd8XAHCe4T2REioiQ6VClIiK9olKqa+KUBkjY2XKUJkqGSvhmTPP
8zzPmTJVppB5JsPzULxH+F1//P55b33WvWvtc8/eZ9971joC+hYqhjgaGhoH
7Gfnn65q1/dxKatLTR5uviMPiHDsd+XFw8Tb0H9e6dok5vVs8ce//HVBevKm
8QrmnFX4yZZpDGJln1d2PSTCJIcJpdDfAs4bqM+JYP7A1bg7s+w5nN2IU1bH
nHhCK4om0x5cDxTzemOuliafVo12AOfa9vtfMfdde1eT4O8CpW8u0rBqYvGE
WYQda96A862bHDqYPSS6rRPKXOFGkH5gEWaOC9Fl3/PdwFCJ5MqtRYSYy2b0
lAwPcPtmNOKOWeyG5H8CSV7gunU77R/msjtbgUrR74FX+vykgzYRfur6H4/w
/wRTfm+Tg3Sw5zkrJjNe7wsHuy+cldAlgr00ccC+xg8oxnHiPZjpQftYTBkR
BMTzX8s9IkKzfE2TVHEA3Hfb27OF2e/acfPm/EBIeeYW26RPhMPKS4UrGcFg
NR4V7vCYCBN31TU9U0Ogt0Ttm74hEdLUyrZ5kkJBq+iKvaoREWS03a5fi/4M
winPLt41IYLKU66+EP8ocBX+kVT5lAgsMlAVpBgNF+RG65aeEYFcYsU2Wh8N
ryRCDMUsiFBY0V1gWxMDwi2MMnVWRFCoj96KLIsDucbF//TtiSCk2Hnn9/l4
mOgdyR99QYRdTQxxZ4vjoVy9Kd3sFRHaWs0UG/MTgNkCrxHqRATtLknfpYwk
uPzEvtX0HRGQuvHYRdFkCP7AtizlToSjvaGS7qnJIPNytJjZkwiz/Vu93Ekp
wHxK4GzXe2z+xhsFrkSnwW/j1EO/iNj8LGvlBflngQU7Nzk/gQgfOcNkq3dn
Qxwx5d2dZCJ05LjxSalkgyHO6fNaKhE0Z7UmD/dnw4U753VNsolgrslstTyf
A6ni2RldWB4C5Ew8Q/fmQzqufd9AFxF+/VJ9wqqWD2ki48VnerH5twNl19B8
EOKhHiP2EyEpcz/HM8ECGPmRbfJyjAilfPVRSLIQTMSJPF1kIgzTChZNaxTD
9LPx3oY9AXA0cneYVngxhBuRNPvZA8DkAtWxfaQY8pm6NjYOBMCydZt8mWkJ
vJ4mpD7iDwD6CefvPg6lkCBGMqs6EwDCDf2TUlHl8FuAZm+zegBcrFfaJf+8
GizOfRa5lRoAe7sSf0gTq+Gg4Xk6v6wAmBjDBZ7Kq4ZTA4/FRvMDwIemjI9r
pRrCziqGxVUFwNhFESmy9ReQxCV75PwMAM9cZr1I6xqovDM0sUYXCN1RrQXr
VnWwfWsPv4FpIKRlnnAg+9WBVXajF79lILyueIemcupA3W7kwqxdIJzsl21p
X6oDyXOFgbHvAsFxf8ZIslU9BKsqH0mODoQjHz8ya1g1AFfzeWfW/kCwfKX8
KM+yEbLun/js/SAIlMxlkwm+jdBfM/ur+FEQHNEXXtTOaoQk+prdf0yDoPsG
oxOB1AgFkmec/F4FgRxXZYj2kybw1oEw0/Ag2FV8qg1v1AxuG9qbwWNBkPCX
BbQ0W8Gc76rZhZfB4Px73S3nVStEFLMK87gGw/3BmVbGsFaoK/dQYPkYDCz1
dQ9zelvBkLUy/0BMMFgHONoxqn+DhKXq+YGmYEBn5zOy73yHgODILpHDIfCs
2NAHd6QNGJZuOch0hGD94S4/rWQbHByMGdsaCgHyL9nc7SttcIGieaJ3LgRs
Nti7/xm1gS6TSlgtQyi8ulTDu5baBub+badeXwgF97rDGXMS7aA3zsQXg63j
6Laeli75DsBfM07d6xcG+o9qtTtVO+BKwbbHg+gwOLKcudj+uAMqBF/2FGWF
QSK7O/sP9w44EZUoVPA9DDLUJTWbmjvAgHoeX7D7M5QO+M5WqHRCmZjN9aFP
n6Fr5gZTkn4X5A6pOb1JCIfF0BNXXa27YGX+h4hlYTjsuol/o/u2C7iIK1I2
X8MBZdRRDsR2weGe+fzy3+GQZgUznqNdoFP4temueAS8XZf8aqb3E6TSundH
V0aAOAu/m5hON7yj9VqxJEWCUsVW9S7zbtj7cX+BNC4KHpsP/pty6oZfNvFf
9++PgrC2MJuoiG6o4tC7dvhSFDAGcj7eO9gNBq7RLmqfomCAl1lhWbMHwp+8
W5c7FA3e4qs0hQ96waQ37IhkK9a37G+ITJn1whjv8HJGbzSYVoWr7XfsBd0v
y2wyk9Fw/bZCql1kL5zj9XnvtBUNeAtfVenxXvg+zOf+40wMvMsUTix++gtU
qjIKoz/HgPMp3ZtlLn0Q+DFbzN0xFsxtc23nfPsgqDo78fT7WNCuYIg+FNsH
TLxS2wuhsSD7X/ofh7o+ICR9T40pioWNp9QIWaZ+WO+yeLS4Egsv0onkCv9+
4Mx6d1fGMg6sRBoDqxMGAJ1mlRd6gfVRw4nX0YUDoAysTkxe8aAeTfP09dcB
8O5SaaUNi4cLnOfl0e8BiLZKYpIojwfcdgqpSnQQ2O/l5hFpE8C/471iVd4g
2M011lv5JkDuy9vUii9D8GMil6xclQhH859MRHQMgX/ZDxXGzkQIInn8cBof
Ato+YOueSoRXBtUJcgzDUPlvD0cVaxLI/3dGpeL6MPxZZL5dqpsEnfzsaeU/
hqGd6fmiOWMyrBs8yRw0HwHmoJd8scYpoMe28qLcbgSER6Ka2JxSoL7ylcJn
5xFgeTo8F+qfAr5c3r33fUbAa+sT7Z+KFDj+IxnXlTECNWOxah2cqXDvwpR6
8/wItCbu57zdnAqZex9tF5qNAqd6BIVJMR04KmeaAq1HwdrcS79CNx1ePrEM
sHk1CsMvvlZ8eJEOVxpcTkp4j8K+3fqVLqnp0O8QqZqRMgptgcdPlu7JAMJ0
f1LczCjsLy/Afx7OAP0K9Tu+RmOgEEaTPhmYBRKFB/dxWYzB+ZHl7pL8LMBl
9XXG2I+Bv1mtbV5nFsRG62jkeY7BrF1lPzNTNoy5Gul0p46BpHGq/b3r2aCv
ZPeUZ3EMuJ7+nPFqxtwT6JlsPw7N6faIfygHJNo0lM68HodnM6LdzOQcwDVx
sZR6jsNLTq0FFlwuxJZGfGoJHYf4F4pbt4VyYSwiIYhUNg7Ud28uD1jkgv7j
gnhJmgmwjhpUFMTngcFSV3W15wRcUhI9s1cxH/Re+WoU+04A7OXwe/EwH7To
bpGyQiZgzNhfZ/VZPqhz1h6KSp6A/endQRKB+XD9fI6dU+MENILij6yJfBB7
81H0AmESLFw9jrV5FABl77WQPI9JuD936+3l4UL4E0ornvZpEj7o4QLe/C2E
JcGK+tjgSbg6FNbxi7kIZiUlV/ySJiFgY+tMp0wRDN4XVLb8OgkOrxQ254hF
UBO9RXcKPwXc8xqszcrF8OF0kUWi+xTU/Py9OdBTAs0SPVO2PlOgJXbR+we5
BAhSa9pXg6agjbTr5ABTKbw7L31rImEKzn+TWVeQLQUH+aITgvVTcGCIaHUn
thTM7hWNRtBNwxM9HWar52Wg+KJINfD1NDj5DQTZClfAu1c9zY89p0HszqO6
nmsVUOO4dlnSdxrmqg6tqRtUwKU30qc7o6ZBc39ta3p4BZzzLmJhq5qGBr2n
Q8V7K+FoeFH9h81p+GN6b8h4qxJw1UXS717NgOqamrrRi2pI3b0vcfPtDJy0
YTYf8qoGFc2nHPbvZ+BQ1mdT08/VELfKv2QaPgMrPQU3iyur4cop79TblTMg
O3/8xUXGL+AepsV7CPcbfO+pPZwM+QK7bGnpcr1+Q1jk76Jz32ogt0bTSsT/
NyRcjuEWHq2Bh3sLh+PDfsOk1R0dib81kJZmVh6c9hsWv3M3vuGthVtjnbZO
336D9Yz3KK9FLfjcTpy5zjYLCtaW9A/21wGb8M3vwyGzcM3FlvWGbT1M4aPY
GqNngfls1pCVdz2UTi7fy06eBfn3lE+ZUfXwOCas/3XxLLCKvPxq0FwPxQdn
ZwR6Z4EYe3yykr8BdPBedI8PzEFsr0ukfHsDpE80yMwEzsF3RlxW1+VGuB4l
H0f2nwclVz6uNIMW8GhsG3z7eR4c6EOTDF63QMOSzkHO+Hkwquv/fS6iBa5e
cfh4vmAeVvDlZad6WkD+d5792555SDPAkbRvtYLs2WO3OHgWIOnyW6bOi9/g
9Ff8X+mEBTAsvjOlI/4DDiy2XnMpIoFH3v5274J2CPGrevS7igTXq+Sq9n1t
h4OSuY6qjSSwcuaOS+7F/DI49/gvEhhFld/b2mgHbjr9w23rJBhQ7Aq5q9AB
hw+s/eW/tAghtYqioV0dIAQCCTV1i1B72d02n7YLwr6W0tKZkgE5T+jvde8G
Wd7L2/yPl2B7XYBPtakfREb2TjjZLMPJ7lNfy3lGISN5n0mB9QoUMO9SYX0w
AY5D2p0i7n8gh0uv4vXMNFjJytyMDPgLJ4XMZc9IzAGNeYDLp5C/gPfaupEj
Nwc+UeS81+F/IV7j8gXhG3OQikvhMYj/C1nORq6MenMw1shFOp7/FxZKnv4z
+jgH99Q2fHM6/0Lz1dT8kqk5OGde2V23bxVcmCR0ZYjzUBfFzVy4fxX0psWu
FEbMg0q7HSRxr8JZm1sHRJLnwVxSPNlLcBX6DWqUqOXzkLQe9VJZYhXk9grI
Ck3Nw0GPNzy9d1fhnIgfa8G5BViPuqI/57sKrjH3LC61LcClNTn/M4GrUETX
O6rQtwBvlKVr7ENXwSyHz1l2YgEImycF6WNXQZwsPc9IWQDOh3vGePJWwbZ4
Lm3rMAlOc/Q9Uv65CkIZtTpmZiR4/qTTL+DXKhBP7DkZ9pwEhTWtX/oGV6Ek
S5yx3JEEclZVAsZTq2BzsKPgpw8JlL7Hj7qsrcL8vrtcurkkMPS0eJTDtQbn
36yml62SIHnYxG+Ndw3obFaX6bdJMH9O/4uc4BoMtbPdAPwiWE/eE2gWXgNi
N/2M+4FFeC1/YXTs4hoE2DMq6kkvQtg/+kccOmvY/oP0XsxmEdosw/TsY9cg
vMo/uHt0EYR9927YJK7BnoBpxbLpRXDNcg+0Tl3DvhvZrPwWFuEcybr5We4a
iM5kMu6jLkLEk5uSj2vW4OxqW0gOngxmRv/wd8fWoO8/h7xIHjLUuVnHKk+t
wdTGkUhuPjLwJszI3ppdA00p9n8+AmRoG++yUlxeg7J8XtpHQmSQfpTRL4ej
wPbgZkWKOBnotXSyhAUpkH00JLwZkUHHoevGCSEKXFAoGG2RJ0NRmNLEMWEK
DD0V0K6/gsX/dY5LQIICKopGv6Ovk6FdfY/rAXns+v61DeptMgjbufFyXqNA
HHgEl98lw7vAjaJ9ShT4j77ktr0qGWS6pud3q1CAQD2666c6GSLvVqvT61Mg
9TJO44w2GSiW55ZojSgwZiLkka9DBhXf9PfbphRoZPxUIa5HBoYfIdXrVlj8
6S0JVgMyPL1lJbz0hgLmEcz/zEzI0PBkuo7kRoHlm0lcmdg65HuvrTvvRQFZ
2w/Cv83I0NF0I2DajwK6N0p5FZ+R4byi4NZgDAUsGzXZYq3IIBnX7Pk1gYK9
59n8oqzJILZtzZ6TQoHcw8pXA5+TQbCo9sS7HAoYutNcNbUlAw/707xnBRTY
/8b0o6IdGfZbcFzSKKHA6f+A/rA9GZiPG6oKf6FAxuFE+7wXZGB03T3EXk+B
fLy/lfVLMtAMF5hsNlIg2i864OQrMvwJYnRua6OASJrZ3dcOZCAtZxJKuygg
Y/N7hs+RDDPKGsS4XgqsabAlFGEeZExOthuhwOV+a+xDjgy9+nfO6k1QgONl
b9ptZ+x5KykVN2Yo0HUWlr5ibuWOuX52ngK+w4PqMi7YfNnd6OQhU6DPjtIf
jbm6Y0mb8Q8F9vKOuNC+JkOpWNjM4hoFXPhXLj/EnO8t//zXBgVU/4ULpGHO
mprdrNmmgMlD9cN/MKfKEz3T6aiwzJEgLfWGDPGRF9mD8FRYlOZ5Zo45cn08
woWZCu9wWpVRmEPUP5ww3UOFozNsIk2Y/XMl81TYqeDlR8mdxfyBdVBO9gAV
Agd71OjfksHdzK3x2CEqbI6+Y9+P+U3DKdU9fFT4Njc6x4fZUbB7kCJIhQaX
oSEBzHbOziZjQlQIeGg/fwizZZ/QSoswFb5bFnKwYjY798OpQIwKk6RcDQoW
77G/PSFKggrtMn4FfZh1SHxEz3NUSPz9VqwA832lRl7rC1RY62io8cCsmmiZ
rHmJCvv+JVurYFbGcZ29Kk+FgzFvL3Fivq7zpULsGhXGzpQKtWHzI19qev2g
EhW+3qkVccUsu39fJ60yFU63H1YWw3zOulR77i4V2Aof+rRj+Tj9XX+mS40K
gqf3LTzFfMw9bzNJmwryr2MJH7B88o9pevo9ogLt+5WGPZi5L9GzOxhSofRT
duJ7rB5YV++dUH5GhSuvF789weqFoLKZK21FBaZClQNtWH3hMhPkBGypMPN8
wk0U85rhqsofRyqki091f8Pqc/lL5ODgaypYi0eX7cM8z6to8vUdFTbyeJpv
Y/U88jPYKewDFThaXpvmYvXfdPV8Mgqngkp/fS8Xtl5efHUWc4mmghYbStqF
racTN+ryK+Kx+4kGSsuWWD5v3f5yIYMKzFx3DySak+GKqmGfZCUVDu1TY4nG
1u+frlS95zVUuHpNpFoRW99x6uSpnAYq5GZ/05wywsb/0GFF7AcV3KTvqxEe
Y/Wr58dycgSb3wmXmGGsn1iOdfsbT1Dh2AWZ8UtaWD94zMOVOIPNR/+Vo4EP
yeBsnHTsyBIVsqJMcoQ0sHyYV1zixa2D9/N19SGsnxU5/LZkO7oOMd77aOKA
DEabYmu3T6wD3og0+lwOW+8uNk4+ouugu59h++JFMti83fZilloHDdOj/3LO
kUHCizOO4do6fN3r5ix1igyZQZd/Uo3XQb7VqCzyIFZfBz00ZZ6ug5gs7YtJ
TjLsDmsdtbNcBwcKf/kRdqy/RWiQVl6sw7dvx8nuu7H+Gv8MT/JaBzNp4agZ
WjIk5ISeH0tbh8feYWyyHYtgtqEp3Ju1Dk/gI5946yKcvnr40Pe8dbAedWLm
aFiE8t7YfyVl69CkWZ2QV7IIndtpVX4t2Pj15OhuRi8CrXLl1ctz6xBELokZ
N1sE7dmxu9HCG3CLrvf1Luz9KCiZIB8ktgFvO8z0lEkkmHEyPvtBYgPSvyh4
uE2RwIZtnuPFhQ3gUmsZ+NZNgvcyf3tuK23ABwUKobGQBCXueJ1t0w345lWb
8syGBJxHRM10UjZguq/1fv/UAvj6v1dPydjA+qTQvv6BBdiFm5P/k7MBDntY
u751LADNaMoh79INSLzmU/qhcgHmI49/K2jZAHMHQU7rwAWo4z5yejdpAxQ3
s5Tm0ALY7ONeLZP4B/TCp//wfJqHDlrCW67yf8DFPy7UyjIHBYTniW1NmxB/
1ShI+cs0iHLuNdOv34KEswXWtq8nYNFnleNs9zZEqagbPcOPwhEPD3ELMxpE
8zCecJ4wAGMP+/vkp2nQv2xlBe26bmCR00jS+02DrKreGh3M6gYpvs7nznM0
SJLFzXU0tBs8x5tZShdp0OsJzdIIi24Qf1p66QyFBn2RK31deagbHJ1CY/mY
aNGLpkTZeLufwBmtYfZPmBaV4/8cZJPuguuTndQCc1oULsp5KnqsHZxEfByy
LGmRKu/k6/0d7ZBrdX0z2ZoWPX7aIxj6pR0ObZXThNvRotq3aTdqo9uBtD8R
/9aZFimk+s2l6rZDwPUXnMo+tMjJck9g/XAbjKTxnJnKoEV2oh2Joh0/4IW1
ocn+BVokZmRR032pFTxvkowvLNKit4MNd+0EWiH4qL2xzhItangv2HKavhUK
uz2NEv/SovT5FzdXm1pg5UL643NbtKh9M1u4Rr0FzOlW9NT34FAft5eWim0z
GAS8fhB0BofG3R0uUuobwfoZ04PSsziU4G7EMpDWCG+v+d8fksKhSwrveX/5
NUI0JU5D6AIOZcVXNhzWaYQhra9qhfI4JDh6L6J77SvcP8aq0q2KQ9u8u57P
iX8F5cLPSvvtcGiqRA2HcuvBZEV/m/MFDnE9sVAsCK8H19PC+ZyvcGhVKmL2
kge2n0kt5uV0xiGJ4OIDn7TqQTDqJ5ndHYecXf6LEyDUw6rHnmC2IBzi8P0n
QG9QB5EPXMdZCnHoZITfrP7xWigOUgphKcahSr93yUoctdDZyfYfSykO9Xvc
4b9KWwsE5ehC5kocav4lQLDurwFr+QqvXQ04BMcOKKT61sA1kTVxQjcOcXKU
F3hufQHSPzNHulUcSn7xeD5quhoe3L95krqGQ5+tdz/j6qmGujyRbhIVh1y/
xajENVRDqNm8eN8mDr36e4N7JgHbX/Y+G89moENmIgdlJQ2r4XOepZIOJx2y
1ctKDP5WBdfN7A6WSNIhkrQtv/xcBeTVq9dnnqND5wuYVnm/V8BhAWnreBk6
FGjk/PJATgW2b11r+SRLh9K6mU8Y2FdA5NWXLkZX6FC7jbH9Q4YK+MPvOMV+
jw6ZjtQE5gmVQ0zPm3zz53TI9fDzC8bOpTBVf3rYx5YOxf5YqI7SLwXR/GGm
LHs6NG1Uk7x2rRQKfeV0Fx3okK8h+zGGvaXQeoPKZPmODm0I5n4ixpUApcxS
1yqQDjXNKN5/3FYMytG6u2yK6NBnJCq7CxVBgA+rVEAJNp6waanV40Xwy7FC
N7+MDg3q8K1s7imCxw8OFfypokOn/vpf1xsphJf7enRtG+nQpBDSePa2EOLf
KRfY/aJD++pObPi2FMC6iZzeyw06NCy92XjZKh+UyoSR7SYd+nGXlb9LOx8+
7z7Ib7VNh+6JTZQ7KOWDbO7ysAkdPdI7lmSz62g+OG8k6d5npkcXU8RDj/Tm
AZ3PPl3pQ/TIjonSLHElD1jyprX/XqBHtzS9bGREckGL4afckiw9avHcVrzF
nQsZGjW8C5foUYH39XFrplxQ/hc+OCFPj/oMzI9RpnPA96qKdpcSPbLYYGgc
ScgBjt5yrbyH9Ogr58Q57mM5wLvpp2n1ih5FFrZfzzydDdfH/isJdqRHDqQ6
ugr+bLD5ynSg0pkecX8SOjK8Nxua/d507HKlR5TsY5alY1lgJ2R1I/49Pfo2
f7DU0SgL2m7fke4Jp0fvLx/rpLPNhLexrOxyVfRI7WNfDjU9HTI8mi0NvtCj
x2xS7ZF+6dD71P27Vy092sUbSzS0Swcx6S2v7q/0qOq0irEGSof+lgUayzZ6
NKcwwNX4Mw0k/7aSYkfpUe/VxuRyxjSYUnzfTKBnQF7ZV4WXXVJA/6Ye/zFG
BhTmwdRMNkmBQWUpu8sEBqR86ZAds0oKdKkNC7xiYUCL+CnrgKMpUGNw9uUc
BwPy/pb+bqk5GSJc+o9/P8aALt6NjCvnSYZ7RSJuREUG5FZXbVrTmQhtpTT9
WTcYkIDny2nG6kS4WfnzdOtNLP6acaZBeiLI17sM0N9hQMkN80mGbolwurPz
rN19BjQdG4A8ZRKBZdFh7L4pA+LbtDt2Oi4BaoVa4fB7BrTe/6P/rlc8KPkM
K+3/yIC6MpMsP76Mh7a/y2qsnxiQ5an62/2m8TBUx/V0y58BQQE1IkMpHij6
xiFDYQxoFseuIbw7HkSjcEuRqQzodvKY8fPAOAg6cD6Wr5kBNT8oSfySGws8
LrcyDrQyIDsZvRGBhFiIm9It3vOdAWn/lOP0D46F7AL379vtDIhGgUY01jEW
WlS71od/MaA9Pf5nXBRjgcbXQjX6NwMSMVTZ4B2JATNCIr0AEyMycy1Rc+KJ
gRac50cFZkZ0+JSHSPWeGBDdNN1vtJsRtdJlmrPTxcDi0qkTaWyM6L9RraXZ
39Fg019wU4qbEWke7enXLI4Gp8x6/xsi2P1ereJS96PB994kv/V/jGiakdhG
vBYFS8pfUwJuM6JH7ZHrpNNRoHIjRaLoLiNSOscXYXQoCjgvPbvyT40RuT4c
aE4lR0LY8b/G7jqMqJ9ZSNk1PBLi1+mzwiwYEXOaQfwDagQURR+Vq/VjRJWM
7rZNDeFwdPuKwxciI6LneYHPKggHX23DkqpARiT+ukgsNT4cTLgTpcpDsfhS
WRMjb8OBO+C4WEEMI6qSyfL6D4WDo4cwX1IOI7oQaLCwt+ozyJufpn3fzoia
XScMs1rCILP1Dnh1MiI/WuWewxVhcEjEysnjJyO6jf+lHJMZBn+mc6iuvxiR
XqQqw7BfGCQ8OrvsOMqIRPk0PS8+CAOC2rlx8yVGlEyU+2cyFwrfL8rWq7Dh
kVvwbvlDvKHgXWy7cY0dj4Q8HFsZ2UJBUSrrzEVOPFrjjHmPYwiFajHByCNc
ePQoI+Cp8EII5AkQ7P/w49FnMTPeC5UhEILvOhF0Go9ok0uibhmEgEHnkw+/
buPRITeS/mBxMPDfSaj5dheP3j39IpGfGQwDrUOUL6p4ZKPv+yY0PhjUG+4a
pmrg0VstC7NPvsFwvUT6koMuHilnK7MdNw0GsSg6Mo8FHn3oWxff4AkGitln
VT0fPEp/9EV6yicIPr2Kw7v44lHuxRaFKrcgEPJOK4vwxyOVyNHcJMcgUEsp
O9IfhEeM3DNuiWZBkDvdv6IWhUfHT1wOeqgYBE8f8wTczMYjlgKaR350QUBn
c/S6WS4eNSDftIcbgRDmKvrPMx+LF3TUX2IlEJpiZR83FOORlsJnetbxQBAa
1ZK8/AWPDsyKy1rXBsKIdkTXuQ48iuHbf3zKPRDsnyV4qnXh0TSP/TjRJRBY
nTJkbbrxqNrZxvv2i0CQC6+Iz+nDo/N3aszJpli8vkEb0XE8yiJ+tO75LxDu
aRzmFPyDRyuxW0VnDgZC450otd37CWjY0Pv7z8IAMKubrMQfJCCRVqE4n5wA
2C0jegLHTUASPXOBKukBoMJXsr7KS0CfQ9nKN2ICoH+hI2rkGAHJfWq43/Ex
AEjejLN5UgRk1HvU6r1xAPhu3VLNlCYgT6tt2RX9ADhrTSxPPk9AD/K+1xvq
BMCLB/yfIuQIaIDcv2amFgC4ExckPa4SkNTRIIW/CgHAWf/M+aEaAcUlPu6i
PxIAxTL50/c0CCixnX+Wky8AHqav37n9gIB8Ig+ZnjkUAJFEjyNXtAno3Nu0
Tx7sAXBCP6bxlCEBsW/w/suiDwDZ7a59tLYEFBrTZLAwQ4Qh60OOG3YEtK/j
xGzsJBHeTD2a/PuCgA40sRH1x4jQ8I1UNOtIQMUvfWVpBohwO5yg3fWOgA5x
PHmT/4MI+udlk5ICCIg3+3vAZjERhuGuT2sQAVnd/FjEXUgErWtGtksh2Hg+
TTsp5BFBXdVX4WIEAZn/4p0syiCC0rOJ4e8JBDR+kJAlEkeEr8+pDStJBMQi
GO+SEE2EK69YMw+mEpC3PalLOJIIlzxkHPUzCUjHUG1bI5QIEjEfDq4WEtCK
sevKRV8iZCXFbHOXENDe7bNebD5EEM0snIIyAgoza/dcfk8EobKRfK8qApo0
SC/p9iAC90/Ju7yNBOS6ZOF7/DURgvtvyMg3Y/mJjj5y35kIHGM6fMatBPQj
l2dXgCMRWBc9F7LbCMjGe7Dh1Esi4JgGva78IqDcSb3yGWsiuOxZtjTtJyAX
jgeJz62I8I8Tf99nkICOn2FrZ7IkwqrgGaHeUQLiE8we0XhGhOcnr+3eHCeg
nzOFX/Y8JQJZXPOPwBQBqThU9HeYEWFW1q3mySyWj8qyvFcmRDBWCEvxnScg
jsR75rrGRJi4keVbQCIgVCuuedsIy6f6L53tZQI6pRldf+cxETS1SVeP/iUg
6rIG0jcgQq8B3akbawS0/idw2lmfCB2Wpzb8N7D6uxVW+EsPy6+9/FjRJgE5
q9INHMDc6qTRNLBNQFECMicf6RLhxrun2bQ4JvRcVCKiQAerD+83wUL0TOju
0vo5TswKfkHONxmZEHUl7a+LNhGqg9MMLQlMiLbCvPevFhHkIqtvBe5iQtd7
HYfsMJfG/zxbysKEkjr58HSYpdNmuYdZmVCUXM7dME0i5Ods09KzMaFz8WEV
spjPFHP8PsHOhOaIakqzD4mQWXmy7T9OJlQV9GQtFrNI/aUi6wNMyOKsXZ0R
5uQW1chgLiZUMH84RwrzsQ4Tt/JDTCgL8VXswRzb6/R0lJcJ6SajmT8PsHpx
X+9cwhyn3nRtx4Vn7S/iDjOhzdWBpJ3zTy0+lruOYBbYnWC1jPnPFYPkx5jj
vIqPkDE7Lw/vscWMrw0JWsRMiNayd8NMnadj2THvhtq1RMx1bA5bC5iv5Vyf
mMZ8JWyedh5zm079TQpmSdWjXnOYH7LI5xH4mNDDjal9O7Ywvvj2JObMg7vF
ZjGH8IrxP8Fs6jrwdgazYEuqhwPmtZwnh3ec/uL44nvMkd/dyqcxf+nkr0zH
nNH+kGbHs17sWiTMPhseiTvnvWykfWu3MDsFm6vveGuCRWQPPxMK5h8h7Jgd
Ma6LY16kGthOYI5cePsIYf53w058xyc+bzfewdzpzj4/jll2lRJshflTA+np
jhvibLffYFZqEj2z4zt3l438MTsU/10bw2yYPieVh3lT88THHZMfmETUYhbd
66+541f4SfouzB+y3UV37KM/1PkHc0LB3u5RzAf3al5kEGBC8tyJmTuOreiJ
5cT8y6zBa8eiT+7tEsKsnWRlvOOig+1W5zB/+ZGkuGP5hv9+XcO8PW4ivOPW
581IAzPTRP6eHasLKCYbY+778X5t57zcyPfaPS8wGyctjO7YzBHZe2JONev7
vuM/JyuGQjBHcalU7ti55/y1FMwX8+9l75jgVphRgtnlwlj8jnlGshz7MM8y
RQbu+MzFlJsbmP9/Pu9/RaARpQ==
     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{0, Small}], 
    LineBox[CompressedData["
1:eJw123c81d//AHDuNa5VyTVDRiJKZnyE1yEUysyoUDSUMsvITJkpGZklsrP3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     "]]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"\[Theta]\"", TraditionalForm], 
    FormBox["\"t(\[Theta])\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.402915287085683*^9, 3.4029152910213423`*^9}, 
   3.4029153278943634`*^9, {3.4029155600581985`*^9, 3.402915568109776*^9}, 
   3.402915680942021*^9, 3.4029157236834803`*^9, 3.402917474150528*^9, 
   3.40291927604152*^9, 3.402919351950672*^9, 3.4029198619940786`*^9, 
   3.4029201007574034`*^9, 3.4029229080240545`*^9, 3.4029229610903597`*^9, 
   3.402923199202749*^9, 3.402937481390625*^9, 3.4113908848125*^9, 
   3.4113909708125*^9, 3.411391572203125*^9, 3.411809545187352*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "From a polar plot we observe similar shape to the one-parameter cosine \
distribution. Note that there is no upper bound on parameter ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Epsilon]", "vm"], TraditionalForm]]],
 ", so greater orientation ratios are permitted."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124172742104254`*^9, 3.4124173460337024`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t\[Theta]", "/.", 
      RowBox[{"\[Epsilon]vm", "\[Rule]", "1"}]}], ",", 
     RowBox[{"t\[Theta]", "/.", 
      RowBox[{"\[Epsilon]vm", "\[Rule]", "2"}]}], ",", 
     RowBox[{"t\[Theta]", "/.", 
      RowBox[{"\[Epsilon]vm", "\[Rule]", "3"}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", " ", "0", ",", " ", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", " ", 
      RowBox[{"{", "}"}], ",", " ", "Dotted"}], "}"}]}], ",", " ", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4029142652964225`*^9, 3.4029142987445183`*^9}, {
  3.40291521570304*^9, 3.402915255309992*^9}, {3.4029172224085407`*^9, 
  3.402917251099797*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwsm3dYzv/3x6OlJQklJZFSyU5IjhTSlIQWES3aS2nS0BDtJNFQaQ91t0+7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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwsmnc81u/3xyuhopRSGlJkjxI+ITpmZGRnRUZJCZEoZSaZRbcdheyRvePY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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{0, Small}], 
    LineBox[CompressedData["
1:eJwsWHc81f/3l+wR0hAtokK2knmkhKwyiszKqHvJSMieWSUtZIRC9siex573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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.402917426051365*^9, 3.4029174754223566`*^9, 
  3.4029192771230755`*^9, 3.402919353022213*^9, 3.4029198631056767`*^9, 
  3.4029201019090595`*^9, 3.4029229090555377`*^9, 3.402922962131858*^9, 
  3.402923200254261*^9, 3.402937482375*^9, 3.41139088740625*^9, 
  3.411390972765625*^9, 3.41139157321875*^9, 3.411809546108677*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "The orientation ration increases exponentially with parameter ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Epsilon]", "vm"], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124173612756195`*^9, 3.412417388735104*^9}, 
   3.4129350662235136`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ORvm", " ", "=", "  ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"t\[Theta]", "/.", 
       RowBox[{"\[Theta]", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"\[Pi]", "/", "2"}], ")"}]}]}], ")"}], "/", "t\[Theta]"}], "/.",
     
    RowBox[{"\[Theta]", "\[Rule]", "0"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.402917375909264*^9, 3.402917391071066*^9}}],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"2", " ", "\[Epsilon]vm"}]]], "Output",
 CellChangeTimes->{3.4029174262917104`*^9, 3.402917475632659*^9, 
  3.402919277303334*^9, 3.402919353182443*^9, 3.402919863275922*^9, 
  3.402920102099333*^9, 3.402922909215768*^9, 3.4029229622820735`*^9, 
  3.402923200484592*^9, 3.40293748246875*^9, 3.411390888875*^9, 
  3.4113909729375*^9, 3.411391574046875*^9, 3.41180954613872*^9}]
}, Open  ]],

Cell["The variance must be obtained using numerical integration.", "Text",
 Editable->False,
 CellChangeTimes->{{3.41241740115296*^9, 3.412417421001501*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Epsilon]vm", ",", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"\[Theta]", "-", 
             RowBox[{"\[Pi]", "/", "2"}]}], ")"}], "2"], " ", "t\[Theta]"}], 
         ",", " ", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}]}], 
        "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\[Epsilon]vm", ",", " ", ".1", ",", " ", "3", ",", " ", ".1"}],
       "}"}]}], "]"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(\[Epsilon]\), \(vm\)]\)\>\"", ",", " ", 
      "\"\<\!\(\*SuperscriptBox[\(\[Sigma]\), \(2\)]\)(\[Theta])\>\""}], 
     "}"}]}]}], " ", "]"}]], "Input",
 CellChangeTimes->{{3.402916170976656*^9, 3.402916227537987*^9}, {
  3.402917854417325*^9, 3.4029179087855024`*^9}, {3.4029180645094223`*^9, 
  3.402918064599552*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{0.1, 0.7728391151545765}, {0.2, 0.7241873209005355}, {
     0.30000000000000004`, 0.6768403704938298}, {0.4, 0.631093567279501}, {
     0.5, 0.5872008359171874}, {0.6000000000000001, 0.545369226115546}, {
     0.7000000000000001, 0.5057560534499226}, {0.8, 0.46846860192246587`}, {
     0.9, 0.4335661050365866}, {1., 0.40106357470632903`}, {1.1, 
     0.3709369689112919}, {1.2000000000000002`, 0.34312917600702364`}, {1.3, 
     0.31755633355580043`}, {1.4000000000000001`, 0.2941140754852901}, {1.5, 
     0.27268339583302104`}, {1.6, 0.25313591521398254`}, {1.7000000000000002`,
      0.23533842634487956`}, {1.8, 0.21915667068299938`}, {
     1.9000000000000001`, 0.20445835654662117`}, {2., 0.19111546995278228`}, {
     2.1, 0.17900595470215586`}, {2.2, 0.16801485080758427`}, {
     2.3000000000000003`, 0.15803498331734012`}, {2.4000000000000004`, 
     0.14896728986618563`}, {2.5, 0.14072086739818251`}, {2.6, 
     0.13321280840098026`}, {2.7, 0.12636788614571254`}, {2.8000000000000003`,
      0.12011813776522576`}, {2.9000000000000004`, 0.11440238418848069`}, {3.,
      0.10916571726577826`}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(\[Epsilon]\\), \\(vm\\)]\\)\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\(\[Sigma]\\), \\(2\\)]\\)(\[Theta])\"", 
     TraditionalForm]},
  AxesOrigin->{0, 0.1},
  PlotRange->{{0., 3.}, {0.10916571726577826`, 0.7728391151545765}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4029180666625185`*^9, 3.402919277814069*^9, 
  3.4029193538634224`*^9, 3.4029198638066845`*^9, 3.402920102620082*^9, 
  3.402922909716488*^9, 3.4029229626225634`*^9, 3.402923200795038*^9, 
  3.402937484203125*^9, 3.4113908909375*^9, 3.411390973234375*^9, 
  3.41139157434375*^9, 3.4118095463990946`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.2.3 Wrapped Cauchy Distribution", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.4029191845199184`*^9, 3.402919191600099*^9}, {
  3.4124174336597023`*^9, 3.4124174350917616`*^9}}],

Cell[TextData[{
 "The wrapped Cauchy distribution is input here as ",
 StyleBox["u\[Theta]", "Input"],
 ". It has free parameter ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Epsilon]", "wc"], TraditionalForm]]],
 "\[LessEqual]0"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124175535420847`*^9, 3.4124176102135744`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u\[Theta]", " ", "=", " ", 
   RowBox[{
    RowBox[{"1", "/", "\[Pi]"}], " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", " ", "-", " ", 
       SuperscriptBox["\[Epsilon]wc", "2"]}], ")"}], "/", 
     RowBox[{"(", " ", 
      RowBox[{"1", " ", "+", " ", 
       SuperscriptBox["\[Epsilon]wc", "2"], " ", "-", " ", 
       RowBox[{"2", " ", "\[Epsilon]wc", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "\[Theta]"}], " ", "]"}]}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u\[Theta]", "/.", 
      RowBox[{"\[Epsilon]wc", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"-", ".1"}], ")"}]}]}], ",", 
     RowBox[{"u\[Theta]", "/.", 
      RowBox[{"\[Epsilon]wc", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"-", ".2"}], ")"}]}]}], ",", 
     RowBox[{"u\[Theta]", "/.", 
      RowBox[{"\[Epsilon]wc", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"-", ".3"}], ")"}]}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", " ", 
      RowBox[{"{", "}"}], ",", " ", "Dotted"}], "}"}]}], ",", "  ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", ".6"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\[Theta]\>\"", ",", " ", "\"\<u(\[Theta])\>\""}], "}"}]}]}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.4029188916087327`*^9, 3.402918926348686*^9}, {
  3.40291897770253*^9, 3.40291903694772*^9}, {3.4029190795790205`*^9, 
  3.4029191583422766`*^9}, {3.402919827394326*^9, 3.4029198276647153`*^9}, {
  3.41139090334375*^9, 3.411390925734375*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJw12Xk8VN8bB3CkmStRREkIbSJLkWTpuakIJUsIUYgsWbP0LS2yp4SSVHZC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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJw12Xk8VN//B3DEzFCkkqJkKwmp7Fl631BC9uhbllCyRUhI1hAiyZ6yFLKU
LWukkK3ukGwf20xSVJLQYGYovzN//P6ax/Nx7+Pee855nfe9Z46441VzJw42
NrZGdjY21u+GNzw9X5S9jwnU1n1LPYDDvh+vNfYkm8AbzXd9acjMikOXRpIu
wIY/v5IfIFcuw+CWMmfQN5SSzUaeEnCh1yZdBQ3Oaxn5yPFCXbxljdfgnfTg
2HPkp9I2OWxl/nCA33ipFrlZdf6wRe5N6LP99LUVefRkZGtBUiiEsseV9LLu
J7NJJqg1HORVLU5OIEcrDPkUNEaAWLR6/QKygHpuY091FIy367BxyeDw+Lgb
J700GiQFfPYII8vrKxmJF8bChk9dW48gN5r+SzXIjYOWT4YUfeTBC0n7s5Lu
gfbUNC0MuVJRXu1LeyL8N0LUzkH2V00e92+9D3++XHZ6g8wJtvseNyYD3wWa
PJcsDu+1W98p16fAgLj8oAzy/ZP7Pd9Xp8LTrFdm5sh7jBdq/5SmQ1TJQvdT
5K9mVtYxJRkg/7ugux/5mWXj+u7CByB85n0ehxwOarZRp07mPgRzuVv9Tsjm
V4RGM5JyQCA89bj2QRw2qcGbNL1c4BepWApGnn/pveVzey40LoSGNSLXNg3V
XG99DD8DnIU15XHQac/9l92YB2e2htlbHMJBSq/f9MfRfFD0uYJnIfO848pT
rM8HZ/nLvDPIvWQ3va7qAjDyrRKMOYyD7YBS4kJpIbz9Jo6NHsEBs3Ke1JAr
Av7OL5cUFXDYO/xA6XZJEZyT3+OQgDwz9m9YuLAYjHpVJ/QVUf996RLXzX0G
e/NLmUNKqH8WbarSksrhON+Ocn01HO5uz9Rs5q0AoyMKF98j91VGiSqbVwDY
lGobHcXBesZmas9YBdwt3x95Th0HT+uN3ouzleAb/m9bvCYOKVouMQ/4qyFY
c0/oueM4jIxYuPNZVgPXi86lNeQ9fmAc8aAa8jQTHzzRxqGwTFDAQ6IG3j1Z
c6Hp4NAg2p6DKdVCMjdZ5sVJHD6xS9R9O1sPrsnTZ9NOo/Zl82baPKoHQq5o
hY0RDi7qjKCPE/VgaJWjus8Yh0WfXu1G15dAnOYZfGWC8vE1pCfhZgOIOvYZ
ESxwkOkYm1LOeQUKAX7nOc7joNFuwKN9rRmOk+mbc11x4B94+kE1uRlqu0vb
Mt1QPiY5Ug9WNcN9oW6ndHccEtgaRYX+NEPo1XmPNA8cJjVkled9WmDI4FLm
M28cYl5stM/2aQX7sb5YhUAchnLINUzvNmBMnmWvjkf5KpO+OX+/DTROeT2Y
vYtDWFMkNl3ZBv7htZL77+FwYEwT/7jQBvoHH2x+ch+HIMHSiSLvdvD0dTAo
T8NB8u7djWe9O8A62iBw/2McvAKNHaq8usDQM+tEYh0OBp6aRaTELjBnfpVh
e4nOd5T5bVveBXFZlUveDeh59AnBpLku2MXzRtO6CQctodcZtu7vYHZiNU33
Lcpf/cFe4uX3ELNypdznAw4FS5vAxpoMivio0LEfOIT8YEZVBpLhMt4s+XMG
h/9RvpMJmWTQnRgSzpxF86G97XzlMBlGH2Z+/PsbB5+UID+CVTfcutnqMr6M
8qo4W1ph2gMVVbcCljnJ4FHvlMAh2QtHvrBtyJUgo/pgJsau1AuhXVnz1XvJ
MD+i+WJdtxfOz4zLkaXI4Lu6bWjtci/Ed71KYpclQ+CxVpGVkl74seyzJ0aR
DLfb9pT+VPgIVtH2dzhPkCG39z98QLsPevvfuDe5kmHguz53oeMAmM5elD/Z
QIbfD6RPRPgMwHzwnyNtr8jAY0gMv3BrAM7YUYx135ABK22j73gyAGr/Ozpk
0EaGZ97wPebzAFx39trn3UOGW0ylTjf7QfhQfE9I8gsZDm0Si5K3G4KC2MMc
onzdcOfQMlvtuWHYxPFlJN6tGwL99WWn3YYhNcpcZ9CjG1zfPLIUDBqGhW2P
jot5d8MpE50Sv+xh+HB38l+TfzcQryZaqH4ZBqlak7idUd0QWSbztP7KCJiK
8zsZ5HZDyMELho2hoyAv2fYnf7gbvGW7UpsLxqE0kW3+jFkPMC+6l1E8J6Dl
4H+FmnYfwLHJyjTx8iTkJ6b7emK9cHFhoLk55itY32Bov6Whfj1cd/Xp7WmI
oO2/f6bqI3A016lGBn4HU5fjqhERfbBFxrDnU8YM6PmQ7N2C++FUjnbefNIs
SIgtPI0KGoAdv8knQ+vmIOEGvyZ/4SBkdjawb3CdB7zKlO8/6hBoihxfF7u0
AAKSp/9T5x0G2Qn+r8G+i2AxIa/w5dwIlBZtdanx+QNT4a1TK3dGIYhq2y97
mwaR1Fn+vy1jQNPTynK6QwNheV48smMMrlTuds5JoMF2R6vTPPgYWEeOMbem
02CLR0sy38AYqMuck2AW0qBZ73LL6tQYMK6f8e56R4O0w84Ll7jHwY/XcLMT
7xLU6V60tjQeB29NNcPslCWQqb1KbPswDmyeKaH3Mpbg7VJZxfn+cUjIma8K
e7QEHlxbIuaGxqGEo3j3xfwlcDdhpPJSx2GyS2huf/UShG16uePA7DicsVxN
rOxfgtW79cV9RAqoeL4eatu6DPUhejojmhRoyxHeWCu4DP8z+18jH0YB849+
UCi8DITKWRqmQwFPpUNFsRLLEKK3I/ehPgUKmTk3jBWWIbJRPPSAFQV2Rofv
HjZbBi4m//N8Twowc3QdfyYuQ7V7UvKGLAocW9FKOpK6DKlftASJuRQIN1Zt
9X+wDHprtmcJeRQg/T0gwflkGRIlQwj0IgpsP795cnfVMli9z6sqrKbAYYFR
B+PBZfAYqTyijFPgmnv//ZSRZTjgybOw2E2B2lZyyyhlGS6Glak876WAlvcb
cefpZWh75KC3ZYgCBj35n0NXlmE5W1q8YIICTjFXHSqFVkBhbXJ0nkaBok8u
91dEViBUwtrXaYUCsyqOLVoSK6C2ZGk/yKCAz9QZ8fcyK6AiFytZ+I8CYdrq
nyc1ViDy+zL7VhIVMtc4HQTsVuDolF0MhzAVer0y7f2frICDnL2YhjoVZBL5
V32frsDm6XH1JQ0qRJTfTvUpWYGOoU5aiRYVVOZ83nu8WAG9tH3AfZwKWe6G
SpdaV4ChWU5P1KOC2+U1otnkCuA2HRdxCyq0Rfk8MZ5eAZ5vK6nHLKkgUvBd
8/TMCnwiPDcotUL3/zLgrbe4Av2VJOXgc1RQdSgd0+Kgg2p4zsS0HRU4bezK
ZSTocM55TmPChQp2Nwf0paXokCKjN8bjRoW6TIOv+2To8DRFcOqwO7r/iIqQ
uAIdHuR2Klz1oMJHq80RO7TpoDJ6NqnaG7XPL0pk+0k6bFDe79DgQ4XI1NW6
rQZ08I8xTWy8RgW1gW+zvOZ0SF7m2lhxnQrZZs1WnI50ML963dzhBhXoXioL
7JfpoHzRlVM7kArmic/j1l3pMJQyw7vnJhW4PmQ0M73pEHotWbIriApXTnvL
LITT4ZRo3rGvoVTocP/WNhdFh4b89fs5YVQQjbO9MBtLhzvDPspW4VToe6ef
8u0+HY68O+Vac4sKR/Uk/lEe02GTQ4qnRhQVlPLex3QW0EEtX1mvB1l+3Wdb
ZTEdygJeZdjcpoJE3VvpyEo6lAyv5rlHU2H3titVHjV0sMgOt5lFFrwqcOzs
SzpQrkTHucRQYeN+JwuZFjrUVE8ZWMRSgRDBS93WTgebY0qjLchsn2pc/nbR
wYc2R5G9QwVaGiGkt5cOnxy7sUXkucUyUsMAHaIP8ecYx1Hhu/HZ5LxhOuRb
/L36FJlCKCrym6AD09bI5VQ8FYYdTRXtv6LxjaAnJCH3vaY36X+nw3QoVWoY
mSz8+JTiLB02n6s4JHQX9Zeffv/ueXRca2+xJXJz34ItgUaHrJilpLvIDfKZ
33+v0GHPm6+zzcjVd7SvjazSoTm5rvY3cvn0zN/WdTpMTqnNCyVQoUQ7Oeb5
BgZEtKo9AOT8bI1taUQGtF6Kr7RHzmZ+yQrdyIDzKnxHg5EzrOKlXTczgK03
61AqctILpSrzbQx4zxBNLUKO56Noae5ggMezENc65NtuUV37djFQPSt+3oIc
3nHQYrMoAyp9k+06kYMkhih0CQYMuauGdiH7hYS4TEoxgLckma8d2WtU6g8u
w4C6Hc83NSG7qXwIrpFngG937I0K5EtJ/qQcBQZwCmhY5iDbzYkmx6gwQORS
f04s8v8MukR81Bmgc9n93FVki6deRdbHGOCzKHbLFNmYQ0jxhDYDKJt3CB9E
PmXX0iR/kgEBtOviXMjaDa6ndhow4Amne8Yw6j9Nwa397MYMSO6TDi1EVvFp
sP1pxoAxkW+D3siHexy/D1gyoLNv8pEq8r7bVX8LbRlgQsgNqkHjKTZpHXPf
gQErKkupHsjCxzi33XRiwGvFcjFxZL7lM9LGHgwIaaqMC0R5IZn/faHqzYCT
OnVXxJA5ygq0xK8zoCXyYXMLytuK07I5LYgBS10vWpdRPhdbsimUMAY8n8G9
7yDPiui5dEYy4NGGxFQh5InB9ODMeAZUN4toyaC8vztxtAh7xIDdpxJ2bUfz
JaAzRD40lwG6FqGcAWg+Seu3VTflo/byv3owGInG87RJi3opA6Ysw8hhEVR0
ntOo0msGlF1MupKO5i9toMT+WisDlHn5Pn5A8zvPan66soMB/sXnf3Agc5y/
+Uf+AwN25pQePReM8mt/f9OBCQZsSiwN6ED1xGtyKMn5KwNi1f9kDgSgenBp
t9DT7wwIfG8QSPGnQohz4T7JBQa0g/n1T6geaXo2HRPhYMJRwpFb+aie1d38
4bVlLxNSDOvVlFB9vPxXfsVEmgm/R8UH5i6j+R7qG5wgxwRTHUXdfCcq+N5a
j92ozATv98LF645UUIjdnsd1kgnZ3zfUBdhSoSzt+CDDmQk/nG+FXTdD+doZ
ba12hQlOI2+BakIF3kzyZz8vJlA+dS4cN0b1Levs3J8AJihM3VBhGqD6mu9B
nItlghDEhcjrUqGg8sHRyWfo+s9N/hYqozyvWssMlzNhbdzm8WdFlJ8Te3b1
VDHB9Un2P0EFKrwafrL2spEJLoyWWV95KvSvP3tzH2cCDN/u/StFBXbj1yeO
/2TC+OTnuBM7qGA7M2mWK7MKrzvDz75C70cJpQLtNPlVmPtdaOa9SIHvwc6K
8QqrwD/x+bTEPAV8t8wKBKivgizvPdOAnxSIU1v6z8RgFWRqovtpnynw8jbR
bt11FQYWpLgVetD7XVLOza54FSqUj/78gN7/iUlxVsWlq9DGUenXg74PeDh+
atMqVyEwWKW2C30/sH0u3nWnYRVq2mTtK9LR+zl7f3cNjo7PjnaejkPfL8KS
h3nnVuFe/CbFJm/0PFuFlxsV1mBH/cK9dA0K9LGTbgm9WoONV9WjBdrGYa70
gZ1p8xqqe32FR5rHgfu8rEZ02xpkGc5nGb4aB+yFMY1GXgOlrs27/KrHocwx
9XIvZQ0O61zDC/LHIe6thGH0+hoYsWU8uhY5DrpRWgJL2n9hxGDLt6nj41BD
uva0991fyD2iH8JbMwZy2/ndHNv/gbrmDo+pjFH4nbAsoDi0Ds3e4FdpNgKS
0dGHrrqxYT1BTrbpwsMweX5sVPsbG7a2vPNz+q8hODXVz6jxZMd4CjvNNasG
IcDHyUXwFzs26dYcdi97AIxrHxoI+nFgqgGYnVtMP8ytuQVtWObAGpxWtv7L
7IPH/4VXe17bgL2ml8T3dn4EpouW/Y3VDZikzo2zFGYviPy9b+0dyImZ5tKa
ys16YVov7j2JkwsLn++o33jxA7xFa549cVzYpf5i/hOWPWCQ8MlA8C4XNpf3
7HIh+r7vXVq05LvHhT3oDODaZNwD1DahK/+SuDBF+6Jd4yd7gO7onEHN5MJm
ye+y0tV6QC6HYyG7hAt7kT6QcnN3D6TtOPpE9D0XZlM7e4Q21Q1upKec4twE
jFf7WdW90G7AOWLu6mwkYOURTyjHgrpB7q+r4GVeAtZAckubD+iG3wsHpZ9t
IWDT8qdfWPt0g+9YjaGyMAEzoWRGmjp1Q3BZe5K+LAHb1yGxp9qwGxLPTIn5
GBEwbppnzAXhbqjL3av19j4Bi/3ioSmL1lt713VvtiQTsOtJa+8K0Xos0dbp
5ZtUAqZxON9PCq3XXISfKr96QMAumTXLytSQQThlv3zNYwJ29lIX0+AZGYKi
ZUQLKwnYcbeOkYV0Mmh7HmaP+0jAFk792t7nQ4YysinE9hMwvsPaffe9yLBL
1js4epCAGd08+sTCkwy0b5WMiBECluhUeZOC1osFDoqLQZ8JmJW07kYeBzKQ
LFW+eC4QMO/hJrMOEzL0aGi2m28hYpUNkoffyZPhTv311ZPbiNhbNZXmATky
6CmXH9HYTsTqBJROTMqQoVleIltSiIhdduiS27CfDFXiJH+aGBH73HfMzUaU
DBnEAem0w0Qs3S/F7go/GS72u8ePmBAxI4dxDTYaDmKmBa3dZkRstJ2Pqr+I
wziZSm+xIGIDcrZXUudxsOowcyo5S8S2ep84rfALh1MvVY/dvEDEBO8Jbo2Y
xkE+Z8P87qtELF5RPjhsBAe620ML+wQi9sW/SvhHMw73AvOIoYlETCPle7fJ
Gxyk7jxrzEoiYqU/1Brrm3CwLG6UHEsjYhlbuXTuN+Dw4tvYH8scIra2xXLd
phqHK5d2pxhWEDF2f5tZuyIcJmyzBlT6iFgru2A9TxIO/h4FMZYDRMxdyXh/
fSIOfMGlmr5DRKxsg3SX8z0ctB415VeOErHiivdZ3fE4ZI5SfOW+ELEh9QNJ
VdE4nDm7Z7sEjYiVRPm6fw/Gocs0x5JXkISRml5Z0txxcGubek3cScLWb9Z5
M9xw4FWTk+YQJmFvTcq92JDNRV8yl0VIWNrVZUEBFxzGfvXlTOwjYR8fp7CZ
X8Jh7g5hpkqZhAXOZkhJ2+KQ+O+0RZkqCVP/oWdvaIODok/yq6KjJOyAQHqg
lzUOAefE7mVpkTChLbGmzedw4JBWV4o+QcKG2ReD/axw2N7uEXLekoRhPhEt
mqY41KtVfztzloSZFZgsBZvgcP4509TkHAkTHy4hthjjkJ0cLalrS8KizqR0
njbCQdrxcddBJxLm9meuItAAB831ga3s10nY+e3p/IdP4ED12RW06kfCOKsK
Re/p4hA+7TC1FEDCtird2jivg0NH91zdTBAJEyTK36jTxsHkEcl2IJKE7at9
XGyD4eB4VLOwMIWE+agy9dk0cfgEZgnkNBLmqjx30EcDB5uTl68vZJCw1QYj
bFod5csiUUcji4RNrXz9PXAUBwOPr596CkjYn/Qn/mRVHDqvMTr+FKLzjfaQ
TZB1A/nKdpaQsPehGsaDKjgci1YLciwjYWGyf0enlXFQeBy/c7mWhA1mSwvs
VcKhvPDxuvBLEpavr9Zfr4iDXFntNDSSsPCxo29MkKUaJ6pj35CwnZ2tIpEK
OAgPKpmJdJEwJ+/+RcIRHNLH9NW036P2SJzdUXoYB4FJO1FnMgkrzFd1sUTm
+x3zq6KXhNV6kROeH0LjxU2J1R0hYSElsb985XEI3bzo5TpGwjzCla/JIa9t
J/4vgULCZjLe7p0+iMOyxBGp4c8kTFLCbKM98rUDJ3n/fiFhcT9UMDHW/7+H
rGni0yTs1yM8d1IOhxnNqFb3GRImtaH/qweys05mceIsCdO3PdSlgvxVvzyx
Zg7ldYH3P3ZkqtWI3foiCYOSA/7ZsjhY286d2LuErtdhQfJCHr644aD+Cgnz
5x9t00Hu8zq4mrRKwtRKR94syKDx9deerPtLwh4a6vzDkcnBZ9+Nr5OwY6U/
nIuQ9SOvVLBzcGMu7B1rt5E77oSnS3FyY3mfP75yRta5nxZiSODGOs2IRQbI
zenPnLxI3Bj9jf3rQ8ha2c2nU3m4sWzOkXVB5Ib8QcWGTdyYr6P7FTZk1Wcz
wp/4uLGbt7dxzh7AobpynZ1zCzdGiOnuGEE+Ui/wQ3obN1bzPbX6HXLZ6wO9
Rtu5sesprt2NyLLtx+p8dnBjUZ9PbKlALsItstOFuDGvROmwp6z9jz6XqFe7
uDEB8mbhHOQnw8FXPotwYw8PMKms/Q+528z+BeSv70LfsFyr6K/BsYcbizeN
zGUZT/DikUSe5+e5xDJN92LRJeRPtqSFDOSQxU+bryP/Phw1yDIp18Y/Ctlq
JqyBZZFVy5NPkbfzL0WxfLLy1NdvyPr7eyVY7rVrN6QjD8vpbmT5/CbtKpIo
N1a2U5WWjnzVWePWAWS1vAedLGeIyIu5I+dEmPmyLIGXRN9Evtj4yp7l5wH7
f8chu488NWK5pV/s9XNk7a4VaZZnYrfZzCH/9oqfYu0H+aomvv2HXDc6N8jy
v6+bZDeLcWONMr0dLG/DCMxDyAHBm0tYzv51ywFDPhjm8Yhl6YfrXabIYq4G
91jWXKaneyOX/QrzY7kj7/p6OLJR7Kgby6Zmi5eTkCU2Vl1g2en5T+Uq5Gst
EwYsz59zyXqLPLekfJzlQOIU5wByLj+PGssJjtR+GnI+XX4/yzv5rTW4xLmx
lfZQUZafNP33ZDty6A2TnSzLuZ/hkULW2Ja9heW6nR+9VZAPJrtvZFm7w2jk
JLIZo46LZfK199hZ5OITEWwsW4nrFTkjKwV0r7L20yZ63m4OQP6TmLbCMu1A
EzUDeeP1gnmWSVG1pS+Rfy+U/2R590R50CjyI2Ltd5aPaBQbriL///7c/wGh
cmn/
     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{0, Small}], 
    LineBox[CompressedData["
1:eJw12Xk4lN8XAHDEzJBWkURERZIWW9nOTVkrW6FCloiQLdG3pFVokbWkLIlI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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"\[Theta]\"", TraditionalForm], 
    FormBox["\"u(\[Theta])\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, {0, 0.6}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.402918902734731*^9, 3.4029189279009185`*^9}, {
   3.4029189869958925`*^9, 3.402919037348296*^9}, {3.4029190815819006`*^9, 
   3.4029191590633135`*^9}, 3.402919198199589*^9, 3.402919278024371*^9, 
   3.40291935406371*^9, 3.402919830628978*^9, 3.402919864016987*^9, 
   3.402920102860427*^9, 3.4029229099167757`*^9, 3.4029229628428802`*^9, 
   3.402923200975298*^9, 3.402937484609375*^9, 3.411390927453125*^9, 
   3.411390973421875*^9, 3.41139157453125*^9, 3.411809546539296*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u\[Theta]", "/.", 
      RowBox[{"\[Epsilon]wc", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"-", ".1"}], ")"}]}]}], ",", 
     RowBox[{"u\[Theta]", "/.", 
      RowBox[{"\[Epsilon]wc", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"-", ".2"}], ")"}]}]}], ",", 
     RowBox[{"u\[Theta]", "/.", 
      RowBox[{"\[Epsilon]wc", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"-", ".3"}], ")"}]}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", " ", "0", ",", " ", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", " ", 
      RowBox[{"{", "}"}], ",", " ", "Dotted"}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", "  ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\[Theta]\>\"", ",", " ", "\"\<u(\[Theta])\>\""}], "}"}]}]}],
   "]"}]], "Input",
 CellChangeTimes->{{3.4029188916087327`*^9, 3.402918926348686*^9}, {
  3.40291897770253*^9, 3.40291903694772*^9}, {3.4029190795790205`*^9, 
  3.4029191583422766`*^9}, {3.4029198203642178`*^9, 3.4029198208549232`*^9}, {
  3.402919947266694*^9, 3.402919967916387*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJw123c8V+/7OHAVIsmOUlZDtGjScClERRElo0HeGiIzsvfeW/beZG+XvXkd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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJws23c4Vu//AHBEilIqRaIyKiFZmXkjozLKaCBaiigko1IpM5E9ioisypa9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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{0, Small}], 
    LineBox[CompressedData["
1:eJws23k0Vd8XAHBSJGMimUuIkjSQIrtEk2jUTFRCMpRkLkSKhIwRGTNlHjLE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     "]]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"\[Theta]\"", TraditionalForm], 
    FormBox["\"u(\[Theta])\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.402920051106008*^9, 3.4029201035414066`*^9, 
  3.4029229105576973`*^9, 3.4029229635038304`*^9, 3.4029232015961905`*^9, 
  3.402937485296875*^9, 3.4113909746875*^9, 3.411391575046875*^9, 
  3.4118095471001024`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ORwc", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u\[Theta]", "/.", 
       RowBox[{"\[Theta]", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"\[Pi]", "/", "2"}], ")"}]}]}], ")"}], "/", "u\[Theta]"}], "/.",
     
    RowBox[{"\[Theta]", "\[Rule]", "0"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.402919531108288*^9, 3.402919558667917*^9}}],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Epsilon]wc"}], ")"}], "2"], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Epsilon]wc"}], ")"}], "2"]]], "Output",
 CellChangeTimes->{3.4029200513062963`*^9, 3.402920103751709*^9, 
  3.402922910737957*^9, 3.4029229636840897`*^9, 3.4029232016963344`*^9, 
  3.402937485375*^9, 3.41139097484375*^9, 3.411391575078125*^9, 
  3.4118095471201315`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.2.4 Comparing Orientation Distribution Functions", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.4029222358374977`*^9, 3.4029222384612703`*^9}, {
  3.41241753509556*^9, 3.4124175364074464`*^9}, {3.4124177034776816`*^9, 
  3.412417710327531*^9}}],

Cell["\<\
To compare the orientation distribution functions we have considered, we \
parametrise the probability densities in terms of the orientation ratio\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124176830282764`*^9, 3.412417760850179*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"\[Epsilon]c", " ", "=", " ", 
  RowBox[{"\[Epsilon]c", "/.", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"ORc", " ", "\[Equal]", " ", "OR"}], ",", " ", "\[Epsilon]c"}], 
     "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"\[Epsilon]vm", " ", "=", " ", 
  RowBox[{"\[Epsilon]vm", "/.", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"ORvm", " ", "\[Equal]", " ", "OR"}], ",", " ", 
      "\[Epsilon]vm"}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"\[Epsilon]wc", " ", "=", " ", 
  RowBox[{"\[Epsilon]wc", "/.", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"ORwc", " ", "\[Equal]", " ", "OR"}], ",", " ", 
       "\[Epsilon]wc"}], "]"}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.402921918421075*^9, 3.4029219451895666`*^9}, {
  3.4029219867292976`*^9, 3.402922017713851*^9}, {3.402922071741539*^9, 
  3.402922081545637*^9}, {3.4029221603689795`*^9, 3.4029222138058176`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", "OR"}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "OR"}], ")"}], " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{3.4029223554494915`*^9, 3.402922910778014*^9, 
  3.4029229637341614`*^9, 3.4029232017464066`*^9, 3.402937485515625*^9, 
  3.411391261578125*^9, 3.411391575109375*^9, 3.4118095472302895`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", "OR", "]"}], "2"]], "Output",
 CellChangeTimes->{3.4029223554494915`*^9, 3.402922910778014*^9, 
  3.4029229637341614`*^9, 3.4029232017464066`*^9, 3.402937485515625*^9, 
  3.411391261578125*^9, 3.411391575109375*^9, 3.4118095475807934`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   SqrtBox["OR"]}], 
  RowBox[{"1", "+", 
   SqrtBox["OR"]}]]], "Output",
 CellChangeTimes->{3.4029223554494915`*^9, 3.402922910778014*^9, 
  3.4029229637341614`*^9, 3.4029232017464066`*^9, 3.402937485515625*^9, 
  3.411391261578125*^9, 3.411391575109375*^9, 3.411809547741024*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{"s\[Theta]", "\[IndentingNewLine]", "t\[Theta]", "\
\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "u\[Theta]", "]"}]}], "Input",
 CellChangeTimes->{{3.4029221772132*^9, 3.402922177723934*^9}, {
  3.4029224926267424`*^9, 3.4029224959815664`*^9}, {3.402922562417096*^9, 
  3.4029226081128035`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "\[Pi]"], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "OR"}], ")"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "\[Theta]"}], "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "OR"}], ")"}], " ", "\[Pi]"}]]}]], "Output",
 CellChangeTimes->{3.4029227085372066`*^9, 3.4029229112987633`*^9, 
  3.4029229639344497`*^9, 3.4029232029481344`*^9, 3.40293748671875*^9, 
  3.411391263984375*^9, 3.411391575578125*^9, 3.4118095480114126`*^9}],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["OR", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "\[Theta]"}], "]"}]}]], 
  RowBox[{"\[Pi]", " ", 
   RowBox[{"BesselI", "[", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"Log", "[", "OR", "]"}], "2"]}], "]"}]}]]], "Output",
 CellChangeTimes->{3.4029227085372066`*^9, 3.4029229112987633`*^9, 
  3.4029229639344497`*^9, 3.4029232029481344`*^9, 3.40293748671875*^9, 
  3.411391263984375*^9, 3.411391575578125*^9, 3.411809548061485*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SqrtBox["OR"]}], 
  RowBox[{"\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "OR", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "OR"}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "\[Theta]"}], "]"}]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.4029227085372066`*^9, 3.4029229112987633`*^9, 
  3.4029229639344497`*^9, 3.4029232029481344`*^9, 3.40293748671875*^9, 
  3.411391263984375*^9, 3.411391575578125*^9, 3.411809548091528*^9}]
}, Open  ]],

Cell["\<\
We generate polar plots of the probability densities at orientation ratios \
typical of real networks:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412417788590067*^9, 3.412417828537509*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsArray", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PolarPlot", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"s\[Theta]", ",", "t\[Theta]", ",", "u\[Theta]"}], "}"}], "/.",
          
         RowBox[{"OR", "\[Rule]", "3"}]}], "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", " ", "0", ",", " ", 
         RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Dashed", ",", " ", 
          RowBox[{"{", "}"}], ",", " ", "Dotted"}], "}"}]}], ",", " ", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".25"}], ",", " ", ".25"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotLabel", "\[Rule]", "\"\<OR = 3\>\""}]}], "]"}], ",", 
     RowBox[{"PolarPlot", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"s\[Theta]", ",", "t\[Theta]", ",", "u\[Theta]"}], "}"}], "/.",
          
         RowBox[{"OR", "\[Rule]", "5"}]}], "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", " ", "0", ",", " ", 
         RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Dashed", ",", " ", 
          RowBox[{"{", "}"}], ",", " ", "Dotted"}], "}"}]}], ",", " ", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".25"}], ",", " ", ".25"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotLabel", "\[Rule]", "\"\<OR = 5\>\""}]}], "]"}], ",", 
     RowBox[{"PolarPlot", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"s\[Theta]", ",", "t\[Theta]", ",", "u\[Theta]"}], "}"}], "/.",
          
         RowBox[{"OR", "\[Rule]", "7"}]}], "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", " ", "0", ",", " ", 
         RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Dashed", ",", " ", 
          RowBox[{"{", "}"}], ",", " ", "Dotted"}], "}"}]}], ",", " ", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".25"}], ",", " ", ".25"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotLabel", "\[Rule]", "\"\<OR = 7\>\""}]}], "]"}]}], "}"}], 
   "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.4029227976453376`*^9, 3.402922867015086*^9}, {
  3.402923011262504*^9, 3.4029230919385104`*^9}, {3.4029231229631214`*^9, 
  3.4029231369832816`*^9}, {3.41139127653125*^9, 3.411391353265625*^9}, {
  3.411391406453125*^9, 3.411391435*^9}, {3.4118091246927104`*^9, 
  3.4118091571493807`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["

1:eJwsm3c81e/7x1U0ldYnJRVllBIZZXZFikghSUVGIkrZZIRsIhnJyt6b7LiM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         "]]}, 
       {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwsm3c41v/3x62kKKUoymgQUSQlpU5lpKiIQkRJVpklfZokCcmshDKyMrNl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         "]]}, 
       {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{0, Small}], 
        LineBox[CompressedData["
1:eJws23c41f8XAHCJlBZRKpWUlJRESUaHVCQjklQaKhUhETITWSF7Zo8ysnfG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         "]]}},
      Axes->True,
      AxesOrigin->{0, 0},
      PlotLabel->FormBox["\"OR = 3\"", TraditionalForm],
      PlotRange->{{-0.25, 0.25}, {-1, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{Automatic, Automatic}], {193.5, -756.}, 
     ImageScaled[{0.5, 0.5}], {360., 1440.}], InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["

1:eJwsm2k0le/Xx2VIhkiSKYpERRKlgdqVimhSUlKZKVEoMz9CSlFmFWWeI3M4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         "]]}, 
       {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwsm3c01f//wBVFSqmQlFGRNMiIUnpmhoQoKxLKyMzeoYRKiDJKhZBIRijk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         "]]}, 
       {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{0, Small}], 
        LineBox[CompressedData["
1:eJws3Hk4Vd/XAHApCdGkUSJlyFApVJJFhjIkkqJMGSKUqJQpIlMZMmQmUzLP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         "]]}},
      Axes->True,
      AxesOrigin->{0, 0},
      PlotLabel->FormBox["\"OR = 5\"", TraditionalForm],
      PlotRange->{{-0.25, 0.25}, {-1, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{Automatic, Automatic}], {580.5, -756.}, 
     ImageScaled[{0.5, 0.5}], {360., 1440.}], InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["

1:eJwsm3k0ld/3x5WUSEoUShmLSFFUwkaRRFFmRWXIUIYiUTKETGVM5iljlOma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         "]]}, 
       {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwsm3c41v/3x1WIMpNKE5llp6F10qJQUcbHKCIzZO+RrJARKpKZlWRzm8e8
3fdN9t7rpoVKKkV+7+91/fzjelzv9/v1Oud5xut1XBeBu7Ya9zYyMDA8YmRg
+N/vY5qaHW6JJGD4/x9fOq+73//4vxvDmlfFYIXbwCWBYOmbfBZOV0+AqNop
SjPBMSrHfNePn4fm9Zb7jEkksCuVTFm6qgzRQUfvaRA8OKE0LnL7GgQfzS4o
INiRxethzwkNKFEx1hBMJsH+X7WfGs9rQtCfN0qvCbagBkZ+UdWBJIOuqOMp
JDj53k7nprYeCLoekx0hWOFFk9iGu7chTAZEnqaSYJT5zA/vUkPgUr1j918a
CZoKMlHs9F24b7GdR+41CZq3ffu0od4YlP7Obt2bToLNCeOWHMr3wOjSaSah
TBJYt+me7bxlDp2tTJvPZ5HA+YSod8SwBVjruN+1yyaByBWJz5F3reAM3Uyc
8S0Jtj21kLC2swH+o17PzHJJkFso9/36ii0M8DgbjrwjgfuBozP1tQ9AVgc5
/hSQwCFh0xWvK/aQYciwnFpEgr2r5Bp+DgeYE2E+bVBCAvmBL8XLXQ6w+Ljo
K1M5CT6OVB04beAEI+X7eMXqSGAl6PbH3tEVnBobBPQbSGD0kMdj6KQbeP8d
e5HSRIJvhdwBjza4w9UNbK2GNBIot4lcSo3wgNbSANv8HhJozeltVcnzhlzP
nt+2/SSIWr1t/svFBzTJ9b/PDZEgxc651p3fF4SfKxnvnCDBjYytgb8++gJX
nMv2Z19I8OVumSmLjx94TjP5Ty6S4OY1TsH6GT/QmC50PbtEAnoIzr+9+gg0
r91YkfhD+JPDM8C30x+SCxoiR1jKQS44foNNYQBkilqtBomXA3tJWtbHpWDQ
3hQmrCpVDg1c/h6cpo/h2EIZp/CRcpDN0aD6DRAsVn6E90w5OEXEKmnXhIAH
B9f2RfVy2Cj4fN/YkzA425S+P8ynHKBko37r/kjYUKnN5P+pHAKt/uZ1/oiG
pFDOxdlv5cDL5rJrp3wM3L3PvPXOSjnMyWuuxTnEQKLM5IdwlgrYaF17Um8p
BmQssjPmRStArjYtcWI5FuhS1e5vLCvgiZnnttTNLyB4nNnoFEMl2CaM7/cy
TgDPSb07yayVcGbvU3/BzAQ4Zsx3ZhdPJQi+VQzm+ZwA2om/k8+JVELl4Z0i
ww6vYIO+ynVHtUpYWD3MvP1xIvDuhKsWSZUgrxdpZGKUDF3RN/Y8V6+CEb9H
XwWqUsH21K8jMovV4LA9vmx5SxZ8fD2nH7hSC8f9i/cqVxWC7kO2BfNNdfB+
4B1fy1gh+HzwnrjFXgfjU+KfH24oAk3pc9XKAnUQUUSHMKUiaJuh8CZdqYO7
7DVCe/uK4OEGVf+/L+ug8Ulez/21Ymg86v6dS6keYo34kpady+CK38oak0Y9
MA+PHwpJLoMKGdbnGw3qgXSWpKFPK4O9F+eFtznUQ0bBzYKK/STgspKMDk6q
h8Ku+fPmRB5uPv34We1KPfj2cam0SFZAA4eXXlVhA7Sq/5PsEKmGnncdv/Oq
G+CE4KUZHc1qmJ0qfZ5JaQDB4Y+vD/hXg0nxJY/UsQbYUH7pmPlUNTAmRcg2
bmmE5ixJoS8pNdCmMy2fYtwIXB+W7rjtqIWcqsSQDTubIM15R8jFijoIeB3D
e16wCe4+1vJM6a2D3l+x/I8km0Dyp9sP/m91wB3SKMd8sQnE43OGgsTq4erF
kXg2uyaYMFqU/v2iHvpv9bGv0ppALq8HXXwb4LnT0yQjLzIY3GmPC7FsAvPT
ij06j8lwvC/PmOtJE+x7HMSpEksG20TZzrq8Jug0O1RzIJcMOxik5jKXm2CP
wLHJRyNkYJno3PboERnOzdz6xXiyGdhDV877ZzaDZM/al6hLzdDMKxvR2toM
NgbGSjvUm6HooqGv4vdmEPFMkmM0b4bWj6FeBWcowOGrw2gT2wxhUpXf3/RR
QM/Q/qTiQjPs8DHn28JNA3lx5UiRlWZYML7rza9Ag+oih5PrmyhwsCTkk7ER
DbaWHXR7zEcB/aP7B+wKaVDX2cn85wIFWK1DhrO1WkC3MPMG+zMKOLV3BQRm
tkKMbv8n5mQKrA2Nllh1tcL3FROjxWwKZFXVR3ittcJirC8ptJr4/qoTm+it
9/Bh6933H6cpsG7HGRSxqQ2W7S2sfktQYdKwyyrDsh1aQwXUo49SwdSBIcX1
eTuYOCWy8Z2lgviPGwWOje1Q98+mb/oaFTz1FVcdOTugQrfKyMaWCr6jagzT
lh2wzagnTduFChG8Rn++PeyAE6vHdcR9qDAdN2TJG9cB469TJv3DqbA6esYy
rrkDkgJkFnneUiEuI4seLdwJSpIuZ04UUWG73Mm4i2c6QWjDvrDzFVRg3/lO
glWzE/IcZ+c3Uwj7pG4lvvfvBBa9Im61KSrsW+c7o0jvBOZo/8IXH6jA2tb9
KHytE6LE1fqaF6jAsbZhaYG3C0xe6t9r/0OFpun5mQ+Xu0Dv9OlOdyIuonOs
MjXZXeDu5VcxuIMGuyIP9afUEzwvk8K3lwZcKiutz4e7oPSVnuApERowHL0g
WcHeDSxanrv3HqZBuVy27qxIN3w7oNEyIk2D4poofaFz3XDn/Qfu1RM0KHAP
Nei174YDj9YYdc/QQOj2hj3KYd0gxu5g9UyRBn3S9eKt6d3gepxJLfsKDZyt
Ugs2D3YDnfuLp5QODQ5w/Q1SPtcDJMWrwi56NJg/MfdVUbcH3FqjSl/epsHS
9JbHKo49YOJvc93FhAZ3QgbehGf1wFGHv8WSZjSY81+Zaa7vAfuhe1hjQYNl
DcjjGu2BNskGH1sbGsh+S7/Wwd0LKmaOMeEPaDD527f9skQv+Dr6bw2yp0Fz
2Y/jrZd7gckpLUbHkQaeW430DY16YfeFjPGNzjQ4MhPGtcmzF6angxMCXGjg
xZEhWvysF46sPvCYcKVByAZFR4eCXki/ki/B404DpkIdyrnWXmDlbzbc50GD
CItry3vmeiEmTP7zV4K7QjuNjjL0wTa9wpJkTxos7O4P0eXrA+/uI74SXjR4
ab//SqhcHyx/7NsSQ/D2C98dm1X6oI9jlref4AZ/sVmOe30QumHIaJngK7aC
jkbefVCZrpe3QPA7h9blmud9wD58CesJ/qmQqCha0AdntTM17AheT4mXjKf1
QZlf46E/xP5tzdcjds70wQ1tPlYDggW29p9KWusDV0W9vDjC3le7ezfL7uwH
/00e43mEf+ob3ZtbZfpB/GWGXpIbDUrPPLxmf7Uf+MRVZs0IPdTfyz4QMOmH
xKEd51kJvUqu314f9OoHrd4/so+caHB8/722l8/7oUBI0q3XgQYi1jJ5pgX9
4Jl9aHjdjgZoe8zhZEs/YUf5no1EvHJ83D7voPdDzZsP/4ataSCtHPzh779+
mH2+48oTKxoILnud/LhrAPSo94WdTGnw2+jqnhHVAQi9PKGYY0yD7r6dypOm
A+Dt8mWwzJDoU9sqmBZ8B0A6njP2pi6R/2HelvtKBmBCQeTSlBYNGgsZ30L7
AMh/GAi5fJMGypvFisw/DoA9mWc5XIUGO0akzrftGwSGzZHZ9ko0UJn7Yrjl
xCDMecfwHL5Ag+Ava/aqGoMgV+oqwXeSBp1b/sVNBg5Ct/5Dm2tHaaBJunJe
PmUQ2neYh2nL0OD8nVTGsMpBSBXrDZwRpsFqu9PKla+DwLb9z4oZPxGvpJHK
vC1DoKRy1rlmN424P4iT+ISHIJlqUzXNQdTDVJrbyn9DwOKg+4d1mQoif36R
JxuG4JO/nBQ/0R/4Bow3Go8NAQOvy8jmOSp88L2YNvt7CPiOJ3+6OkAFiV7j
gz8kh0H84O2qeBIVTvHWmAu8GAY15ql3x/Op0PhObX9e4TAsVsy+e51JhfNd
TCpn3g/DVp+ZwwuxVPBJN9+qu3EE/ITJIScfUIFJ7NS+8PsjcD3D/oTHPSrs
lpp6pfl4BG4YLzD46RL9NfTA+T0ZI/B5vUhg8gIV7uS9TEkaH4Hxf3+iJnio
8M3XXPuRxii46txbV91MhXQDtmg521FIP9263/sPBeRP258dDR2FQ0NRnZIT
FKiSnX14sGkUNkfPddZkUcBBfO6rxfEx4P4K0arxFLgofGb6080x6BlRH30V
SgGTFHYnkwdjEMbOExpiTQH1S7D5XPYYJBoWMz+WogAL4+u68N3jcKpacyNj
ejM8FV09f+LvONBNBJ5WP22Gc+4HskO3ToBtzn8SCr7NYJf2KMyRbwJ6BHiu
OusS55/s8deyRydgqbrkJzNbM1hSavHm/QlgMtd+7WlMBo+KXeFsgxNQ0tEq
elONDDrqUW3usxNgOnDY/vMxMhyVHbk1vjQByUtLrkasZJg4G2QZwjEJO/ad
NjfJIc75TDxtfGESvtzeINQ93QhXwrc7Lb2ZhN+yAqvBLY3QPi+i31c6Cepi
50NYixohVO8ax7v6STgbVypm9bAR4q+zyZwamiTyple1aE8jhK2tLzazTEFQ
uynaXW6Aw3SXsiDjKfh3hMNv4lADfOT/K/3aZgqOMg382cPZAFFumz4WuhHv
3w4qWemrh7dFop4ZEVNwzNVgr6ZJPWwx0qFMVkzBWGJ2RYlTHWgLzOkGckzD
iXMNRUzadbDj1FvF4l3T0GhwxFv4RB0I3T201Ck4De3nbBx7ifuma5TKvpFj
09A7n5u85l4LZ6/EmYnengaR/Fu5Nz7WwLmaNAm37Glg/9RNF8mogRjJs6JP
C6fBzBWF0+/WQFD2oYQXldPwKlvqQMJQNRQJPzWzfj8NFrW7DwaQq8BmfEOR
3NdpqDiXatUdXgHp2jHqHHIzEH0rWHhaqQKcujTuNCvMwH+i9DtZDBVwbkXg
5X3FGTA3MmPXsiuH7rb7Ih43ZuD5prE89eskCKS76qdbz4DGgG0TPzMJykWa
sqscZ2DKMe/nm6oy0PScPIseM7Dv37O4JbEyGLoV0hXweAaWroyRLP+VwEmy
fS7v6xko2rHHVbSoBKwvHr7k/4Z4n/uIdrpZCdDthW+M5s9A16B/zFx7MZx5
KK13rXoGzmbknUp4VQR1Ob9jxXtnoLZji5WnVAF4qJ08lM9Ah7pm5b6c8Xz4
zezbXsFEh2P2bY+yI/PBYpnd/d0WOgQpNp0QmcmDzYZ8ETe200EnuOqx7b1c
YIrb/MpLhA5tlalO041vwUji0rW2QwRznVrbIPQWuK5ut9ksTYdmHy7ey5Nv
QHFfR7HccTp4jXHf2KeTBQFSW6KtLtOh+q7I0q6STNg1mPBp7QqdmI9fdLzn
zoTm8H2yrmp04NmknWtJS4crz8Q0hG7R4WybkqWWSDrsLrnIraVNhynZ5pGN
fq+h55pDsK0uHcojvW3TT6SB+yOD+/8ZEt+7bdFNik6FgT/lteLGhH8/i8ON
FlLgmYlVwuQ9OrS8IrtfTksGrQfq1Zut6HDwjBnn0J8k0JlVnHeypgPzvns8
ze8SwebVuluLLR3OrBxSieRNgOWmnEcSjnTITeoKPPA2HnbgHWVjZ4JFZy/c
OB8HQh5BE56udDB5GOAhOvAcxu7SFd3c6SBt7Sb+xvoZ2OhQ7+p40uHcELvq
6MZYkOHmPrnbmw7PhL9MNz2PhpuWYljjQ+yfvOdhS20ktHKfLcrzI9Yrchei
Z4fDUPQoz+ojOtCf/r1D7gwFnrQIpsMBdNDsOku9uBIMrCKhfqcD6TC9UOFi
yR8IHJXPAmSCCPsPhgYoKj2C5g8sWzYH0+GimyBnj7UvOF+hbK0luMhr7Z6O
mAfsKFAJ0ntMB0lyqWCWoxMcvRbvNkhwwfdIae2HtvC8SWVCIYQO8DeZd2GX
CSQoB5d7EpzMYMTmYagO/2WwMKYSvHTY6EFE41EM0N6B2QR3BX60zDuvjzwB
oZ+iCW7bWHT282MLfMHaHWj4v/fZf69yu9njPesPMZwEPz/OlPtFwhWNR7V3
pBD7WzykW9pNeGHJ3rPsvASHF13+00R9iBx2yp5WhP1Pvz1h2p7mj52Pi01f
E/5Km1WU7/IMwq9GNzqQ0ONUkPVf6q0QjNzrXl1N6NWj3FSwT/IJOo4cOJLo
T+jx6Na0/8ZIPPwMjxkR+hbtDeU5bxOF20ZN25gJ/TODSo3qBp8if04hQ4Qv
HaKsxprXLsag98H2nhUifiUHWM5/z4vFlesuGkpexP6F+m1xu5+j6uCPhy4e
dBjvvma96P8ClSoO3A9xo8PHrFqBhYU47Jw32O3rQgd2tcrprroE3C/+4DOP
Ax1eKQcz5h1KRJZ/XQcLH9BhmSPLiD86Ca//vqdyxIYOG9USwrRlU7BiWTFu
zJwOxwcxYWUtDUNkVTOG9OlgbNTyzSX/NfaUdtKi/qODf9M9/dy76XipY/aa
hBaRr2f/dB8hZ+Bw3X7S1ut0YBqjuN5/nI09K6OrTkCHy5GDzw0V3qCzzCmW
q6fokPXV+f3vD28wKtmfaSNRz47PVSXZlN7i/KURsf1SxEx/R0ve+987DBf/
6MC6hw6rJ+aPNyXl4cGYwTitHUT9scXKavHnoyxZdj6Umw4yl0p+Ztfm47G5
c/fzNhP1u6Wt4dO/AvQfUeMe+T4DWRcFy5bVClGzR4t+f34Gom7bJFATCjEO
XSNn52agLcmiiaJQhHcZ45tjRmZgt9LHl2x2xWgrGKw23ki8n2fDr1RTjAMM
fPfLa2bA2M/m/YWtJbieWSXgRSL6571gHd/XJXiwLohUlzMDanwjkYvdpejB
dtD+fNQMUafjbT+Fy3HphjzrSR2in+/2JP2wKceGW4KnKoj+7iYhZpZVVo7b
dq/VCl+ZAWU74eNSyhV4mqdfEYnzwaDsMEPyvUr8KPzadZ1vBpJi710NiKpG
qfr02I6+aZAz+Or/pLca3378j7K9bRo2JDZ8PsdXg22a/eqXm4jzrWN4OCOp
Bu238363K5oG38oHTHeyEHnYX8ouhk+D+QvjGL+eWrzz5U1K8vlpcOEUztT7
WYsteldCfx6fBnphVdvazjr0v3JVXEFyGq5VuEok6NZh01obBOychkchqkIK
o3WYkvua8+znKXj8WPsTqb8en1s+idMnzuubhuylG3/W4zeZ3/oxj6aAvOby
kHt7A76emh2rdJmCnAe/Lnldb0DLXf/oQ3em4FRPwv7ghgZU0O31vC09BU6X
Y4ouJjcil2bscmbLJHF+dDJQKxqRP3XxxFLNJHGPLini7G3EtV13jWULJ4H1
hkX/NEsTKj5JUAh6MQncRr7nX1s3YUFBtm+iySRs7AB0OEzG+9t4BbP+TIB3
puUcz3kyjj/8V6cwPwEnHByvO+mQ0V4kx7VufALy6r6TPfzJmLKXe7mocQKi
fBp+Phsk40RcdMGh8AnQ2sk0stm1GU0E90iHHpiA/k+MKyYhzbhW/O1kP/cE
7DY41BOQ0IxJ2jFVexkn4Bxz+Nq22mY8WM9UKt45DvnjXR/1GSnoIv9P0Ovu
OMxTRqoGt1Nw7QB3Uenlcci+wTm6W5iCA6JFHLOHxoFzf7HRp4sU/ObMGi26
NAbb05jO1z2k4Ce3qAx4NAZaAi9OG0dS8HdRu5Ws2Rjc663+j5ZIwe0SSNmj
MgYWa3ruHyoomGrLmz28bQx6h102mX+lIGf6vhDu1FE47MI4GnODivrB5oXJ
OAKnYl6Mx+lRsdwn4PrFtBG40PLQ1tSUitumj3TTA0egQm3Ddy0PKmrndHUd
vEbcv1eSWuJTqch59K1rzMgwvGPO9pzMoaK52i4emdph4JX9eelbMRVbDvdz
taYNwwHY+vM+mYoLzZZWzFbDgDfkmodmqaj72fxH2MoQfAn+KP1ggYqVm+8w
yo8OAZU5yrpjmYqNuUk9o7VD0Hcw+ub3TTSs2xs3dDJ4CHK4wh2Kt9AwY0Q5
ZcFqCAqki7XPc9Pwxx3pqxnXh2CL0sLd+n003EpNvC24cwjGd7YwlxykYYci
VWvuzyC47Llj7ihOwwqB+1cLxgbh28IXE115Gn4NVj2umTEIMcV192hKNHz2
NjB85uggDFRUSUyo0FDVP822as8gvFplFW65TsNiKXXH+A2D0DvrGSSgTcM4
jYPlFu8HwO+Vv9ETXRqGRUQb6hUNQHJJomq7AQ1r3A//uRk3AD/yKQp9xjRs
7ot7r3tvAOr/i3330pSGl91PWlmoDIDnhk98JyyI9V8/q/eRHYDgrJWSHCsa
fnnnypi4cwAS+pSrf1rT8I2pglHjWj9EZuVY8j2goUYvsixN98P78QsrPPY0
fL7l4aFDtH6QXvJ+PetA+P/JZ9kivx+iBLZnRTnRkMyg9qLwWT9sCNx4jteF
hhdvMisyEvN1tWRElp0rYc9Z7X13jPthXvrC/kw3GvZcd9VtuNIPR5o/jpa4
01BGTFpYlpjfwTpcKNGD8M+gLTtrRz+c/e0ubehJQ32To9sPEfO/VsXR06sE
K7t2RJRM98GJNJ9gey8aGoe9UFKh9UG/sYZGA8GDp3hMP+f3wfmYsf4FglVR
g/fZ8z5oGn6svUywEX3ZW8W7D87umefsJ9ifQ6x1670++BDXBTEE/zqcItyv
0gem8vIikgRb1KcX5cr1wa1whY2pxP5PFpkTI/iI7y8f41ki7P1iL8jmxdAH
UhJZL/gJPlgxJeQ81wuN7ke7DhH+8Xyt4fBo64WRbTnr3IT/wpyVi6ElvbC5
4o9hH6EXwy+z+ayEXvDWUzjm6kzDJf9pia5HvbCi8gp/OdLQJ2+ga7NVL6SL
qHyNtKPhq/lXUy8UemHPzbhdObY0HA0PjP7B3wsPF7h/pRHxZJTfrWDA0gvR
uVmDckT83exDPmv298BOg6d3qER+MIgtnJqt6QGbyyeTwISGkZ5bWfwzeuBZ
psyN1ts01JJPjv3g1ANM4qMXpvWI+NzneZ5n0ANhDQw/h3RoWG9yIsb/Ug/M
qf+Kt9agYa4SaVWHtwdGwoO4WIl8PnYx9LXOWjdwGzBfDSTy/UMhQ50pvRvy
k6M5RC/SUO3Dr5Z3Jd1Quxa2V+UcDX+/d1768KobliuVfqifJuLFGL1BLrAb
5E+NMbMS9ZTCPHH2m1Y3kO/TJw4K0vCss7+g6EoXGIl+NlnbS0OdTYYR0+Nd
UH+IulK6k4YrFza4F5K7oO/nWmoLGw21Df47HxzTBeMHLVj9iX6Q/yCme4ds
F1xVLT5ktkhFxokZU8tdXaDdeP+HxEcqHpjP1O9c7wTTiAma0QgVx3YL9g+2
dQKFLu7rVkdFCw7pmn7rTrDewzrlXkHFDTkqB6iandAm8sfDqIiKzxjIaW1n
OmEitTZh/DUVAyb/3t/B0QkujhNmWYFUfDU+dOZlXgd86VIXLLxExUOOQ/zb
59tBXutHmsQZwr5Nn7WeYDuIbjXVjpKnosqLeTbZp+1Aygh5vPsgFcUt9pj8
Pt4Ot60GHsmvU5Dlxya3xwFtoPhZ+gC1iIL3L9ivN4u9h94sebstbyjIGFg2
sLTWCrm7krJPJlNQ8uUXB5XuVqgJClg0D6Og95M0AW/vVlAbPp3NaELBTUZf
Ar73tcDn5xccnbkoKF7+SXh/JA0UVOeYvZkpKNfAYllsSYONY/le7qvN+GT3
QTG7SzS4x2D8VeNDM9qKMG67/ZcK0rma5CBsxvojuzyZLKjwWE9ip/T9ZuQQ
Oz4fpEKB+bqug91Ixt03fUIOS5IhKIDNYqiYjKoes+pBbGQouGpQN5JNxu0O
h5JZvjRBT8yEXnc0GS+vxMd65DTBBCXtT5gZGRl9zSQFJJogZuDJpBYHGVN9
FiT15RtB0ULtob5uE47PDfGzGtZDRJqtrtC1JtSV4GF8qVgPmidkZL8oNuHm
Ko7NWgfrYdu7jf6e4k041lq3cHmuDuImL9x+/bsRVYqGG7ns6uCAwgkv+eeN
WOB05ZloWC1sC1JwN+hrwAC5u+mDNdVQqc0d1GBcj5vF21gFZ8rgxd1Bt06d
eryfOxRnXFEGYVL0wVm1erQy6lKdiiyDub++h8VO1GPn0Xp67NkyUP7nwrqZ
vR5jtl+xfJ9QCp81pJwukupwQWTkm4JJCUDhmQkR3jqkkcykvuwtgjX5H4VC
fYjZKwsih66+A5vG6vsT/1XhvrJ2rYb+VECWzvzralUo0hjqNZSbCu7Tf973
nKtCj2aeSHH/VLiy3S2CX6wKL43fTrCWTYXqoVC2ml+V+KP7hKlveAo8YCkN
5nxZicwr88OWGskQ/P7T39VvFTi/uPjGefUlOLS9KDr4oQLrWtntp4tfwpnb
mX/ujFXgo7Mlf9OsX8LlpJfifC0VWLFXmW3fRDxk7mzKeZJegcqp/JcHKHHQ
eGFG0vN2Bfas76+ryXoOiZ569poT5VhaJVzSnhANf4SH7ZIHy3GhZ3n9xt1o
0PjzvW+tqxxfuDxIYRKLBvkneU2LTeW4Yqjgz1z8FD4PiE/kvS3Hd9oVwlpt
USATcc480ascF7fMyGdvjYTe7fe1OVzL0c6q9rhcVgQEevp5RtqX4y3h/N/3
FCLgU+AWgxazcuToPlPfqB8OqtFjYntuliPn09UMyAwDinRDML8ksV9hWK3U
1cfwyIkvrFCsHM8e1FMmjwdDE6t+vJZQOVotMfUkOQVDRXrL+5495XhRAKK3
pwaB5T8Gteyt5fhb5tju2bUAWOSRN2nZXI51O64L28YGQLaoqcP6pnJU5qn1
lJUMgKLvHx68WiUh+ymGWgMDf0hykH2bv0BC5YjSh8dq/WAp9vPlu59JyGuo
0mv1nx+cyadQhD+QUDe2aLLz+0MQeCDqPjVJwsXKjpnDIg/h2m6hO3J9JPzw
oG1waZ8P8HkZ/7PvJuGL5/EkqZvekPpdzrmpg4QZ7rQDFcFe8Kn364ekFmJ9
5TbBih8esPhTIO9QPQkLje1MhTpcYSbuYA1jLQlZ2b4dfrHVFagr1h8Wq0lo
zZyhcUXJBSRlJx6vlJMwYpvfVz10Ar/Nqf92kkioX+/pU/7XEbyKJx4rlZLQ
3O9qkuoJR7D87jg+WEjCE/uHyVsL7eHI86LM0wUkZFl99unIoh24ayj65eeR
kMmSo/+xhB00loVYtrwl1sOr4TbXbcGY3dfZPof4nvtZD2+LNXDQj0cdekPC
nT8MDrEq3Qen+q7F95kkVJIYD2kEC1BUV5QrzyDhy6YnQ/5VZtDg/9i3JJ2E
UnqRDQ8VTIH775ah+tcktFqctygrNQHvUumzk2kkXB86+V1A3hg0hO6/5SK4
+GTEw+oCIxgTBCH1VBJ26nudCZQ2BOXNcumpKSRM0ON68VXXAIpTB6SYCJ5Q
OpJ5QFsXtil11romk4h8/b4cdVMbTFsaddeSSCgi7N8FN25BSoTp6lOCrceK
QgXU1OGvj2O6AsHPjidM3o5RJe6jZZrfEkn43XhPWkP4ZdAx2cBeQTAHK/eq
0eNzwMws2xJN8Nxtu92aLEchX04q0pvgVtbRseOrAnCs9LOeO8EdEcUycoYs
eGbJVCqIYJKmeKChhBTCdObmdIKLV2MbfflP4ZEddXPdBNfZbbwYGnsBawva
23gIe15frxJmeXkFf9r+rTIh2GPzBjNy8nV8/Mq5kEyw/e5/RZbdGpi50ztP
gfDX3bvzYmqfJsKV/4qrCWaTm3/GPaSDH0V16zQIfY72tunVjurheZnRvt8E
8958eql08jZOG11ZziP0lQ/we7T23RA7T3LtcyX0Z/EcEVdxuosehbnX1Il4
dS9u/dr8yxiL4yI7jxHx5ajiUbq9ZopVBzcKXSDir+XcHO7ja45ijql+hlkk
dI3ZbTK+yRJ9MhTM2oh8GVpuOGy51RqPW+Ut7CfyiymwezAhwgbn3qgH+OaS
UHqXP5ljywPUYQiZds4nYQnPEUW2CDv0yf/6diuRv8lHJS68V7fH2L9CjwuK
SDhvEsJavd0Bu92YvWXKSCixf/cbmZeOGO6q4vq35n/169mY+MYFDz+wKFSq
I2FN5B7+Ch9XtBm04sxqIOEDlQe8BzTdsPHC7Il0CgmNxsw72xk8kOPfVs8o
on79mxtHt+l748OxK+veRH0L+Dy7UXfEB2uqrxf7DhL+dlbXzDL54kjWzqra
cRKmFKvH+I/54ukXTL5H5klYm3DL89BTP6w9+qKt/isJtwdGyies++Hg9E9D
0x9EP3Ae+HvZ+hHuC/qj++kvwb37R1Sv+OOsefVnOtHPPF61sJxlDMQq0QcT
udLlaPhaJXIw8DFe35P3xk++HH9pp/xw+f0Ys2246FYK5eh7w1fNxDIEmzak
lXpcIL5v7JOVuB6KsulVwlE65diTuO1K4t4neLq/dduzwHLcWJpxf59JJFrI
dVrxfy/HT55PMzcci8FQRhvdLSvlWK71Srf1QQymvRF3ZmYgzpfjUnqtOTGY
cXqr4lGOCrSu68iwEYxFLt0BV+vDFRh1rUxGbdszpEsd5FaxqMD496eWV1af
oypHpXX79wo0nA1svb8xAVsGBkufnKlCeYr/0yNuqbi+0nPHm6kWe0epz3b/
eYfcOZvq1Thq0ePGrZhP8nlYtJAuL7qzFsWV3z3mfpCH6qyCR36L1SLPWf1Y
07k8vLRHeZpbrRbbjk5Y7bfOx0zTnD/7ntdiknL5kTDzAry9clLujlwdPlF6
X9v8qAhpO7LVOR/V4/apmz+O6pPw/GllV+0n9cgmzV9Cf0TC30zHqtKf12PD
o4yXLUTf08tb1r31th7r/1PpOkmcG/LSPvy/e+vxqfxYbm5SOeaT2+2vHmpA
zaNHhfYQ5zj3wrJQNHF/uW90m6cWq9GINHnAY7IBRfO2K+UsVOOy8Zdq0y8N
SOaZPdKzrwY9Mi0fKW9sRJLLLP+EZw2mJvoEHJFqxHqNbTGzZxAnXm3njAps
ROrn36WL92pxgTvne9aJJtTSiznow1aPrQqGX+svNuGvEy+ydQ/V44avt9hG
bzSh0YKNzW3lekTdsz+5LJqwfH+G5Lh/PRGnzFH7uCb8m/cBKev1uCem4fev
lSaUfOHHpLnWgJn6ogLlJDJ2fZToYNxFRpH9XKe9GslIg3b2vafIeMg41OhU
Bxm/yy/F375NxspNcvOv58i48I06dy+djAZi4n0iO5rR3YN7i8/RZszaYbah
yK4ZOW0KI+YMKBi0LKUNAhT8o88/2dVOw33CFMV9hynYESfnXbJMQ26rvJOL
8hRcN1UoqtnTguuOHi42yhTcyJE5eNG8Bf1VAue7bSh4oiMx48CmVpyQUzJh
Kaeg0fASifXce7zr+NmQrZ6Cz97nnblp/h5962daGFooWPiwml4f+R4FIkL+
lo9Q8M7y9fvbp4jnl97sNiPu+1+reZu8A9vQO4tdx1mRiotlXgtGfe1YqOft
YHKFiq7qr/geMXTgGD1zL6hTUTr6ds0cbwde5rq1q9yQiqZ/Y25/ONeBZzus
c0jeVFxRcYxqet6BwZccJRiJ+cSlTMjoTW4Hsq2+OnbyCRVbZM2UUxo6cLov
Y8LkJRXVXozyNy12YOnxx7q5pVScfPxNYVq5E0WYx39cqqai8vnrrNp3OjF2
aYCluYGKHxpu3B9x6sTDD49HP+yg4r3/nqbtSSOei7NMdnyg4nH6niqLf514
VHP6d/oCFY13+XKZ83ahuD/YG/2gYmGdpq6LRBcWMt71CFmn4ntveReKbhcW
PBz0ebWdhu8oJD05Uheu7lRSDuCj4esfHDLQ3oX1hRKWGvtpqG9Qlqg324V1
D9rKX4rSkOlC7+f67d0opydqtlOCmGdj8uLYJbrxUqC8tYsMDYe3pPuaXehG
li41v+kTNHz4kj9G2b4bhw/VcC0S8+n2q1Vh7Y+7MWwt9+coMb+GRL/SupfS
jalsFc0myjS8Klf/raqjGwUno5w4tWh4l7J4jE+mB7dJCZRJ/UdD88wN73iU
e/Cj+LCatD4Nb4Lntr2GPWireMi924iG9H3p4lqRPbh/MjTCmZjPbUTOJAZl
9aDTteKVFWJ+Z/vO5U+u7cF7pgmtyVY0vKTuK3j/Ww/u2Pa2pIGY/0U+RMZ1
sfZiYpXwjyZbGnZMk/9dEuxFVQkz5Uw7Yt7PuSxDPtmLoVGz9mYONEze2bT1
5s1e9BSTl2d2IuZ95SCbL1a96Df6V/WRMw3P+dw9+tS/F4N+MHuPudBQca3y
9MVXvchZdCZ4pxsNYyeCDTeW9uIm9mwJKXcaftl8zbO1rReFbzlKCHoQ+vw6
YJU614uynxaU//f3Eue61M3+DH34ZPnJhRRPGmZ8ZZWw4+vD6F0Lo4e9CPtd
dhVayPWhyeHewacEX0nid7BW6cNDv4+s9BJMX9+k7GnShx0rov9+EJzicIT1
mVcf7tm39maRYFOevPCKZ314wF+6vongT0eY8z/m9eFmVWtmF4JdTbUvHqQS
rPni5CaCuz1vCJpN9WEGG0XAkrDHIlKKv+RvH248qeKTQ9ibz1bDw87bj+at
2TuaCf8mq3S7bKT6sTYnI6eK8P/byKLMkFI/ioUqbgxzJeyT/L3pulE/WlWT
xuQJvYLYvQ+8dyd4ayhTGaGvQ9Qe7Vsx/XgrzO3UNkcaPk3/4zWT249vfR5f
umxPxFeq19SruR/3iDN/1HhAwySJ5en9k/1YvTS8bZmI9/SB9Un37QP49eFJ
4ZD//X1H8jrTUakB3Gq8/eNPIj+MLhds+KU0gH4yKclaRD7dnCtoivIYwAha
j+CV2zTcxAISlrEDSJkIdtimR0MvemX2lbwBFEk5mCJ2i4Y+9RmC+6YHcHSn
tofgDRoW8hSYXF4fQP4rXrRPKjQU9/vE7rJnEN12/C2gn6fhruLW8Pmbg3jz
dFftzrM0PP/KdlLuwSAe2Zgiu1OBhmZsx6O8wwaRnHNMwkuKhmmN9b9Emwbx
1/mfMtNiNNRqGBUKmBzEvIrXT3gP0vDjxtaXc2uDqOKooTK2g4YvegLVKo8N
4S2/kqnff6noMJ8yH5s1hDrHHudWEP3h+5+AeN6mIczV+Dd4eZ6KJkuO119M
DqG2joVF9SgVVRW2Z6TvHsYchi6mfVVU1NqdReoPG0aRQkfPw0VUTMzdom+W
PYxG71dDNr6h4m+hidRfTcP4R+x2HOtzon++yB3btT6MBzVFWp1sqCi55YCa
pt0IZnNeVmswpmKbEtO1yScjuNf1W1u/DhX/W/x73+rNCH7+a7dL8zwVA59K
l7tOj+C0EF/fy21UtMq8YGCjOYrL4wFme5mpGMydKDRlN4pZvKfi765QcOef
q6bq4aMY8IV0CcYpmPfk5j/+5lHcLl7w8mgWBdVUyr65nxhDfaF7O8fjKGin
pLpee2sMD70q36YWSsGE3UvN6w/GcN/VyS3O1hTMPq530DR7DL847m7/LUXB
w/N6e1v5xnF8ffldTkYzqt661PT29zheif7EQ41tRtud879Os05gjOMJ8wL/
ZhxLLpnet2MC+2/IF00ZNeNFyXqhNukJPBl3pIfM14wL7sncM3cn8Khhv0Gk
D3EeB9i6NDRPoNdfscD/rMgY6hp86kzPBN6JeKM3r0XGlS81M+8mJjAn2eyA
kyQZJ/q/KLmtTOC7xYxypoEmTExr+51+aBJvrmUzyx9swl1zWSKnQyfRr+gG
39utTfhPcnOswPNJ1OX8+nRxqRFZZNssV1MncaP2Y/bBhkacV29/G1UxiUNb
v788YdSI9KJViWMfJ3GM09de8WkDviCLKl28OIVX7lxp9XBpQCnN0z7W16fw
7vPr6o/0G/C6+4/Ux7pT2LbjnsMf4QZcr9jOFf9gClX6P9s+Ka3HJuHcEzsT
pnDteGXE/bY6XLxtRzX8OoUez8KcWd7VodizgS6/v1PImUb/Y/WkDnMd6lKf
Mk+jPFP8UohKHRr8FO5z3zuNb/ha4mWaajHh8zUtc6VpvFoUY1ijj1jEydQU
HjeNvVwtd2R5EZ+V/RZySZvGLyls6Wfe12BlqJnJ1dxpZPzA9EHodA22b37U
kV87jR0q4scv8FZj3FOxWNfZafyo0H/QtqQCBwQPP26TnEHSXr5D3WYVePHF
hYobx2aQrfDY1VG+CpSKMRWvPDuDHyubzec8y1HMRFBY+foMsgRpJX85S8Lj
1PDbZ21nUPxhykz8QhmOqCZc+ec8g+O3n7z++aoMn545fCHdewZHutadKv6W
YlmVfWfmkxk8s8L5O7yoBI0CpXw83szgxedmKY2GJehms5nhQcEMXopTxTz2
Ejx22cftKmkGkzyNfd6YFqPIom93ftMMyrY7xV7nLULnn5rZME48TwrXuVZb
iLeY0u0M6TN4vSGIZ6tVIdZfazxh+nkGV8vaBuqxAFsc71zn/zWDjz+Pj181
zccz7xzCVNjpWCS2zW4vbz7yV7jln9hGR67h7PuuQXl4K788hH0nHRcdc8/3
nHuHBVbMXDb8dJT7QVaQz8tBjTuWx1jk6HhlC2PXImsO+pyTmJI5Rsd1BZKg
tskbPFES+ebcSTr+99myTmZXNr7m2KjKe56OjYeb5JU8MzD3TPimqBt0PL+R
Wve8Jx1XuJMavt4k1p/fP5MmkY6Rbx35j2vTkfOc0d+fw2lovM3A1cWAjs53
v6wpHklDGXtHHcJhjDf4kn8jJBU1E3WT1I0Jf8p1NeuOp+Chr5dkmszpuP04
n5FoeDIOZpTc1bGi44kdaWmFlCS0Z6e1dlrT8YhKvKoG/yv85f5gn4s9He1f
V91+1vISNcTGF1Md6Vg42tXu5xyPh13fdhY703HCVs37XstzlNalJ4W40zH5
V9cuE6dnOLfxjcc1TzpeDNNq3XMgFn0YfS/99qKjzz6N1khKNP7bIPkzyIfQ
5+2ma812T1HZay5wzZewZ+FGcMPuKJTk1P6m40dH11RNM56gCGx/GSMd/4iO
d1cmeU4PhKHeo0On6/zpaOb0JoxVPATPtm/f1hZAR9t3Xlf93YLwoV7d29pA
Og6M6FGKqf6YtsrJEhdER7HbZx6l8flhaYoGv3YwHT9qFC4VdHkjxV7t+x+C
jxj16VTauWHe52Me/o/pmKO1fMKRyxE5l8pISwQ333goN2xgjZXzn7OUQ+jI
4Cm3wS7+Lt5rM7z6iOBXRmMkab3rGCawMyGN4NkoqfQIs+NA4fV7lU2wjeac
uJqRHqj6Bl2LJZilyXtC2tEcWkZ98kwJlpTeN13y0g6eXT9Wt4/gDx3Re/au
OQNz7Af/CmJ/49DEaIXbnqC4QWn1NMEKztFp3uO+IG/tKJ5O2P9A/PTunIhH
8EmYmXOJ8Heu8L93cRAIUv2b8kUIdivln1JcDAY3+znOc4Q+H6vSFF4mhoLE
tldyQOjHVsx26pVaOAgO+u0VIvTNlLIqO+AdCTFt5l0LRDxM78leE5CIBll6
btlRIl455g/NtnnGwK2+ne/Lvel4PWnqRlNLLDz7EE4VIuIdnH6vytDyBZzP
9Xya50bk09u92orlcWBZZGzd7kJHDrfzS92bX8JbzhOqfU50lJbld15PewWu
JmvH4uzoqH1NOSDyWyJcdI6/pWlLx7jNbktGB5Khz98z7vd9OgqEcTJvuJ8C
aVwdtT/M6NhruiOnbONr2DdysrBRn476ZcMy3ZmvYdCh9Ejlf3SUXea1zldN
B8XkC8fitIj8/WhnlRWbAWzfvnzfStTftMtg+H9C2eAoENn2XpGol7SMVrXm
bAix/jq44SzhT0hh4Q+LN5BB2ja4j6jn6QA7npvvciDT4dASO1H/Ux/yR/Yf
eQff39+w7SD6g8q2a4xO3e/gTB154dJeoj669563dcgDmUuFX9KIfkIKDngg
9F8+yByQyOfjIOrbWSAnL7YAMv00fBZWZvDGwqSJxkwBBJTH8L35MYNi37+J
18oVwlen5e5rizP45p2wzUpbIayuOjHcmiH6WafazRbGYqh88und9fcz2P/m
R9c79WIolZar0WqewQdVLQVaicWwce3fa6W6GeTNXVT/eqwEqPeZ9OaKZ3Do
7XKn/L1S2HdPW1Tg5QwGGZ+M0SwhwY4/bvKxxjPIJ91qocxYDvuHyMYZejM4
tnn99axGOSSLx7sl3ZzBLeor+QKL5SDD1TF/5cIMLuUambkdrISXwoUH/AVm
EJIZ87+5V4PKT2/m/MFpzHt7q+lIYzUsyCS+V++YxrcTUUs87DWw8TTHr1Hy
NA6IfU3JeVUD7HYTu0uLphHyLnMIVSCkryzoWYZNo6fymUMdi7UwGx+vynpy
Go/5NR09wV0H20NyCu5JT2OI2ZE/FnJ1QHqwfjZPaBo324Y+Fnesgz0MX0K3
cE5j6UfR7dzLdfAxdHLr3NQUrshs3XnlSz1cz9q1zyhoCpVeBd+T3NIA1TMG
/BkeU9j4LP5hv2gDTDTfvTRsO4WFuuP/ed5tgIrkqbIdOsR5ziR6Z1NvA+RI
9sX3i05hM0shz9S7Rrh8ysv7beMkfprtK1RvboTuQ1k1UyTiPqK25hI23gju
m+IH2XMnUS/wx25jziYoiaYqXoidxKuDNU+e3m+Cb035V6TvTeKbtYeLn/eS
IfHzuWzpTcR6payZTHJkcDv9Kor8cwJbik3jPl4mQ7a/3MitTxP4lY9nF9cD
MrAK7VTQ6ZzARrP2nf1IBntalPO/xAn0N2U/oabZDDNOe39+PjGB/BEZLFvM
mqFY9GXjVokJbHheJBHl2gyMLan2wgcmkMOZ4fm/+Gbgj11gVWKawCe9W0B7
tBkGAxs7wlPH0cz++qLZfDPovbs37xg8jtn9EboX1pohilfzmLrNOD5LmcnQ
3UsByx9PfeYVxjFw8w9xdh0K0NMEL1R3jGFa1acaJ1MKvNtivNOgdAwbrwjl
ZTtSgFpk5Lz8cgwzZJI3OEZSwMy78x+X2RjqbNM7G9tEgQ37uNT/ro4iec5c
5qAIFewDnlSOiI5iw1zuzVNyVPDdVHHv85ZRPPDy5MDOs1To0Dv2+uf8CArf
7a3Zr0mF/ckJwFg8gttHAlQsfKkQfHPdm+ncCGYk+1dmh1BBdOOYwcaDI7jD
H3flx1ChbZYz6B/TCPq1XrbnzKJCIstb1p8tw2gV/aJkfysV7rL7fvqkPYzV
i8KvYnqoEGmoc/LzyWE8Pkw91jVCrG/61Xx+3zDeZrxmn/6FCk/SuFN/Tw9h
2KndEad+UOFt3maVjc1DOJLWdjP+LxUeMsZycr4ZwnsvWLoLWWng5/dT4MiD
IRR0sOSw5qLBrW8xrCo3h9CqyXTp6w4aaPxncM6MmIfq3yQ0aB2kgZueNyV3
dRCdRs1mUhRooB8+oe/xeBBd9u5qzz9Lg7vvOoer7w8ih8DZoNALNBCUNvjB
fGMQqQ5pXumqNLCfGt76bscgirdIq9Jv0CChlf0Z258BdM5rYvl+iwYst7Q6
7EcHkGtPlb2DPg2ca8gm2q8H8NrVpuIPd2hAlhe/1Bc0gD92HuSQMKbBHvsd
UwZWA1jrak07Y0qDlyY7vBauDaD6GdLR/RY0MGPl0A6WG8CjfyIS3lvRIJMJ
8g/vGMCz33+qqNrQoOiSEmVghZiXN92Nin9Ag5lU/rGI0X7UfFZSQbInnkfw
y6jX9aNe5PkdmY40UKf9+rs3vR/jlBu+33OmwSPeQu+l4H4c9tFJWnahQe2v
kh899/sxUi/QSsuNBl2+jXF1N/px2Vg2M9idBry8K1nl8v3oEPAyNcyD0Auo
+tW7+tGS1+jdXU8a/AtmXGxd7UPPIac9W71oIKPd8+LDRB/q7hI8FUjwhfbK
p1xNfaiatH67h2CF2ufbL2X3YcT4z4H//T/Mo6eJmoFP+tCD4fTfTwSbnDEM
67Hrw/y/KruKCT59nrwgrdWH+lUf/dQJds/lKXxxsg/Tzu8JbyD2F91H38J5
oA/Ptog82UKw5nsZyehNfWhNstU7TNg7KvFGJP1DL97W0VM5SPijvRbS0vi+
F3tu67/97kqDj9WHVb4X9iL3yI62OEKPr2VXeyRf9OIvkgEDH6HXiCBbrItX
L146LhP9gNCzSPVPRfvdXpR2LutLJvTuJDM5HFPuRZu/F/a8IeJR9DzgY45k
L+adUykII+J1zu74VRmeXgy9dO+j8n0aGH2G2obfPchX2u533YyI777Psbsa
e/Aj/1xAvAkNbDuHlYeye5AnPN6m1ogGf/OxLCeiB41/3z+aqEcDj23OFt56
PXgIWEq1dIj4cA3+8VHswU1BR4w+E/m4Tr9BjxLtwbBPfZ5v1GjA8J+Y/txS
N4rdPB7Ze4WojwumcoeHuvHppyWesUs0OOjkvOxT242Fr2MKg8/Q4LCVSbv+
k24s0Q58cJiol/rnHofpDt34cefnmbfyNNjaPvDPW7cbzTewH1c7TIOO6sCI
OdFujLOdN2fbSaxnVdkb0dCFG9awPpebBuHftltnvulCcvkvAxk2Gki8OuXU
GdWF32E2YYiBBmKebFcNDLtwOaiGt/UDFT4JpTNp/+vEkAcnbvlOUaHbU0GU
abYTRRZ26u4i+kdHwtMI8vtO/HOrbvVHGxX4lS7HPnrVicfCAnQtiqjgF/Xh
74cznch/cSjq4lsqLMe+Gjsi0omPv/5lZ06nAkcorfIpRyf6e3BznXlGhdoX
wSVh4x1o3qzb8ciFCpY3+Coc/DqwS1dWjnSUCtbCEYwnX7RjR2/Pl3xJKqip
D701smlHRocq++fCxPr8iZO5F9uxJeFijxQvFaLkNM8Vf2vD/f9oT54sUeCj
rdKQu1obSo1E7oVcCqTVSgevbX2P7DE5b2VeE/0+8/NHp5lW7HzWUM3zkgJP
L92l8lS3os6HVaW8YOJ8YLogWmvTitefFMmeN6aAKgvjpZHuFryW8VmYZQcF
LrolKomm05D67RSPBBsFQmJ1Sv740JDlM/+vixspcOCB6dKSLg1blGydtRaa
oZzPYVKbm4YpPz3Z/zU1Q+PPhzZ0HyrewC6PMIdm2EvZ8nG7CQVDrfPT1yhk
UM64IRCnTMbfHHvbjlWTAa0XrO4Kk3G2S3+/ZQEZLGq+HdDeSEZtmdFttXFk
yOAy9KivakI5PflT0pZk+P5WeDbxSBOqhy/HKW8hw+KG1+L64o14cLdmQJ1y
E5x7/e7OWfl6tA6U3XWS0gABxZ5kFb9qNBZlTzlS3QAPmd3ilW5WY8Sm4OOy
hQ2wwdiU30+oGisui385kdAARkK/VAqbq3Dj4ehVzwcNICtjp/+bqwpnRXz2
f+ZrgB+a3Rkz7yowImqdd/5BPVwwX5nz3UFCcye+IqkjddDyKSr7dWARPnzr
R7e6UgO2ImXL9rLZ6Px9TWhNoQZm55b4uNazMJek8y7tUA007r7hs9yahcsK
l/Jl2GpgKaB09ZlFFtoO0yeudlQD70qwqUhGJt5Usezx06+G3vdPopkkMtCv
nPqTI6AKmilBWzTM0vCntnrYNdcqULU/RF4/nYb/FFlfp1lVwTzrtt2z24i5
Vj5YO1yjCmKdO4t0MRUPF20tuydQBV6vBuf6dqdi212ni3saKmG2A0JKh5NR
6bWoXsyOSkBy41Vmxlco4N+9SZK9Ei4I5bxNqU1Apzay9MCmSni1yuYa5JWA
kw0em02/VcBjrfh06d8v0WBxl82d9xVgN6y7PP41HgdqDtSSgyvAYJv6HunF
Fxijyp9wk70CnN3LvXfviUWNZJruceYKOJTPF9M0HvN/NdxrNNR5GAfwNpbU
lkyaNpdGjEUq5ZLRYX4logztUqNEbo2jKRq5FsqtXMe1QrmV+21dQr8/a57S
REJKN9ojFKvbTthilcv+/y/25eec59VznnOe833zhd7Zmd1bFgnE2do3XVJ0
GTaJX4YfmCTQs7HSPcv1LsNev0pHnxcEqssdE5jvzQAzrnBmRRGBZK8QNtPh
afAjV75/dR6BBgXl/WCZBvbC3DqtLAJhnjuvaWUaXHt7yCIxiUA2rTMm2nmp
UGNqk6UTRKD8qdW0DVEpoENjxN/hEOi9cc+NfpUkCDHYKB1mRSAph17r2LJE
YONMb445gdIDJqsSDBPJ+2sf1mURyCDuBDPBNgGGfB0Mx5gEandT3m8ZHQcv
Ij8UWKkRKMTbzdZfIQ5cRsoHRcoEMk9pU/yYHwu6X+paPtIIZNZ4K7q+9RI0
TBZg9lIyD6RLKYXOxYDuqOSg1QJGx3ZJCZ4kxcD0g+yK498wiuw2avdSjYFX
P/sHD05hVMwTMPahaHgeJTrQMYpRUgLfveNiJAQX6Z0OHMGoh0dLnVgXCfeW
rjRkvcZo1fNX2nYVEXD8n/mi7y8x+nwm/ZZ5/gV4UaIxfrYbo1ln1V0yJmEg
u3351+5OjILOt0hz3UJhvUZ6pmEHRkbtAtFs7Dno/aSasbsNI/dzWxv1+0Og
ejjl3V+A0Z3O1Pa2JSFQUHqhq6AVo6iVNYE5OsHwqcvWwJ7ASK78pKt6WCCM
S+Qa993GSN6YFdhZHAC6OYutVF5qU1s1VNPrD4dHP7tW1mF0uyDCZxvzDHRW
75z+UoPR3Gk9//t2fjAQ7brK4XeM+HNzySlnBbCuLRg4lRg9tTMu8sv3ARf6
Nu67coyqZ96KNKdPgrovh59VhlGKSJyrZ8uHBdazb86lGHlNheskFHlDTOeg
zI4SjBRVi222zXlBg3uyUKMYo4k3dRKVgzwoZislaxZhlDEsmd9f5QlHC8Wy
poUYmcXyeY3SHtDzZmjW6yZGTTPjCo4ubsA40eNZcoPc5+38kUOnXGCZeN7i
WwFGnhfMhx03OAG/YiLHg/T3R+K58sdcUJIyOjmUT87baaw1j3aAPz941whI
X/XbvIy+41e4RJicoJM+ZSLmG/ftAz+Z41mP8zBKLWqaTWPtAUnlLdN80jbH
Mufs2CaQYFa6Jo90UnzjgYMDLKC5WX+m+lWyH+9uOBLAAjXHjIZrpO+Gx9ce
rzCGCVlO8FXSuk/X+obSd0CxcpX/FdIq4jGLyDoj6BIRAZdJS7P+3hTLMYL2
+sGYdNLu7FiNjChD6OdYDyaTxoXaUCnRB+FLxUUh6Xu7vsrWx+vD6YlkTcq7
RW0umKkPWt2JEYmkXSct9O47bYeLWmW+caStzezEIqEetDJGGmNJG90Oonff
2woKxR0/UBbUGZwfmN0CSdzc0ouknbmGSV94m+Hmbyd1o0mfMe1L12XrwLma
1VlUv8zrBUaUSYA2JGV7ylGulr4SZVWhBQsKtG8RpOtXiBo86b+AXoHPWcrm
Iu6YH0cTzJqD5i+QfkcfZkZEMSE/LW0NZY9Pwkc5EnXotissPk96VCnTuJKp
DjGZHqaUn9g7VRNOG4Hb9T44nPRb9dqz1UIG2DXVqVDuqpJUPJxVhfTNWu1h
pIl/DSbHeSrQ2qykRZl3iYfV2eshri/rdSjp9ZbKxrsq1pH/RnyN8lAgv92F
Tgf7wtyjlE3njHmhUYrAcmZupDzm503LltCAVnD44znS1wXD3U1OCvDCd2cz
5SVYTqtcKA9hDzqFlHuuBzwc5f0E81UyXpRt7zyMVGPLgb3KpDnllpbn+53p
MhBIj2dSPsJ01ciSLAXX64+WU54/6kYrEy6KVlXe/Ur1+8ivZ35hsGdF4ZYe
Y5Rrq3LGMyVTonJ+7QBlTmzzYwb7vShDqaqPstO6kQ4Ge0D0fz/QIGNzbo9W
6B//AfME65g=
         "]]}, 
       {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{0, Small}], 
        LineBox[CompressedData["
1:eJws3Hc4lu8XAHCUERGVIlKISqKFlDqEUlJpCYlCUcoooqyMFMlW2dlS2Zv3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         "]]}},
      Axes->True,
      AxesOrigin->{0, 0},
      PlotLabel->FormBox["\"OR = 7\"", TraditionalForm],
      PlotRange->{{-0.25, 0.25}, {-1, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{Automatic, Automatic}], {967.5, -756.}, 
     ImageScaled[{0.5, 0.5}], {360., 1440.}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.4029231406785955`*^9, 3.4029232060626125`*^9, 3.402937490140625*^9, {
   3.411391313296875*^9, 3.411391357015625*^9}, {3.4113914168125*^9, 
   3.41139143815625*^9}, 3.411391578375*^9, 3.4118091602939024`*^9, 
   3.411809552267533*^9}]
}, Open  ]],

Cell["\<\
Comparison of the cumulative distribution functions shows the distributions \
to be very similar. In our example, we compare distributions with orientation \
ratio 5: \
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124178430984464`*^9, 3.412417881914261*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"S\[Theta]", " ", "=", " ", 
   RowBox[{"Integrate", "[", 
    RowBox[{"s\[Theta]", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", " ", "0", ",", " ", "\[Theta]"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"OR", " ", "=", " ", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"NIntegrate", "[", 
          RowBox[{"u\[Theta]", ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Theta]", ",", " ", "0", ",", " ", "x"}], "}"}]}], 
          "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"x", ",", " ", "0", ",", "\[Pi]", ",", " ", 
         RowBox[{"\[Pi]", "/", "50"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Dotted"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"NIntegrate", "[", 
         RowBox[{"t\[Theta]", ",", " ", 
          RowBox[{"{", 
           RowBox[{"\[Theta]", ",", " ", "0", ",", " ", "x"}], "}"}]}], 
         "]"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", "0", ",", "\[Pi]", ",", " ", 
        RowBox[{"\[Pi]", "/", "50"}]}], "}"}]}], "]"}], "]"}], ",", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{"S\[Theta]", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}], ",", " ",
      
     RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], "]"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\[Theta]\>\"", ",", "\"\<CDF(\[Theta])\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", "OR", "]"}]}], "Input",
 CellChangeTimes->{
  3.4029249808646526`*^9, 3.402925040560491*^9, {3.4029250739685297`*^9, 
   3.4029252037952113`*^9}, {3.402925240918592*^9, 3.4029253077446833`*^9}, {
   3.4029254477259665`*^9, 3.4029254483368444`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Dashing[{0, Small}], 
     LineBox[{{0., 0.}, {0.06283185307179587, 0.008953698480126244}, {
      0.12566370614359174`, 0.017964207330086624`}, {0.18849555921538758`, 
      0.02708960201338858}, {0.25132741228718347`, 0.03639053691670478}, {
      0.3141592653589793, 0.04593165862387809}, {0.37699111843077515`, 
      0.055783173164020775`}, {0.4398229715025711, 0.06602262708499869}, {
      0.5026548245743669, 0.07673696822394965}, {0.5654866776461628, 
      0.08802495705262879}, {0.6283185307179586, 0.10000000000000013`}, {
      0.6911503837897545, 0.11279346545722657`}, {0.7539822368615503, 
      0.12655850857614534`}, {0.8168140899333463, 0.1414743493769351}, {
      0.8796459430051422, 0.15775077940730475`}, {0.9424777960769379, 
      0.17563234689335946`}, {1.0053096491487339`, 0.1954010822602216}, {
      1.0681415022205298`, 0.21737562966926832`}, {1.1309733552923256`, 
      0.24190310519170272`}, {1.1938052083641213`, 0.2693379386249301}, {
      1.2566370614359172`, 0.30000000000000643`}, {1.319468914507713, 
      0.3341044626661063}, {1.382300767579509, 0.3716621870973821}, {
      1.4451326206513049`, 0.41236676714143566`}, {1.5079644737231006`, 
      0.4555116570111327}, {1.5707963267948966`, 0.4999999999999993}, {
      1.6336281798666925`, 0.544488342988868}, {1.6964600329384885`, 
      0.5876332328575329}, {1.7592918860102844`, 0.6283378129027039}, {
      1.82212373908208, 0.6658955373339148}, {1.8849555921538759`, 
      0.7000000000000682}, {1.9477874452256718`, 0.7306620613751169}, {
      2.0106192982974678`, 0.7580968948082429}, {2.0734511513692637`, 
      0.7826243703308228}, {2.1362830044410597`, 0.8045989177398551}, {
      2.199114857512855, 0.8243676531065502}, {2.261946710584651, 
      0.8422492205919652}, {2.324778563656447, 0.8585256506205683}, {
      2.3876104167282426`, 0.8734414914256989}, {2.4504422698000385`, 
      0.8872065345427895}, {2.5132741228718345`, 0.9000000000000132}, {
      2.57610597594363, 0.9119750428480098}, {2.638937829015426, 
      0.9232630317814028}, {2.701769682087222, 0.9339773729150941}, {
      2.764601535159018, 0.9442168268360747}, {2.827433388230814, 
      0.9540683413759818}, {2.8902652413026098`, 0.9636094630822515}, {
      2.9530970943744053`, 0.972910397975777}, {3.015928947446201, 
      0.982035792669915}, {3.078760800517997, 0.9910463015198738}, {
      3.141592653589793, 0.9999999999999987}}]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{0., 0.}, {0.06283185307179587, 0.007670296304019849}, {
      0.12566370614359174`, 0.015438399706947346`}, {0.18849555921538758`, 
      0.023404277815222557`}, {0.25132741228718347`, 0.031672181285304114`}, {
      0.3141592653589793, 0.04035267831232459}, {0.37699111843077515`, 
      0.049564526776086956`}, {0.4398229715025711, 0.059436273879578144`}, {
      0.5026548245743669, 0.07010742692247071}, {0.5654866776461628, 
      0.08172898553504207}, {0.6283185307179586, 0.09446307132359813}, {
      0.6911503837897545, 0.10848134537475365`}, {0.7539822368615503, 
      0.12396188176394245`}, {0.8168140899333463, 0.1410841843894696}, {
      0.8796459430051422, 0.16002211523073553`}, {0.9424777960769379, 
      0.1809346622359094}, {1.0053096491487339`, 0.20395472340192208`}, {
      1.0681415022205298`, 0.22917641262146932`}, {1.1309733552923256`, 
      0.25664177144560085`}, {1.1938052083641213`, 0.28632814130270573`}, {
      1.2566370614359172`, 0.3181377325693297}, {1.319468914507713, 
      0.35189103070643546`}, {1.382300767579509, 0.38732552909764795`}, {
      1.4451326206513049`, 0.4241008364918353}, {1.5079644737231006`, 
      0.46181049920136263`}, {1.5707963267948966`, 0.5000000000000007}, {
      1.6336281798666925`, 0.538189500798639}, {1.6964600329384885`, 
      0.5758991635081674}, {1.7592918860102844`, 0.6126744709023566}, {
      1.82212373908208, 0.6481089692935709}, {1.8849555921538759`, 
      0.6818622674306758}, {1.9477874452256718`, 0.713671858697277}, {
      2.0106192982974678`, 0.7433582285543581}, {2.0734511513692637`, 
      0.7708235873784557}, {2.1362830044410597`, 0.7960452765980722}, {
      2.199114857512855, 0.8190653377640831}, {2.261946710584651, 
      0.8399778847692536}, {2.324778563656447, 0.8589158156107392}, {
      2.3876104167282426`, 0.8760381182366417}, {2.4504422698000385`, 
      0.8915186546252493}, {2.5132741228718345`, 0.9055369286764468}, {
      2.57610597594363, 0.9182710144649593}, {2.638937829015426, 
      0.9298925730775308}, {2.701769682087222, 0.9405637261204233}, {
      2.764601535159018, 0.9504354732239145}, {2.827433388230814, 
      0.9596473216876769}, {2.8902652413026098`, 0.9683278187146973}, {
      2.9530970943744053`, 0.976595722184779}, {3.015928947446201, 
      0.9845616002930542}, {3.078760800517997, 0.9923297036959815}, {
      3.141592653589793, 1.0000000000000013`}}]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVx308E3gcwPHNPGxcZ9EWnYe0uMpKciVt+v5aKQ93Kpc7PSmTaBVWvayk
l54o0TB19EQ4D+lBbplyJQ8pCSnyMKVl87BhKyEm3O/++Lw+r7cNN8wnSIdA
IHjj/j/pqWGDfDl/dY9jfOVtZ9fVtsoyllXKRvCkH53NrJ8D2vsOe9pFu+CT
qGfxWN0i6J4VMiYRhcFVR9qMkbpVIF1/tjJHFA3fPqpeedd7wrtdop9viBIh
428DeV/DNvA5YC5NE2VA4BvWad47HiQP7RD/JSqEDepg4jFNJLCqPQ05h8uh
jBEQsPhCAoRHegeIw2tA/f7mQ8bTy3DwYZBQh9EI3T57U0YKb0Bznwclj9sM
tNzneaq0bLjgMEqQbG2DB0Zmr47H5wPfvuZyec57YMiXzykR3gNt4P57H0Jl
YGv1/Gz/lX+A++SPTUl7u4BeSMpYQ5VA4Jfm8vLzCmgX002lrqWQsLQkLDe2
B+L8aTK7xDLQKS9xPhvZB+lF/XnytAqYucir4WOaCu6EmB+h//kM3DM42Z9F
AzAscFdOWLyA2Zq69dElang9c0g44FcLV1+UEkn7PkNBtZvhrbJ6YFuumZ67
5wsYOmXPUyY0gr2MqjhxZAi4G4sXzBK8hbv5JiHFh77Cuvum3UzfZojq3Nlk
HzsMbOVbaltoC/DZK73SL41AhyC1g5vYBtqMddz+pFGobOHGLE2VQmP41d2C
rG+wSl6mmNH8Hlw2zJv6kDkGkymrjH753Akv3Vzy0fVxKIgQtYtPySCn6IpL
120tWD6+TFLd/AQ0BpPnf2sC7pnIk/0KuuAtkXza/PF32D4RXeFdLYdi8uHc
xpeTkDh5SnKyWQFMGpXHrZ6CgR+Nv+rXdoNGODrLqWUafCuMOfm1PcA4d84h
jEdAxPyV7crCXuja1iHl9BJQ7Iet7LGYPnDvbhovDiUiAwuPgc0BSjh6KCiE
PkhEjrW6UbY2KvCWXPOkR+igwaZE64QuFai/86JIozooW/m8fUlcP2S2nnoQ
epiEfg3cEhNsPQDaENfdxyZISFp6g1AvHgDLyeTt/EhdJIt4E6frOAg9G+Jr
ybp6iHNGVdpdMAhVdnVgFa+HLPbtF0XR1MAj5+raUPRRubOtG4SqoeTmfNeq
ZH2U08rwnv9MDQ0sdrXPTAM0Td3cOWKkgTHetd93Cw2Q+P5Cm14vDdRsyvCd
QSejSmpuhDheA1wXdl7eJTJ69IIvyK7SQFbbiQOfLClobUJIMGdKA8xYbdMX
bAeTip0e2BInAUvHioKO+Ztv2YT9ShhuyMCu++0l8sceXheYvwfbLNNuTiT2
+iJ3RS/2wt7WuiJsVZzpDrU1BR33+2mZzbQGjjgnVU1ht4aFLliAPaX4wd54
LgW18yqsHLBNkb7WAfugcbCRKzZ7dCyVj32SWaTwwxZyO5uGsdeeWZOahG1G
3c7Ss6GgTE7KxVTsrCetWTRst2HFmXTsErM3/BXYRsvOh9/BljVUGR/FtnVs
8KjB5kUhwXls3+vW6DX28MInnWnY1kT+ihZscozk7iPsuf+aMhTYomVOtFrs
JSZB5v3YFrLCKCl29F6J8RB27kWmQoU9/tBAfxzbkXXLawL7nOHW79PY/wF0
m11A
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"\[Theta]\"", TraditionalForm], 
    FormBox["\"CDF(\[Theta])\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0., 3.141592653589793}, {0., 0.9999999999999987}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.4029249835284834`*^9, 3.4029250692817907`*^9, {3.4029251280162463`*^9, 
   3.402925171799203*^9}, 3.402925205717976*^9, {3.4029252477183695`*^9, 
   3.402925273054802*^9}, 3.4029253091266704`*^9, 3.40292546093496*^9, 
   3.40293749196875*^9, 3.411391579765625*^9, 3.411809554681003*^9}]
}, Open  ]],

Cell["\<\
As expected given our last evaluation, the variance of fibre orientation \
angle is also rather insensitive to the choice of distribution function:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124178999201517`*^9, 3.4124179478490705`*^9}, 
   3.412935076127755*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"OR", ",", 
           RowBox[{"NIntegrate", "[", 
            RowBox[{
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"\[Theta]", "-", 
                 RowBox[{"\[Pi]", "/", "2"}]}], ")"}], "2"], "t\[Theta]"}], 
             ",", " ", 
             RowBox[{"{", 
              RowBox[{"\[Theta]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}]}],
             "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"OR", ",", " ", "1", ",", " ", "7", ",", " ", ".2"}], 
          "}"}]}], "]"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"OR", ",", 
           RowBox[{"NIntegrate", "[", 
            RowBox[{
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"\[Theta]", "-", 
                 RowBox[{"\[Pi]", "/", "2"}]}], ")"}], "2"], "u\[Theta]"}], 
             ",", " ", 
             RowBox[{"{", 
              RowBox[{"\[Theta]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}]}],
             "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"OR", ",", " ", "1", ",", " ", "7", ",", " ", ".2"}], 
          "}"}]}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Dotted", ",", " ", 
        RowBox[{"{", "}"}]}], "}"}]}]}], "]"}], ",", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{"\[Theta]var", ",", " ", 
     RowBox[{"{", 
      RowBox[{"OR", ",", " ", "1", ",", " ", "7"}], "}"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], "]"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<OR\>\"", ",", " ", 
      "\"\<\!\(\*SuperscriptBox[\(\[Sigma]\), \(2\)]\)(\[Theta])\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.40293835853125*^9, 3.40293851690625*^9}, {
  3.402939695375*^9, 3.402939707421875*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Dashing[{0, Small}], 
     LineBox[{{1., 0.8224670334241152}, {1.2, 0.7771915245584473}, {1.4, 
      0.7395146735065796}, {1.6, 0.7074506884488131}, {1.8, 
      0.6796886218598244}, {2., 0.6553188871530862}, {2.2, 
      0.6336855713699504}, {2.4, 0.6143008752868675}, {2.6, 
      0.596792737872516}, {2.8000000000000003`, 0.5808713156058469}, {3., 
      0.5663067256942875}, {3.2, 0.5529138040463057}, {3.4000000000000004`, 
      0.5405413878190608}, {3.6, 0.5290646053895111}, {3.8000000000000003`, 
      0.5183792180702118}, {4., 0.508397393873427}, {4.2, 
      0.49904450114183535`}, {4.4, 0.49025664164919003`}, {
      4.6000000000000005`, 0.4819787285571334}, {4.8, 0.4741629716974006}, {
      5., 0.46676767139405917`}, {5.2, 0.4597562488145662}, {5.4, 
      0.4530964596439019}, {5.6000000000000005`, 0.44675975128238765`}, {
      5.800000000000001, 0.4407207334564045}, {6., 0.43495673922143274`}, {
      6.2, 0.42944745858607114`}, {6.4, 0.42417463091388685`}, {
      6.6000000000000005`, 0.4191217852290836}, {6.800000000000001, 
      0.41427401981715245`}, {7., 0.40961781425489535`}}]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], 
     LineBox[{{1., 0.8224670334241152}, {1.2, 0.777426619369399}, {1.4, 
      0.7402447412362183}, {1.6, 0.7087571046736296}, {1.8, 
      0.6815714066312533}, {2., 0.657741131520916}, {2.2, 
      0.6365948347097656}, {2.4, 0.6176397845468387}, {2.6, 
      0.6005042579727262}, {2.8000000000000003`, 0.5849012958061415}, {3., 
      0.5706050148147706}, {3.2, 0.5574346281570786}, {3.4000000000000004`, 
      0.5452433237985351}, {3.6, 0.533910364706214}, {3.8000000000000003`, 
      0.5233353398453826}, {4., 0.5134339069350298}, {4.2, 
      0.5041345864760418}, {4.4, 0.49537631143693966`}, {4.6000000000000005`, 
      0.4871065294056271}, {4.8, 0.4792797148227195}, {5., 
      0.4718561898777949}, {5.2, 0.4648011806512727}, {5.4, 
      0.4580840546249083}, {5.6000000000000005`, 0.4516776995042088}, {
      5.800000000000001, 0.4455580132171064}, {6., 0.4397034821681399}, {6.2, 
      0.4340948301379275}, {6.4, 0.42871472417045775`}, {6.6000000000000005`, 
      0.42354752676344665`}, {6.800000000000001, 0.41857908593443066`}, {7., 
      0.4137965564649843}}]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVx308E3gcwPF5ipYxWY3tdW46j7nSlR4UfX9xTcRMDx6TKQ9H5KHryOJI
yWVcOKpbNTsPL5dUyzyUuqI4hdediytuswdZZxXrQUyy+90fn9fn9bY9kLIr
Vp9AILBw/3+LcJRBIGhge+tYUF2QGkYWP276wVgDItvcQ8oANWSmNzMtzTUg
7onwY/ipQezNS3Kw0YDhgcFdQi81rFa5t/l7aEBla5/Utk4NDJeKwAuZGsjX
SK65L1eDYfPOnLVvNDDPMrXLlUxAX0/bPzHKNxDpm3RfmjwB99EkI/L1O3h2
1panLv0XBqJCoxuHpkHvUtCq+eEXkLQ/LCNBPAOThpviBza8gMTGZuqtdi0w
BTetIipVUFDNbOJUfQQ2MSOebKYCI/XaYX7jJ7j39py1zelxMCO3DHqJdNBV
+HXga9I48CdbxhmPCEjWHnuss/Y5cLKRg7pfD7U5HA7jeD4HcVRMTFSHPjLn
GYTQxsagX7S7mHjDAB2NLJkVnB0D6tVUru6mIapvuZu21nMMNFrH+KoaI5SS
llRz/L0SPk6ZWhVdWYQ2SCbpt68ooXfv3aaGBmNUm7/6/Ls4JTibmwRk8k3Q
c25eVZ6LEm6l5jaUCBajDhdKc/ekAp7alxsHlRHRye8sLdi3FOCY/8Qp8sIS
NJBcKT5/QgEebJmbgG+KZhWySGmgAuSpp7YW80jILZYkWFihgGb3MFJXqRmy
atisHXgvB+vg34frT5mjZ5d6UyW9crBNy90RvZmM5hKG1v9UKwfWEvEiyztk
lMeO+kWXLQevP8QPaOstkO7mdeHDcDkExvsf9GmzQHutYilBG+SwtdV31sx9
Kfr+ZX/2SoocptdQeF+KliL+ceup8JcyeJhzVD9lnSWqndnoanhVBhEfqjOM
Gy0RNVukCj0ig0H7TcrNdhSUrvc2edpTBnHOB13LaymoNFBkGrhIBveCI7jb
bJYhrTDgUfzgKHwVqv6VIlyGfEcEvOiqUUjMZz71pC9HDp/bUmvSRqEgzmRO
r3w5Cjukty99+yi0fxatU1OoiDTdEeRBHYXWhQKDlSVU9GHdqsia11Loa/JW
F1tYIU2LysOxUwoPGHHdvDIrlFJXaTN3XgonWvcKFURr1CWndYwckUL4Csn+
iGJrpGi1k0z5S0Hb4kp3MaahVyMp/b3OUsgymOiryKGh7GEzmwQTKVDs3KPt
CXTkpLq+e/e4BI4eDn5PPEZHnDOXxT93SWCKR0xcNk9HqSsGC31qJEA7uY1i
j514d9clb2wmN/M3N+wQ1yERYF9MUC3dgz15bnxkI/YOZmd7GXYG122VE3aV
7hiJ/ImO9E+f+csEm50+cYO4QEdFhVTG42oJcBMYETTsxx/I67ux6zghRiux
mVvM/Dqx51ldYb7Ycibl29vY9S5C/ULsuXhWzxVswnjoHiMdHQ31ZaUVYbtI
flygYHtdFBWcxg5+0l1vh1227RU/H/tqh9snb+yHpORuLnboZXLdCey/Gy7S
k7DzK3zYZdh3nN+u+Qb7Gi9nTogdlr2TGYNtyH3F6sAW1C5O24ftmv6F9k9s
j6zDBaHY4Qnh1XLsTLun/D3YBZzSAA02q8ZbxMYWhfTM6LDbtE3d/tj/AdIB
VLk=
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"OR\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\(\[Sigma]\\), \\(2\\)]\\)(\[Theta])\"", 
     TraditionalForm]},
  AxesOrigin->{1., 0.5},
  PlotRange->{{1., 7.}, {0.40961781425489535`, 0.8224670334241152}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4029397213125*^9, 3.4113915803125*^9, 
  3.4118095551616945`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.2.5 Fibre crossings", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.40332917508676*^9, 3.403329177720547*^9}, {
  3.412417963411448*^9, 3.4124179651539536`*^9}}],

Cell["\<\
We model the influence of fibre orientation on the expected number of \
crossings per fibre using the one-parameter cosine distribution. We input the \
probability density for \[Theta]:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124189399055777`*^9, 3.412418941567968*^9}, {
  3.412419027231146*^9, 3.4124190830313826`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"f\[Theta]", " ", "=", " ", 
   RowBox[{
    RowBox[{"1", "/", "\[Pi]"}], " ", "-", 
    RowBox[{"\[Epsilon]c", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "\[Theta]"}], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4033292179383774`*^9, 3.4033292438756733`*^9}}],

Cell[TextData[{
 "We obtain the probability density of the angle \[Phi] = ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "-", " ", 
     SubscriptBox["\[Theta]", "2"]}], "|", " "}], TraditionalForm]]]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124191055938253`*^9, 3.412419157728792*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f\[Phi]1", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"f\[Theta]", " ", 
        RowBox[{"(", 
         RowBox[{"f\[Theta]", "/.", 
          RowBox[{"\[Theta]", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"\[Theta]", "-", "\[Phi]"}], ")"}]}]}], ")"}]}], ",", " ",
        
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", " ", "\[Phi]", ",", " ", "\[Pi]"}], "}"}]}], 
      "]"}], ",", " ", 
     RowBox[{"0", "\[LessEqual]", " ", "\[Phi]", "\[LessEqual]", "\[Pi]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f\[Phi]2", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"f\[Theta]", " ", 
        RowBox[{"(", 
         RowBox[{"f\[Theta]", "/.", 
          RowBox[{"\[Theta]", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"\[Theta]", "+", "\[Phi]"}], ")"}]}]}], ")"}]}], ",", " ",
        
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", " ", "0", ",", " ", 
         RowBox[{"\[Pi]", "-", "\[Phi]"}]}], "}"}]}], "]"}], ",", " ", 
     RowBox[{"0", "\[LessEqual]", " ", "\[Phi]", "\[LessEqual]", "\[Pi]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f\[Phi]3", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"f\[Theta]", " ", 
        RowBox[{"(", 
         RowBox[{"f\[Theta]", "/.", 
          RowBox[{"\[Theta]", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"\[Pi]", "+", 
             RowBox[{"(", 
              RowBox[{"\[Theta]", "-", "\[Phi]"}], ")"}]}], ")"}]}]}], 
         ")"}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", " ", "0", ",", "\[Phi]"}], "}"}]}], "]"}], 
     ",", " ", 
     RowBox[{"0", "\[LessEqual]", " ", "\[Phi]", "\[LessEqual]", "\[Pi]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f\[Phi]4", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"f\[Theta]", " ", 
        RowBox[{"(", 
         RowBox[{"f\[Theta]", "/.", 
          RowBox[{"\[Theta]", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{"\[Pi]", "+", 
             RowBox[{"(", 
              RowBox[{"\[Theta]", "+", "\[Phi]"}], ")"}]}], ")"}]}]}], 
         ")"}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", " ", 
         RowBox[{"\[Pi]", "-", "\[Phi]"}], ",", "\[Pi]"}], "}"}]}], "]"}], 
     ",", " ", 
     RowBox[{"0", "\[LessEqual]", " ", "\[Phi]", "\[LessEqual]", "\[Pi]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"g\[Phi]", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
     "f\[Phi]1", " ", "+", " ", "f\[Phi]2", "+", "f\[Phi]3", "+", 
      "f\[Phi]4"}], ")"}], "/", "2"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"TrueQ", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{"g\[Phi]", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}]}], "]"}], 
   "\[Equal]", "1"}], "]"}]}], "Input",
 CellChangeTimes->{{3.4033324986057453`*^9, 3.403332535358594*^9}, {
  3.4033326914330177`*^9, 3.403332763676899*^9}, {3.4033329622123795`*^9, 
  3.4033329771138067`*^9}, {3.4033330266350145`*^9, 3.403333026825288*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "\[Pi]"], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[Pi]", " ", 
   SuperscriptBox["\[Epsilon]c", "2"], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", "\[Phi]"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.403332799418293*^9, 3.4033330412059665`*^9, 
  3.403334029166584*^9, 3.403335053809949*^9}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.403332799418293*^9, 3.4033330412059665`*^9, 
  3.403334029166584*^9, 3.403335053940136*^9}]
}, Open  ]],

Cell[TextData[{
 "and hence the probability, ",
 StyleBox["pcross", "Input"],
 ", that a pair of fibres cross with any angle:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124191885831585`*^9, 3.4124192227122335`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pcross\[Phi]", " ", "=", " ", 
   RowBox[{
    SuperscriptBox["\[Lambda]", "2"], 
    RowBox[{
     RowBox[{"Sin", "[", "\[Phi]", "]"}], "/", 
     SuperscriptBox["x", "2"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pcross", " ", "=", " ", 
  RowBox[{"Expand", "[", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"g\[Phi]", " ", "pcross\[Phi]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}]}], "]"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.4033332118313136`*^9, 3.403333281862013*^9}, 
   3.4033339921433473`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[Lambda]", "2"]}], 
   RowBox[{"\[Pi]", " ", 
    SuperscriptBox["x", "2"]}]], "-", 
  FractionBox[
   RowBox[{"\[Pi]", " ", 
    SuperscriptBox["\[Epsilon]c", "2"], " ", 
    SuperscriptBox["\[Lambda]", "2"]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}]]}]], "Output",
 CellChangeTimes->{
  3.4033337520380926`*^9, {3.4033340004853425`*^9, 3.403334029697347*^9}, 
   3.4033350545610285`*^9}]
}, Open  ]],

Cell["\<\
So the probability density of crossing angles for those fibres that generate \
a crossing is:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124192574121294`*^9, 3.4124192825983458`*^9}, 
   3.4129350887358847`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"h\[Phi]", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"g\[Phi]", " ", "pcross\[Phi]"}], ")"}], "/", "pcross"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"TrueQ", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{"h\[Phi]", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}]}], "]"}], 
   "\[Equal]", "1"}], "]"}]}], "Input",
 CellChangeTimes->{{3.4033333774694896`*^9, 3.403333563527027*^9}, {
  3.4033343157686977`*^9, 3.403334376445947*^9}, {3.4033344708116384`*^9, 
  3.4033344903897905`*^9}, {3.4033345496750383`*^9, 3.4033345520885086`*^9}}],\


Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{
       SuperscriptBox["\[Pi]", "2"], " ", 
       SuperscriptBox["\[Epsilon]c", "2"], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "\[Phi]"}], "]"}]}]}], ")"}], " ", 
    RowBox[{"Sin", "[", "\[Phi]", "]"}]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "6"}], "+", 
      RowBox[{
       SuperscriptBox["\[Pi]", "2"], " ", 
       SuperscriptBox["\[Epsilon]c", "2"]}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.403334618333765*^9, 3.4033350546711874`*^9}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.403334618333765*^9, 3.403335054911533*^9}]
}, Open  ]],

Cell[TextData[{
 "and we recover the result for isotropic networks when ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Epsilon]", "c"], " ", "\[Rule]", " ", 
    RowBox[{"0", ":"}]}], TraditionalForm]]]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124192885569134`*^9, 3.412419315525693*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h\[Phi]", "/.", 
  RowBox[{"\[Epsilon]c", "\[Rule]", "0"}]}]], "Input",
 CellChangeTimes->{{3.403334735161755*^9, 3.403334741891432*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sin", "[", "\[Phi]", "]"}], "2"]], "Output",
 CellChangeTimes->{{3.4033347421417923`*^9, 3.403334752326437*^9}, 
   3.403335054961605*^9}]
}, Open  ]],

Cell[TextData[{
 "We plot the probability density of crossing angles for different \
eccentricities, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Epsilon]", "c"], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412419331959323*^9, 3.412419354231349*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"h\[Phi]", "/.", 
      RowBox[{"\[Epsilon]c", "\[Rule]", "0"}]}], ",", 
     RowBox[{"h\[Phi]", "/.", 
      RowBox[{"\[Epsilon]c", "\[Rule]", ".15"}]}], ",", 
     RowBox[{"h\[Phi]", "/.", 
      RowBox[{"\[Epsilon]c", "\[Rule]", 
       RowBox[{"1", "/", "\[Pi]"}]}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "Dashed", ",", "Dotted"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\[Phi]\>\"", ",", " ", "\"\<h(\[Phi])\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.403334389514739*^9, 3.4033345600699854`*^9}, {
  3.4033350222345457`*^9, 3.403335023866893*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd2Hk8VF8fB3C0WEolFEVJmyRrkfUzPEVRtvYsRSmkshQq0qq0yJ4UikL9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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{Small, Small}], 
    LineBox[CompressedData["
1:eJwV2Hk8VN0fB3CEUD1KISKlTRJCtOAztMiSQlpkKdlC2YoKKUlUPzEVpSIl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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{0, Small}], 
    LineBox[CompressedData["
1:eJwV2nk4VN8bAHBm7EuRLbKX9KVI9izvSVGWFBWyb1GSbNEi2kMilBCRsrRI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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"\[Phi]\"", TraditionalForm], 
    FormBox["\"h(\[Phi])\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->
   NCache[{{0, Pi}, {0., 0.49999998538414625`}}, {{0, 3.141592653589793}, {0.,
      0.49999998538414625`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.403335017017043*^9, 3.4033350244978*^9}, 
   3.40333505520195*^9}]
}, Open  ]],

Cell[TextData[{
 "The mean crossing angle, ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Phi]", "_"], TraditionalForm]]],
 ", is not affected by orientation, but the variance of crossing angles \
increases with ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Epsilon]", "c"], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.41241936656909*^9, 3.4124194143978643`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"\[Phi]bar", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"\[Phi]", " ", "h\[Phi]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"\[Phi]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"\[Phi]var", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Phi]", "-", "\[Phi]bar"}], ")"}], "2"], " ", "h\[Phi]"}], 
    ",", " ", 
    RowBox[{"{", 
     RowBox[{"\[Phi]", ",", " ", "0", ",", " ", "\[Pi]"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"\[Phi]var", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]c", ",", " ", "0", ",", " ", 
     RowBox[{"1", "/", "\[Pi]"}]}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(\[Epsilon]\), \(c\)]\)\>\"", ",", " ", 
      "\"\<\!\(\*SuperscriptBox[\(\[Sigma]\), \(2\)]\)(\[Phi])\>\""}], 
     "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.403335233398184*^9, 3.403335340071573*^9}}],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 CellChangeTimes->{{3.4033352351607184`*^9, 3.4033353097780128`*^9}, {
  3.4033353408126383`*^9, 3.4033353599902143`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["26", "9"]}], "+", 
  FractionBox[
   SuperscriptBox["\[Pi]", "2"], "4"], "+", 
  FractionBox["16", 
   RowBox[{"18", "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["\[Epsilon]c", "2"]}]}]]}]], "Output",
 CellChangeTimes->{{3.4033352351607184`*^9, 3.4033353097780128`*^9}, {
  3.4033353408126383`*^9, 3.4033353609616113`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV02k4FAoXAOBJaJE1iuiGiJSylPSVOSVZI1GEKTSTyFwK2RKShqRka4bK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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(\[Epsilon]\\), \\(c\\)]\\)\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\(\[Sigma]\\), \\(2\\)]\\)(\[Phi])\"", 
     TraditionalForm]},
  AxesOrigin->{0, 0.5},
  PlotRange->
   NCache[{{0, Pi^(-1)}, {0.4674011002723395, 0.6451788693426344}}, {{
     0, 0.3183098861837907}, {0.4674011002723395, 0.6451788693426344}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.4033352351607184`*^9, 3.4033353097780128`*^9}, {
  3.4033353408126383`*^9, 3.4033353609916544`*^9}}]
}, Open  ]],

Cell["\<\
Following our treatment for networks with uniform orientation in Section \
4.2.1, we obtain the number of crossings per unit area in an oriented \
network:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124194308515234`*^9, 3.412419471159483*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"nfib", " ", "=", " ", 
    RowBox[{"cbar", " ", 
     RowBox[{
      SuperscriptBox["x", "2"], "/", 
      RowBox[{"(", 
       RowBox[{"\[Lambda]", " ", "\[Omega]"}], ")"}]}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "expected", " ", "number", " ", "of", " ", "fibres", " ", "in", " ", "an", 
    " ", "area", " ", 
    SuperscriptBox["x", "2"]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"npairs", " ", "=", " ", 
    RowBox[{
     SuperscriptBox["nfib", "2"], "/", 
     RowBox[{"(", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}], ")"}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "expected", " ", "number", " ", "of", " ", "fibre", " ", "pairs", " ", 
    "in", " ", "an", " ", "area", " ", 
    SuperscriptBox["x", "2"]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"ncrosspua", " ", "=", " ", 
  RowBox[{"Expand", "[", 
   RowBox[{"pcross", " ", "npairs"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4033357175844097`*^9, 3.403335851216563*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["cbar", "2"], 
   RowBox[{"\[Pi]", " ", 
    SuperscriptBox["\[Omega]", "2"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["cbar", "2"], " ", "\[Pi]", " ", 
    SuperscriptBox["\[Epsilon]c", "2"]}], 
   RowBox[{"6", " ", 
    SuperscriptBox["\[Omega]", "2"]}]]}]], "Output",
 CellChangeTimes->{3.403335901629053*^9}]
}, Open  ]],

Cell["\<\
The relative change in the number of crossings, as compared to a network with \
uniform orientation is:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124194965760307`*^9, 3.4124195203602304`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"pcross", "/", 
   RowBox[{"(", 
    RowBox[{"pcross", "/.", 
     RowBox[{"\[Epsilon]c", "\[Rule]", "0"}]}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4033365650029373`*^9, 3.403336594575461*^9}}],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[Pi]", "2"], " ", 
    SuperscriptBox["\[Epsilon]c", "2"]}], "6"]}]], "Output",
 CellChangeTimes->{3.403336748847293*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]c", ",", " ", "0", ",", " ", 
     RowBox[{"1", "/", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.40333663030684*^9, 3.403336640311226*^9}, {
  3.403337045333619*^9, 3.4033370822466974`*^9}, {3.4033371177076883`*^9, 
  3.403337146368901*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Hk0FNofAHDZWl5G9aIsZak0pYW06Ff6lgjj1TMzaDEt9jXLEKEesqRU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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.85},
  PlotRange->
   NCache[{{0, Pi^(-1)}, {0.8333333401360543, 0.9999999999999999}}, {{
     0, 0.3183098861837907}, {0.8333333401360543, 0.9999999999999999}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.403336640721816*^9, {3.4033370549774866`*^9, 3.4033371528181744`*^9}}]
}, Open  ]],

Cell["\<\
Finally, we obtain the expected number of crossings per fibre:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412419541250269*^9, 3.412419555881307*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"2", " ", "ncrosspua", " ", 
   RowBox[{
    SuperscriptBox["x", "2"], "/", "nfib"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4033368676781635`*^9, 3.403336926382576*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", "cbar", " ", "\[Lambda]"}], 
   RowBox[{"\[Pi]", " ", "\[Omega]"}]], "-", 
  FractionBox[
   RowBox[{"cbar", " ", "\[Pi]", " ", 
    SuperscriptBox["\[Epsilon]c", "2"], " ", "\[Lambda]"}], 
   RowBox[{"3", " ", "\[Omega]"}]]}]], "Output",
 CellChangeTimes->{3.4033373340587854`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.2.6 Crossing Area Distribution", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.4033417570487328`*^9, 3.4033417621761055`*^9}, {
  3.4124201865081043`*^9, 3.4124201878700624`*^9}}],

Cell["\<\
To determine the expected area of a crossing, we must determine the expected \
value of the random variable q = sin(\[Phi]). We obtain its probability \
density using a variable transform:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124196263726687`*^9, 3.4124196965435696`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"h\[Phi]", " ", "=", " ", 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{
       SuperscriptBox["\[Pi]", "2"], " ", 
       SuperscriptBox["\[Epsilon]c", "2"], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "\[Phi]"}], "]"}]}]}], ")"}], " ", 
    RowBox[{
     RowBox[{"Sin", "[", "\[Phi]", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"6", "-", 
         RowBox[{
          SuperscriptBox["\[Pi]", "2"], " ", 
          SuperscriptBox["\[Epsilon]c", "2"]}]}], ")"}]}], ")"}]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Phi]", " ", "=", " ", 
   RowBox[{"ArcSin", "[", "q", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pdfq", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{"FunctionExpand", "[", 
    RowBox[{"2", "h\[Phi]", " ", 
     RowBox[{"D", "[", 
      RowBox[{"\[Phi]", ",", "q"}], "]"}]}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"TrueQ", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{"pdfq", ",", " ", 
     RowBox[{"{", 
      RowBox[{"q", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}], "\[Equal]",
    "1"}], "]"}]}], "Input",
 CellChangeTimes->{{3.4033428874441614`*^9, 3.4033429222942734`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", "q", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{
      SuperscriptBox["\[Pi]", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["q", "2"]}]}], ")"}], " ", 
      SuperscriptBox["\[Epsilon]c", "2"]}]}], ")"}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["q", "2"]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "6"}], "+", 
     RowBox[{
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["\[Epsilon]c", "2"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.403342888195242*^9, 3.403342947560605*^9}, 
   3.4033434584952927`*^9, 3.403345445812915*^9, 3.4033461759127474`*^9, 
   3.4118099862816143`*^9}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.403342888195242*^9, 3.403342947560605*^9}, 
   3.4033434584952927`*^9, 3.403345445812915*^9, 3.4033461759127474`*^9, 
   3.4118099886349983`*^9}]
}, Open  ]],

Cell[TextData[{
 "and recover our expression for networks with uniform orientation when ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Epsilon]", "c"], TraditionalForm]]],
 "\[Rule] 0:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124197032532177`*^9, 3.412419733236331*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdfq", "/.", 
  RowBox[{"\[Epsilon]c", "\[Rule]", "0"}]}]], "Input",
 CellChangeTimes->{{3.403339777131752*^9, 3.4033397808771377`*^9}}],

Cell[BoxData[
 FractionBox["q", 
  SqrtBox[
   RowBox[{"1", "-", 
    SuperscriptBox["q", "2"]}]]]], "Output",
 CellChangeTimes->{3.4033432335818834`*^9, 3.403343462020362*^9, 
  3.403345449908805*^9, 3.40334617712449*^9, 3.411809988905387*^9}]
}, Open  ]],

Cell[TextData[{
 "We obtain the mean in the usual way, and check that we recover the result \
for networks with uniform orientation when ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Epsilon]", "c"], TraditionalForm]]],
 "\[Rule]0:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124197457142735`*^9, 3.4124197783311744`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"qbar", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"q", " ", "pdfq"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"q", ",", " ", "0", ",", "1"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"qbar", "/.", 
  RowBox[{"\[Epsilon]c", "\[Rule]", "0"}]}]}], "Input",
 CellChangeTimes->{{3.4033396571191826`*^9, 3.403339665341005*^9}, {
  3.4033400016646147`*^9, 3.403340071444954*^9}, {3.40334341672523*^9, 
  3.4033434451661263`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "8"], " ", "\[Pi]", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    FractionBox["2", 
     RowBox[{
      RowBox[{"-", "6"}], "+", 
      RowBox[{
       SuperscriptBox["\[Pi]", "2"], " ", 
       SuperscriptBox["\[Epsilon]c", "2"]}]}]]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.403343429313331*^9, 3.403343462761427*^9}, 
   3.403345450509669*^9, 3.4033461776953106`*^9, 3.411809989516266*^9}],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 CellChangeTimes->{{3.403343429313331*^9, 3.403343462761427*^9}, 
   3.403345450509669*^9, 3.4033461776953106`*^9, 3.4118099895362945`*^9}]
}, Open  ]],

Cell[TextData[{
 "The mean value, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["q", "_"], " ", "=", " ", 
    OverscriptBox[
     RowBox[{"sin", "(", "\[Phi]", ")"}], "_"]}], TraditionalForm]]],
 " decreases with increasing orientation:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124198070024014`*^9, 3.4124198440056095`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"qbar", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]c", ",", " ", "0", ",", " ", 
     RowBox[{"1", "/", "\[Pi]"}]}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(\[Epsilon]\), \(c\)]\)\>\"", ",", " ", 
      "\"\<\!\(\*OverscriptBox[\(Sin \((\[Phi])\)\), \(_\)]\)\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4033396571191826`*^9, 3.403339665341005*^9}, {
   3.4033400016646147`*^9, 3.403340071444954*^9}, 3.40334341672523*^9, {
   3.403343633156443*^9, 3.40334367343436*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Hk01G0bB/ChPVsLZdJCPSRSRFLSVUPZUkIbYx0Ryh4RUZiEsjdD0phQ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(\[Epsilon]\\), \\(c\\)]\\)\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*OverscriptBox[\\(Sin \\((\[Phi])\\)\\), \\(_\\)]\\)\"", 
     TraditionalForm]},
  AxesOrigin->{0, 0.71},
  PlotRange->
   NCache[{{0, Pi^(-1)}, {0.7068583509045516, 0.7853981633974484}}, {{
     0, 0.3183098861837907}, {0.7068583509045516, 0.7853981633974484}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.403343683388674*^9, 3.4033454509903603`*^9, 
  3.4033461777654114`*^9, 3.411809989626424*^9}]
}, Open  ]],

Cell["\<\
The variance and coefficient of variation show only a weak dependence on \
orientation:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124198520972447`*^9, 3.412419883402259*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"qvar", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"q", "-", "qbar"}], ")"}], "2"], "pdfq"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"q", ",", " ", "0", ",", "1"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"qvar", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]c", ",", " ", "0", ",", " ", 
     RowBox[{"1", "/", "\[Pi]"}]}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(\[Epsilon]\), \(c\)]\)\>\"", ",", " ", 
      "\"\<\!\(\*SuperscriptBox[\(\[Sigma]\), \(2\)]\)(q)\>\""}], "}"}]}]}], 
  "]"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    SqrtBox["qvar"], "/", "qbar"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]c", ",", " ", "0", ",", " ", 
     RowBox[{"1", "/", "\[Pi]"}]}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(\[Epsilon]\), \(c\)]\)\>\"", ",", " ", 
      "\"\<cv(q)\>\""}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.4033437924655185`*^9, 3.4033438328335648`*^9}, {
  3.4033439784729843`*^9, 3.4033440775254145`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["4", "3"]}], "+", 
     RowBox[{
      FractionBox["1", "320"], " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"30", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"128", "-", 
           RowBox[{"15", " ", 
            SuperscriptBox["\[Pi]", "2"]}]}], ")"}], " ", 
         SuperscriptBox["\[Epsilon]c", "2"]}], "-", 
        FractionBox["60", 
         RowBox[{
          RowBox[{"-", "6"}], "+", 
          RowBox[{
           SuperscriptBox["\[Pi]", "2"], " ", 
           SuperscriptBox["\[Epsilon]c", "2"]}]}]]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "6"}], "+", 
   RowBox[{
    SuperscriptBox["\[Pi]", "2"], " ", 
    SuperscriptBox["\[Epsilon]c", "2"]}]}]]], "Output",
 CellChangeTimes->{3.4033440942594767`*^9, 3.4033454586814194`*^9, 
  3.4033461856367297`*^9, 3.411809997808189*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Xk8FOgfB/BJiN1QopCK2jQouVbH4luTjCMlR5IpZCRRuRoROZvcR2bM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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(\[Epsilon]\\), \\(c\\)]\\)\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\(\[Sigma]\\), \\(2\\)]\\)(q)\"", 
     TraditionalForm]},
  AxesOrigin->{0, 0.05},
  PlotRange->
   NCache[{{0, Pi^(-1)}, {0.049816391598581755`, 0.06035127698098747}}, {{
     0, 0.3183098861837907}, {0.049816391598581755`, 0.06035127698098747}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4033440942594767`*^9, 3.4033454586814194`*^9, 
  3.4033461856367297`*^9, 3.411809997838232*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1mk4FFwbB3AtpN4YW9nyFDWlUtnSYrk1KVv1FCFMCJWJyJJdloSkZ6wN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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(\[Epsilon]\\), \\(c\\)]\\)\"", 
     TraditionalForm], 
    FormBox["\"cv(q)\"", TraditionalForm]},
  AxesOrigin->{0, 0.29},
  PlotRange->
   NCache[{{0, Pi^(-1)}, {0.28418179425314394`, 0.3475448350572779}}, {{
     0, 0.3183098861837907}, {0.28418179425314394`, 0.3475448350572779}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4033440942594767`*^9, 3.4033454586814194`*^9, 
  3.4033461856367297`*^9, 3.4118099979784336`*^9}]
}, Open  ]],

Cell["\<\
The probability density of crossing areas, in units of the mean fibre width \
squared is obtained by a variable transform:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412419910381053*^9, 3.4124199421066723`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"q", " ", "=", 
   RowBox[{"1", "/", "a"}]}], ";"}], "\n", 
 RowBox[{"pdfa", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"D", "[", 
       RowBox[{"q", ",", " ", "a"}], "]"}]}], " ", "pdfq"}], ",", " ", 
    RowBox[{"a", ">", "1"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.403340204476243*^9, {3.4033453164869537`*^9, 3.403345424472229*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        FractionBox["2", 
         SuperscriptBox["a", "2"]]}], ")"}], " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["\[Epsilon]c", "2"]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["a", "2"]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "6"}], "+", 
     RowBox[{
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["\[Epsilon]c", "2"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.403345415509341*^9, 3.40334542545364*^9}, 
   3.403345459051952*^9, 3.4033461858069744`*^9, 3.411809998208765*^9}]
}, Open  ]],

Cell["\<\
We observe that the influence of orientation is greatest for the largest \
crossing areas:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412419950218336*^9, 3.4124199894547553`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"pdfa", "/.", 
      RowBox[{"\[Epsilon]c", "\[Rule]", "0"}]}], ",", 
     RowBox[{"pdfa", "/.", 
      RowBox[{"\[Epsilon]c", "\[Rule]", "0.15"}]}], ",", 
     RowBox[{"pdfa", "/.", 
      RowBox[{"\[Epsilon]c", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"1", "/", "\[Pi]"}], ")"}]}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", " ", "1", ",", " ", "6"}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "Dashed", ",", "Dotted"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<a\>\"", ",", " ", "\"\<f(a)\>\""}], "}"}]}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.403340265343766*^9, 3.4033403004642673`*^9}, {
  3.403345562370517*^9, 3.403345668823589*^9}, {3.411809970649136*^9, 
  3.4118099711298275`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz3k01PsbB3CDMXYzBnMrhZtbWSJFSXg+GZUtiivFzxZZb1miYn63lCtL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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{Small, Small}], 
    LineBox[CompressedData["
1:eJwV0Xk4lHsbB3BLDLLMmGFeLZaSImuIt+O4fy85dAhpkWwJJUmWEFpEhCKR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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{0, Small}], 
    LineBox[CompressedData["
1:eJwV0Hk41PsXB3BjG1tmscwtiUpkCZVKcp1PaaGZX6K0cBtkStqIVKjoFknX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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"a\"", TraditionalForm], 
    FormBox["\"f(a)\"", TraditionalForm]},
  AxesOrigin->{0, -5.361192917694499},
  FrameTicks->{{{{0, 
       FormBox[
        TagBox[
         InterpretationBox["\"1.00\"", 1., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TagBox[
         InterpretationBox["\"0.50\"", 0.5, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TagBox[
         InterpretationBox["\"5.00\"", 5., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TagBox[
         InterpretationBox["\"0.10\"", 0.1, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TagBox[
         InterpretationBox["\"10.00\"", 10., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TagBox[
         InterpretationBox["\"0.05\"", 0.05, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TagBox[
         InterpretationBox["\"50.00\"", 50., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TagBox[
         InterpretationBox["\"0.01\"", 0.01, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.506557897319982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.6592600369327783`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.203972804325936, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.916290731874155, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5108256237659907, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.35667494393873245`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2231435513142097, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.10536051565782628`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{0, 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox["\" \"", TraditionalForm]}, {-3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.506557897319982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.6592600369327783`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.203972804325936, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.916290731874155, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5108256237659907, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.35667494393873245`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2231435513142097, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.10536051565782628`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, Automatic}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{0, 6}, {-5.361192917694499, 2.9531052169607754`}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, 
    Scaled[0.02]},
  Ticks->{Automatic, {{0, 
      FormBox[
       TagBox[
        InterpretationBox["\"1.00\"", 1., AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[-Log[2], -0.6931471805599453], 
      FormBox[
       TagBox[
        InterpretationBox["\"0.50\"", 0.5, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[
       Log[5], 1.6094379124341003`], 
      FormBox[
       TagBox[
        InterpretationBox["\"5.00\"", 5., AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[-Log[10], -2.302585092994046], 
      FormBox[
       TagBox[
        InterpretationBox["\"0.10\"", 0.1, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[
       Log[10], 2.302585092994046], 
      FormBox[
       TagBox[
        InterpretationBox["\"10.00\"", 10., AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[-Log[20], -2.995732273553991], 
      FormBox[
       TagBox[
        InterpretationBox["\"0.05\"", 0.05, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[
       Log[50], 3.912023005428146], 
      FormBox[
       TagBox[
        InterpretationBox["\"50.00\"", 50., AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[-Log[100], -4.605170185988092], 
      FormBox[
       TagBox[
        InterpretationBox["\"0.01\"", 0.01, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-3.912023005428146, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.506557897319982, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.2188758248682006`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.8134107167600364`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.6592600369327783`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.5257286443082556`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.4079456086518722`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.6094379124341003`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.203972804325936, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.916290731874155, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.5108256237659907, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.35667494393873245`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2231435513142097, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.10536051565782628`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6931471805599453, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.0986122886681098`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.3862943611198906`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.791759469228055, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.9459101490553132`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0794415416798357`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.1972245773362196`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.995732273553991, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.4011973816621555`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.6888794541139363`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output",
 CellChangeTimes->{{3.4033402785627747`*^9, 3.4033403012954626`*^9}, {
   3.4033455829400945`*^9, 3.4033456694945536`*^9}, 3.403345718394869*^9, 
   3.403346185927147*^9, 3.4118099984190674`*^9}]
}, Open  ]],

Cell["\<\
Accordingly, the mean crossing area increases with increasing orientation:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124200063089905`*^9, 3.4124200241746798`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"abar", " ", "=", " ", 
  RowBox[{"Expand", "[", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"a", " ", "pdfa"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"a", ",", " ", "1", ",", " ", "\[Infinity]"}], "}"}]}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"abar", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]c", ",", " ", "0", ",", " ", 
     RowBox[{"1", "/", "\[Pi]"}]}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(\[Epsilon]\), \(c\)]\)\>\"", ",", " ", 
      "\"\<\!\(\*OverscriptBox[\(a\), \(_\)]\)\>\""}], "}"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.4033461637752943`*^9, 3.403346163975582*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"3", " ", "\[Pi]"}], 
   RowBox[{
    RowBox[{"-", "6"}], "+", 
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["\[Epsilon]c", "2"]}]}]]}]], "Output",
 CellChangeTimes->{3.403346088687323*^9, 3.403346186578083*^9, 
  3.411809999100046*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Xk4FFwXAPChRGVpoUhvLxUpERF5xalJ1hZbEZNoRtYsY8v2ohgqZW+G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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(\[Epsilon]\\), \\(c\\)]\\)\"", 
     TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*OverscriptBox[\\(a\\), \\(_\\)]\\)\"", TraditionalForm]},
  AxesOrigin->{0, 1.6},
  PlotRange->
   NCache[{{0, Pi^(-1)}, {1.5707963267948966`, 1.8849555767664836`}}, {{
     0, 0.3183098861837907}, {1.5707963267948966`, 1.8849555767664836`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.403346088687323*^9, 3.403346186578083*^9, 
  3.411809999100046*^9}]
}, Open  ]],

Cell["\<\
The total area of crossings, as given by the product of the mean crossing \
area and the expected number of crossings per fibre, is independent of fibre \
orientation:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412420037563933*^9, 3.412420099132464*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ncpf", " ", "=", " ", 
   RowBox[{"2", " ", "cbar", " ", 
    RowBox[{"\[Lambda]", "/", 
     RowBox[{"(", 
      RowBox[{"\[Pi]", " ", "\[Omega]"}], ")"}]}], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       SuperscriptBox["\[Pi]", "2"], 
       RowBox[{
        SuperscriptBox["\[Epsilon]c", "2"], "/", "6"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"atotal", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{"ncpf", " ", "abar", " ", 
    SuperscriptBox["\[Omega]", "2"]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4033541029212255`*^9, 3.403354142087544*^9}, {
  3.403354205058091*^9, 3.4033542061797037`*^9}, {3.403354400539179*^9, 
  3.4033544028525057`*^9}, {3.4033549936119757`*^9, 3.403355000752243*^9}, {
  3.403355037074472*^9, 3.403355108146669*^9}}],

Cell[BoxData[
 RowBox[{"cbar", " ", "\[Lambda]", " ", "\[Omega]"}]], "Output",
 CellChangeTimes->{3.4033552122062993`*^9, 3.411809999260277*^9}]
}, Open  ]],

Cell["\<\
The mean inter-fibre crossing distance is only weakly influenced by fibre \
orientation:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412420139119963*^9, 3.4124201589985476`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gbar", " ", "=", " ", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"\[Lambda]", "/", "ncpf"}], "-", " ", 
    RowBox[{"\[Omega]", "/", "qbar"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4033568332171984`*^9, 3.4033568341986094`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[Pi]", " ", "\[Omega]"}], 
   RowBox[{"2", " ", "cbar", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[Pi]", "2"], " ", 
        SuperscriptBox["\[Epsilon]c", "2"]}], "6"]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"8", " ", "\[Omega]"}], 
   RowBox[{"3", " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["2", 
       RowBox[{
        RowBox[{"-", "6"}], "+", 
        RowBox[{
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["\[Epsilon]c", "2"]}]}]]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.403356835510496*^9, 3.4118099993103485`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.3 Fibre Clumping and Dispersion", "Section",
 Editable->False,
 CellChangeTimes->{{3.4124217589491634`*^9, 3.41242176017092*^9}}],

Cell[CellGroupData[{

Cell["Random Disk Model", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.4039607645719166`*^9, 3.4039607690683823`*^9}}],

Cell[TextData[{
 "Referring to Figure 6.1, we require the shaded area of the union of two \
disks separated by a distance ",
 StyleBox["r",
  FontSlant->"Italic"],
 "."
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124212972753086`*^9, 3.412421337413024*^9}, 
   3.4129350986200976`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Ashaded", " ", "=", " ", 
   RowBox[{
    SuperscriptBox["R", "2"], 
    RowBox[{"(", 
     RowBox[{"\[Theta]", "-", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", " ", "=", " ", 
   RowBox[{"2", 
    RowBox[{"ArcCos", "[", 
     RowBox[{"r", "/", 
      RowBox[{"(", 
       RowBox[{"2", "R"}], ")"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Ashaded", " ", "=", " ", 
  RowBox[{"TrigExpand", "[", 
   RowBox[{"Ashaded", "/.", 
    RowBox[{"R", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"Dd", "/", "2"}], ")"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.403543863640625*^9, 3.403544040484375*^9}, {
   3.403544112921875*^9, 3.403544116703125*^9}, {3.40354432190625*^9, 
   3.4035443224375*^9}, 3.4035451298125*^9, 3.4039393241120496`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", "Dd", " ", "r", " ", 
   SqrtBox[
    RowBox[{"1", "-", 
     FractionBox[
      SuperscriptBox["r", "2"], 
      SuperscriptBox["Dd", "2"]]}]]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["Dd", "2"], " ", 
   RowBox[{"ArcCos", "[", 
    FractionBox["r", "Dd"], "]"}]}]}]], "Output",
 CellChangeTimes->{3.403544334421875*^9, 3.403544369515625*^9, 
  3.403545143328125*^9, 3.403547281703125*^9, 3.403581906875*^9, 
  3.403582046703125*^9, 3.4039393263052034`*^9, 3.4039454890768337`*^9}]
}, Open  ]],

Cell["\<\
The autocorrelation function for a random structure of disks is:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124213462657537`*^9, 3.412421365883963*^9}, 
   3.4129351005128193`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Alpha]", "[", "r_", "]"}], ":=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Ashaded", "/", 
    RowBox[{"(", 
     RowBox[{"\[Pi]", " ", 
      RowBox[{
       SuperscriptBox["Dd", "2"], "/", "4"}]}], ")"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"\[Alpha]", "[", "r", "]"}]}], "Input",
 CellChangeTimes->{{3.403544079046875*^9, 3.40354409634375*^9}, {
   3.403544608*^9, 3.403544643953125*^9}, {3.403545233765625*^9, 
   3.40354528240625*^9}, 3.403939382475973*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "r", " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      FractionBox[
       SuperscriptBox["r", "2"], 
       SuperscriptBox["Dd", "2"]]}]]}], "+", 
   RowBox[{"2", " ", "Dd", " ", 
    RowBox[{"ArcCos", "[", 
     FractionBox["r", "Dd"], "]"}]}]}], 
  RowBox[{"Dd", " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{3.40354538575*^9, 3.403547281890625*^9, 3.4035819073125*^9,
   3.403582046859375*^9, 3.403939383837931*^9, 3.4039454892971506`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Alpha]", "[", "r", "]"}], "/.", 
    RowBox[{"Dd", "\[Rule]", "1"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"r", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<r/\!\(\*SubscriptBox[\(D\), \(d\)]\)\>\"", ",", " ", 
      "\"\<\[Alpha](r)\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.40354547440625*^9, 3.403545529390625*^9}, {
  3.4039394282618093`*^9, 3.403939430995741*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1nk8VPsbB/CxJmukNFxro0KTNeV2ncfWK1lC9hIqbboklx+6kT3Zs2VJ
19Jin2QtyjQmlLEnytjG2AYzsmbL74w/zuv7er+ez/O8nvPP+R75K3fOX+PE
YDBx6MM+Ta5NdRGnbRGXWsGF7W0WcBtKeg1jtSA31pizbZMFmv+lP63AGsFF
j0dimWssMG3re5ONtYG6iGOaWosssHdbfZ+EdYPVv5N9b06wYFD1oWEc1gfM
5zS4uigsyNlnERmNDYexctlreRksCOGrOPwImwL+zXecz2iywMExlzD/8zmk
WvHPedgyQWA7xOmMDAH6G91O+0TOgaIVc6oxphLyDoeqtNTNgl+7DqQvvYXZ
k+rXTUdmQKJSdIiDowGqMKWho3tnoJpmSOn4iwT42iU8Q5sBJPdsKcdZMrQs
mcm/cJ6G5UO6IqUezTDapn00PXUKONeK90gpfoGhIQPEo34StLddq63LKFCt
e8wuaWECKOFa7U3KHVCZj2vLwE+AbOLMWiGzE2RWDIs4HMdhZnV4qFetG0xk
27VbkunwnFH3RTi+B0KTUliODWMgLP2KRad/hYIIeo7xPA1ib1Vdz8F9g7tE
gugTNRqs6BXTbz7ogwMlQW52V0bBR4Ncub+xHwQ3rH/fzx+B4TJyTJf8D2gX
vzGsWzoMG+5fs5TuDUB8/JaBnOwQqOjv+n29jgqXHQxaighUOJMnf6NcYgiI
a5VmPYoD4CftojDqNAy8PWqu+e++w9FZW4E+8xForCLKiF7sh70i83zk9RGI
/GMDt0L7BtwNWYSDT0cBz4h4rPOoF25r1X3fbUoDyu1jaTEHvkLx2Ss5H1Zo
0FUxYs1f1Q3LM5J7JtLGYFBvyznyThdUWZ/hSjGiw/ZiyWDIvk54YBzxX+UE
HWoH7AS+v2kD+UGT/vyIcbjphl/vsGmFP0+Ep2A1JmAoSGjctacFnGQ61jh6
JsBHxTNlMbYJlr/E0bxCJgHHG1gidYQM6dzOPudxU1DPWCo8//sj7B2qyuMk
T0F/1ZEHGWMNwBMYYqNzdxoqpeNkn2XXAabQmUATY4BTlBKrlFID3pmEODES
A6gi/DW1gxXwXiWKT9RzBizH5BGSzmsQNfE+Gio8C7Xdcw5YiSKg4jt7Aupn
gejVVDpZlQ+vnwGO7jwHwSdmFl8+eQqXCNqi0r/nwHI++ZK9fDJUX/gl3Ilh
QsG7xatCG0kgzPtOMIyLib5voQf1axIQnXT5pvmYoNe30vspKgkU+I22K/cy
gcjhLdzy8zFMuFnNmSkxoVNRySCrJRE8Jf/+fN8GrXcE4KTF46DpE75Z1Z7d
r5l7oD0WZO+yyDRHJng19PqaRsVCZ7M30dgFzSvKz9hvxYCGb0CNuDuar1IO
EmVEw2pH5IuSB0zAeC6/0GqPguCI3BBqEZoXMH9LIoWDkN8uk8ulTMgpv3Bb
PyocMm96iE0QmPC6oTJ6xTwcKkx18lmVTBhpnWJx/wiDCdEuMmcDE9T4M+Jq
l0LB9BmGT6kH3d/3rQhBKwT217jE+24wQU6I6KT/8V/IL/hkt76F9s9lf6Jc
+BfUMlVkH2BYMHJ0//fepXtwNnCVEMWD+h0r46ryPbhvmNCVJcICTG/h6eAs
f6B1fBAnHUS/KxcTTl1K84XSKeksYTMWBLc3EWOn7oBl4ePAz+dYoNdRm9qo
egcWbvG4hluhdR+m92V/Tzg5M4tbt2MBMb16clDIA0hzdWXjl1kgtxYlpWri
Dt8WHEn1fuj8bqRcXuAa+Fe0Pfe7hxo7VGPh7gZSPvoPNQJZ4GoyKijdehVc
l4+YFYSi845TvF89vgKM1dXe5Dh0/40IBYymK2xvpk6756P787eYbaTZQ977
3RTFl+h+2pspB+PtwCgosGykAO0vM0s3emQL0dtu/9iVoQ4wGC6PsQZxTq0t
/bfo/uoeQS6RFlBNejW8WYfOk4gdlq01B8cwKVLNB7SeUO/Au2gKz7i5HuLJ
qIkbMkIRxnBkV/cebAeaH88UQ+QM4Evz6cWeLtQ3ksSccvXAI+ptb/xX1K9w
bscvIvBmd24m9w+032T4J6XrJNh8EQ9soKL1n0kcYerasBod5XJvGHVW+mht
kSb8JeiFm6ejxq+u8FDxMEQZ4y2eRB1JDbP1VYKQOPvpawzUTzMnpc0UAXeu
tVVuDrV8TJWKmzw0CUPZAAv1BZ4M9XApuNXxJjFtAbWz8S/9PnEQTDz0j9Uy
6n5saVOOEJRZZtoK/kIdL5MyuIsLrESFTzavo8Y45DjoLyHRPJxSVLYpEtbm
LYsIeW15a57tIxaT2paLiDZtsFFyA3Vnec78lQVEsqLUwpNtvp5nJ1PmEZqN
+Y196L2H8dI6dsqSgUid1TdRZvuAemNf0DRio3scD2wnmngXE6aQJkXpxZts
G5MH9xyYRIpXZoPq2Var1YjjpiM+6bFpV7dQE8Wbxl5QkdLY4AB/tr0cgvot
B5CJYB+nOLYTE9b0OX4gDrecFGrY1lPv7vTuQ3T/PFrG/5vd7zRZldWN/O+Y
3GPZHc8rK/h2Ia8VxH202B55iafbdCIKAps6zmwnmvdtWFAQXmrrp/Kd/Eus
nwEZgc6Ggqad/Gbf+lUS4k+uiBnYyVfUqqYSEUZJlhUP+h+ACT50aszqHXIw
N0FLcsdFZenYGsQpNUxClW25ZM8VnkqkPfD2oAPbeiF/GBWUILu8XYgeO3lt
2Q2fV4jedev8ULZHDPWKs/OQgAtnIp/s5HXo962fIm/OnbpVspPPlog9nYLM
GKiafWQbw9V92D4awZ04qPptx+OJn1/fR5xVJMRmdux1LsrKDXkiK7C8vWMM
rlw5Qff/TbVqwg==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"r/\\!\\(\\*SubscriptBox[\\(D\\), \\(d\\)]\\)\"", TraditionalForm], 
    FormBox["\"\[Alpha](r)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0, 1}, {0., 0.9999999740155195}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.403545549046875*^9, 3.40354728753125*^9, 
  3.4035819121875*^9, 3.403582052109375*^9, 3.403939439668211*^9, 
  3.4039454961169567`*^9}]
}, Open  ]],

Cell[TextData[{
 "We require the probability density function for the separation of pairs of \
points by a distance ",
 StyleBox["r",
  FontSlant->"Italic"],
 ". We derived this in Section 3.2.2:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124213863734255`*^9, 3.4124214279131565`*^9}, 
   3.4129351042982626`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "[", 
   RowBox[{"x_", ",", "r_"}], "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "r", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["x", "2"]}], " ", "-", " ", 
           RowBox[{"4", " ", "x", " ", "r"}], " ", "+", " ", 
           SuperscriptBox["r", "2"]}], ")"}], "/", 
         SuperscriptBox["x", "4"]}]}], ",", " ", 
       RowBox[{"0", "<", "r", "\[LessEqual]", " ", "x"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "r", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "x", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["r", "2"], "-", 
              SuperscriptBox["x", "2"]}]]}], "-", 
           SuperscriptBox["r", "2"], "-", 
           RowBox[{
            SuperscriptBox["x", "2"], 
            RowBox[{"(", 
             RowBox[{"2", "+", "\[Pi]", "-", 
              RowBox[{"4", 
               RowBox[{"ArcSin", "[", 
                RowBox[{"x", "/", "r"}], "]"}]}]}], ")"}]}]}], ")"}], "/", 
         SuperscriptBox["x", "4"]}]}], ",", 
       RowBox[{"x", "<", "r", "\[LessEqual]", 
        RowBox[{
         SqrtBox["2"], "x"}]}]}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4035462701875*^9, 3.403546270484375*^9}}],

Cell[TextData[{
 "The fractional between-zones variance is given by the integral of \
\[Alpha](",
 StyleBox["r",
  FontSlant->"Italic"],
 ") ",
 StyleBox["b",
  FontSlant->"Italic"],
 "(",
 StyleBox["r",
  FontSlant->"Italic"],
 ") which we perform numerically:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124214486129217`*^9, 3.4124214987650366`*^9}, {
  3.412935117627429*^9, 3.412935124767696*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Dd", "=", "1"}], ";", " ", 
  RowBox[{"x", "=", " ", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Alpha]", "[", "r", "]"}], " ", 
    RowBox[{"b", "[", 
     RowBox[{"x", ",", "r"}], "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"r", ",", " ", "0", ",", 
     RowBox[{
      SqrtBox["2"], "x"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.403939610784264*^9, 3.4039396427402143`*^9}, {
  3.4039397928059983`*^9, 3.4039398077074256`*^9}, {3.4039398417063136`*^9, 
  3.403939875945547*^9}}],

Cell[BoxData["0.6746176490817418`"], "Output",
 CellChangeTimes->{3.403940020122864*^9, 3.4039454965776196`*^9}]
}, Open  ]],

Cell[TextData[{
 "The fractional between-zones variance tends to 1 as ",
 StyleBox["x",
  FontSlant->"Italic"],
 " \[Rule] 0:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412421531401966*^9, 3.4124215529829984`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Dd", "=", "1"}], ";", " ", 
  RowBox[{"x", "=", " ", 
   SuperscriptBox["10", 
    RowBox[{"-", "10"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Alpha]", "[", "r", "]"}], " ", 
    RowBox[{"b", "[", 
     RowBox[{"x", ",", "r"}], "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"r", ",", " ", "0", ",", 
     RowBox[{
      SqrtBox["2"], "x"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", 
  RowBox[{"Dd", ",", "x"}], "]"}]}], "Input",
 CellChangeTimes->{{3.403939883446333*^9, 3.403939894321971*^9}}],

Cell[BoxData["0.9999999976615099`"], "Output",
 CellChangeTimes->{3.403940129650357*^9, 3.4039454966677485`*^9}]
}, Open  ]],

Cell[TextData[{
 "For x \[GreaterEqual] ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["D", "d"], "/", 
     SqrtBox["2"]}], ","}], TraditionalForm]]],
 ", the integral can be determined analytically:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124215653708115`*^9, 3.4124215951436224`*^9}, 
   3.4124216826694784`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Rho]xRange2", " ", "=", " ", 
  RowBox[{"Factor", "[", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"PiecewiseExpand", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Alpha]", "[", "r", "]"}], " ", 
        RowBox[{"b", "[", 
         RowBox[{"x", ",", "r"}], "]"}]}], ",", 
       RowBox[{"0", "<", "r", "<", "x"}]}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"r", ",", " ", "0", ",", " ", "Dd"}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.403547171203125*^9, 3.40354717453125*^9}, {
  3.403940417394112*^9, 3.4039404557793074`*^9}, {3.4039405122705374`*^9, 
  3.4039405827919426`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["Dd", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"45", " ", 
      SuperscriptBox["Dd", "2"], " ", "\[Pi]"}], "-", 
     RowBox[{"1024", " ", "Dd", " ", "x"}], "+", 
     RowBox[{"180", " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["x", "2"]}]}], ")"}]}], 
  RowBox[{"720", " ", "\[Pi]", " ", 
   SuperscriptBox["x", "4"]}]]], "Output",
 CellChangeTimes->{{3.403940587518739*^9, 3.4039406059752784`*^9}, 
   3.403945508665*^9}]
}, Open  ]],

Cell[TextData[{
 "We plot the fractional between-zones variance for disks of unit diameter. \
For x < ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["D", "d"], "/", 
    SqrtBox["2"]}], TraditionalForm]]],
 " we use numerical integration. The broken line represents the approximate \
result of Farnood ",
 StyleBox["et al.",
  FontSlant->"Italic"]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412421625877816*^9, 3.4124217125424337`*^9}, 
   3.4129351267104893`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Rho]xapprx", " ", "=", " ", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{".592", " ", 
          RowBox[{"x", "/", "Dd"}]}]}], ",", 
        RowBox[{"0", "\[LessEqual]", " ", "x", "\[LessEqual]", " ", 
         RowBox[{"0.843", " ", "Dd"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{".71", "-", 
           RowBox[{".298", " ", 
            RowBox[{"Dd", "/", "x"}]}]}], " ", ")"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"Dd", "/", "x"}], ")"}], "2"]}], ",", " ", 
        RowBox[{"x", ">", 
         RowBox[{"0.843", " ", "Dd"}]}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Dd", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{"\[Rho]xRange2", ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", 
       RowBox[{"1", "/", 
        SqrtBox["2"]}], ",", " ", "5"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{"\[Rho]xapprx", ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "5"}], "}"}], ",", " ", 
     RowBox[{"Exclusions", "\[Rule]", "None"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Prepend", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"NIntegrate", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Alpha]", "[", "r", "]"}], " ", 
              RowBox[{"b", "[", 
               RowBox[{"x", ",", "r"}], "]"}]}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"r", ",", " ", "0", ",", 
               RowBox[{
                SqrtBox["2"], "x"}]}], "}"}]}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"x", ",", " ", "0.05", ",", " ", ".7", ",", " ", ".05"}], 
          "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"AbsolutePointSize", "[", "5", "]"}]}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<x/\!\(\*SubscriptBox[\(D\), \(d\)]\)\>\"", ",", " ", 
      "\"\<\!\(\*SubscriptBox[\(\[Rho]\), \(x\)]\)\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Dd", "=."}]}], "Input",
 CellChangeTimes->{{3.403940697727211*^9, 3.4039408682524147`*^9}, {
  3.403942224122059*^9, 3.4039424974751215`*^9}, {3.4039450138434815`*^9, 
  3.403945032780712*^9}, {3.403945075371955*^9, 3.4039451198659344`*^9}, {
  3.403945345660611*^9, 3.4039453853677073`*^9}, {3.403945472432901*^9, 
  3.403945476689021*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx308E3gcwPElI3JrNtGiXpk8xetEvfLQ1feXHubh7CVyPd3ruJTqnIeX
urqa9OghzyZ2uYnRWIrRoTwdYVp5PuFUtC02akUelnkZ97s/Pq/P621+IsLv
lBaBQGDi/v/0voSse/lyCH5mxL7lJYXy5YD60w/l4OT0vEW5XwphtRbvt1bL
4Tx37W7mHimMOzRubWmXQ9DkgQSNsxRG1qvaFSo5HJqPaSRbSqF9KljL0UcB
X3KF7+lLErjPhYgWtQK8FYa2pY8kcHhW5THuNwGT66mwjiCBIZtWB3dQQmV9
2pCn+i1cz0xN0l74DLYVXi+y9rwG3+L0+YS+KXANfnLSvHsQIhh6IhPGNMQ2
cpNiw/uBd4PQ8Zo3Awtjun6Ci31wglCs5NPmoOup12whpxcCixzZ2YkqUGe2
mcBcN0Qo3KLqZF+B8rtmINanE0ihM6Hjh9WQ+dGNub/5JTTd3pLvWbkAouep
MppADGU9+4/26C2CvpyV5NjbBnbHyPaB0RrYcY15xF9PBHUxR13pA0vwqf7c
yERyCyinbcovWBEQkOnxZqbNcNfNRCdihIBGlVT7rP4m6Oned2lF4grkfzqz
Kj6uEZg6XmqTfVoobzhIdiu0AX5ITM0Wf9FCKbzIhcGCOuALS5CmdCVSOrkq
cyU1QJlwKW0N0UaqMFAmMJ+CXqSOsxWViGy8a2lmX6uB8cfDztVdRKS9LTg7
kVcFJFL69aRoHbS3mvPoenQlzHLkX3OtdVFCIeUx4dxfYN5ixNou1UXTQyLd
T2cew+DOG6anUlchjowUt/NmBfQHPBfTvPSQnleYLYdbDl9uxrj8rKWPRi26
xX1ZQshePi9yL9NH4ubb5f/YlsFNs72BgjOrUahPi7Wm5hGo43yNBcYGKDom
MaPs0kNIIfakuT0zQDWxNXNR/iVw1tLa+ODlb9DJt3GXL9o8gC52Q80KaxLq
tC4RLdMFwOLZ/bJDRkLSuRd5BrRiqND860zMWINCQmyJgw5FsNJ5MXjbRjK6
UNXUwTjCh97Gi05WLDKqblBv0bDuw8lJ9hp5LxmZWvYOWNQWQs4kbUbhYIhe
pdTTP8wUwDv1kPO2ZEP0hMZeF/JdAUyUuCZ5ywyRkZNqOCSHBxx74hgfKGg5
kL6aPJsP+gGRPp3ZFMRobEv/EJQPSfFGJruVFGQ5YqDDFuZBReJmxZQHFRm9
eyAcv3MP/tz+ShSZR0UpbIa7W04u2AonS5w0VGS5gRDUz+HCeKi9ZBc2O5zJ
eIJdZHN2rSe2mXnHt3exNxfIrgZiq4oDln7E3pTVfygZe9yRlzeazQVjVt3S
GPZmCe3jTBYXtBjxfneXqChwKpVPucOFZytb4+9je/DF7NlMLlxrIjQIseVl
jtcGsDWul63bsF/+nXE8B3vePmxxGntX220jOvZnin/R98tU5L7haJojmwul
3WlvDmMfm4y/SsX+NbmDHIytWSOPmMvgwgTxAOsS9vGdWw/WYI/Ou/gWYd9y
WFy7B7uw6rfYCmzTUL6uBfaJqMe19dhW01fU2tiSj3aWfdirpPXD4nQu5AnO
HBvBXudh0VOC/dMpftoENkn9tDkZ24wua53FTp65UhWO/WZk48Iyto1zlMAX
+z8sEGDx
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVx308E3gcwHGzkadidLqkNm6XPER6uLji+yu9VEeSZ3piGEmkmqucykPH
vF7O9CJascZwZJ6yOpHEiHk6cb2ELs1TRzZrLZzkfvfH5/V5vU3o0R6hqioq
Km64/593ja5uGxLnKGRnvl1ZkYGon+rqS/UHScasOntBBittjUlU6hnQzThs
TZXLIK8pnaJGvQIR6YR4JJFBpAPz3DyFBZS0GKMEkQz6l8Kz5ih3gJV0zFuV
JYNVwxKzWUopnIgld5L0ZcATc2NmKHVAOpH5SJMmhYpK1nCktRiatvknaVE/
QBj03flwoR98jEWaDo7TEDVhPlZb8RpcjVgaY6HvQcsk2eyt3ShUmRguXw+d
hN/0Oi14gWMgBecHbinjQB/2ekbsmoQ7YY5H1yZIIKY1mR5tNg18HvvskeRR
qD6v4/nt4VkosHM6aHf6DfDizk5v852D1dnZcvfS15DI/XLs0wc5vP8+0e1R
4StQ6R9FDVcVgBZtNl43HIDNlxiXvSyUYNJLizz3pA/GlTk+2k8/QzbpPG+v
sBd+moiIvxWzAGhB0zDXoQvcxtmWmzb9C9taJhcO+XTAdAv9RrtgCcrsaxY+
r7SBNfnVRqfTy5Bt41xr1y0CLVAGjSi+QupfYaYjxBY4OBswb+qtgmxFsh3u
Hs9hsDmEEGBFQBAv/WFX/TMQpopOUZUElKTSn030egoMNeZoT48qelGWpMMn
1kPwhTihDoeIrn5TPjZgWAc2YZY9rkEkhHIEmr+GPIZefSttpr0a6rjH3jrU
IIT6isS7VkR1JKzU3hLsVwtxBAv3rjfq6NSuDBvdpRrQGrl6KKp2FZIzJG1y
UTVMFJtkcX/RQIl1ldIbT6sga8t6Up23JvKcGuIwYiqBzWG8CKJqodzBwoca
tQIIyDrZozOlhSZdvBwtTcth4UDRIrdRGzmHRy3PsMtgbGL/5eYUHbQ3z9ho
fHcpFDjYbugOWo0GPd6RMv8uAcFNJjls6xqUE+2yJ7K2GFK8g12IyjXIa2Qm
6Am/CHaN8EpTunUREgcdkt7iQ675XUG3ix4SPyRM7CkqhOtN6bkudXrITpEb
elRYAEc2eBeJaWQkSOXprhriwb6oF8fJLDI6YN9nX2/EA64xndalJKMzI//E
pfrdB1pLyW234/oodsfu/H0nucDe2mzxslEf1VxK3t72XT4wFKS+DgsDNBXy
WSEduwf06o9UVoYB6maX62t33oV2sUZSwxcDJBtqkTqUcyDS6R27A3v/7YQq
Y2y9hrr8V9hcj/gLSw844CeIeDKHrdllPf8H9lRGl5y2bIDEVVeIO7HVvdmB
6dgX6yvMLMo44PR2neOprwYogZeZb/g7ByZ951zOYis814QrSziQ9me7/2Xs
nZ/abQewXz6/wryF3bo035qJTecPl7dhexk6yHWwb5zhbrBZMUCvP9I9icUc
oEl+Nt+LHfFjI1VSxIH2APfdh7F3MHylTdh6rgTPYOzV4U5p17C51sFpOdh6
JNXWRT4H9pfsyeVjF59wzRrEnqSsLa7GLsoaCH6MbU1ufd6JzbqfT2Riv2Tl
9Q5i218c7ffEjlWNfTOB/ck0kL8d2yjObeYjtnHlRiYZu1GxeXEF22jdeue5
Qg78B+UfUhY=
      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], AbsolutePointSize[5], 
     PointBox[{{0., 1.}, {0.05, 0.9668126838293791}, {0.1, 
      0.9336637283428478}, {0.15000000000000002`, 0.9005916797478866}, {0.2, 
      0.8676354724888322}, {0.25, 0.8348346350213529}, {0.30000000000000004`, 
      0.802229517394376}, {0.35000000000000003`, 0.7698615475927639}, {0.4, 
      0.737773528856042}, {0.45, 0.7060099950324348}, {0.5, 
      0.6746176490817418}, {0.55, 0.6436459238997417}, {0.6000000000000001, 
      0.6131477310511395}, {0.65, 0.5831805184690603}, {0.7000000000000001, 
      0.5538078968512002}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"x/\\!\\(\\*SubscriptBox[\\(D\\), \\(d\\)]\\)\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(\[Rho]\\), \\(x\\)]\\)\"", TraditionalForm]},
  AxesOrigin->{1., 0},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.403945425845912*^9, 3.4039455095863247`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.3.1 Influence on Network Parameters", "Subsection",
 Editable->False,
 CellChangeTimes->{{3.4039607794633293`*^9, 3.4039607929226832`*^9}, {
  3.4124217307686415`*^9, 3.4124217340834084`*^9}}],

Cell[CellGroupData[{

Cell["Negative Binomial Distribution", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.404031306616395*^9, 3.404031315399024*^9}}],

Cell["\<\
We model clumping using the negative binomial distribution for coverage at \
points, it has probability function:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412421814348824*^9, 3.4124218534450417`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NegativeBinomialDistribution", "[", 
    RowBox[{"n", ",", "p"}], "]"}], ",", " ", "c"}], "]"}]], "Input",
 CellChangeTimes->{3.4040238525379567`*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "p"}], ")"}], "c"], " ", 
  SuperscriptBox["p", "n"], " ", 
  RowBox[{"Binomial", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "+", "c", "+", "n"}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}]}], "]"}]}]], "Output",
 CellChangeTimes->{3.40402398000124*^9, 3.4040263087097583`*^9, 
  3.404028178007677*^9, 3.4040282728140016`*^9, 3.4040288015743217`*^9, 
  3.4040304686514606`*^9, 3.4040322901806912`*^9, 3.4040323428564353`*^9, 
  3.404039318937547*^9, 3.404040615391757*^9, 3.404043515351694*^9, 
  3.4040437482666097`*^9, 3.404043867137538*^9, 3.404044436015544*^9, 
  3.4040448803845153`*^9, 3.4040449551920834`*^9, 3.411399913*^9, 
  3.411400021328125*^9}]
}, Open  ]],

Cell[TextData[{
 "Applying ",
 StyleBox["FunctionExpand", "Input"],
 " to this probability function, yields a simplified form in terms of ",
 StyleBox["Gamma", "Input"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124218659129696`*^9, 3.412421894063448*^9}, 
   3.4129351349923983`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"NegativeBinomialDistribution", "[", 
     RowBox[{"n", ",", "p"}], "]"}], ",", " ", "c"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4040237313937597`*^9, 3.404023739585539*^9}, {
  3.4040262805092077`*^9, 3.40402628331324*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "p"}], ")"}], "c"], " ", 
   SuperscriptBox["p", "n"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"c", "+", "n"}], "]"}]}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "c"}], "]"}], " ", 
   RowBox[{"Gamma", "[", "n", "]"}]}]]], "Output",
 CellChangeTimes->{
  3.4040250015801983`*^9, {3.4040262859770703`*^9, 3.4040263098013277`*^9}, 
   3.404028179019131*^9, 3.404028273224592*^9, 3.40402880193484*^9, 
   3.4040304703739376`*^9, 3.4040322904610944`*^9, 3.4040323429465647`*^9, 
   3.4040393203996496`*^9, 3.4040406159425488`*^9, 3.404043517244416*^9, 
   3.4040437491879344`*^9, 3.4040438675080705`*^9, 3.404044436105674*^9, 
   3.40404488055476*^9, 3.404044956113408*^9, 3.411399913171875*^9, 
   3.41140002159375*^9}]
}, Open  ]],

Cell[TextData[{
 "The mean, variance and coefficient of variation are expressed in terms of \
parameters ",
 StyleBox["m",
  FontSlant->"Italic"],
 " and ",
 StyleBox["p",
  FontSlant->"Italic"],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412421904828928*^9, 3.412421921352688*^9}, 
   3.4129351402599726`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Mnb", " ", "=", " ", 
  RowBox[{"Mean", "[", 
   RowBox[{"NegativeBinomialDistribution", "[", 
    RowBox[{"n", ",", "p"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Vnb", " ", "=", " ", 
  RowBox[{"Variance", "[", 
   RowBox[{"NegativeBinomialDistribution", "[", 
    RowBox[{"n", ",", "p"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"CVnb", "  ", "=", " ", 
  RowBox[{"PowerExpand", "[", 
   RowBox[{
    SqrtBox["Vnb"], "/", "Mnb"}], "]"}]}]}], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"n", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "p"}], ")"}]}], "p"]], "Output",
 CellChangeTimes->{3.4040251301250367`*^9, 3.4040263099415293`*^9, 
  3.404028179189376*^9, 3.404028273294693*^9, 3.4040288020550127`*^9, 
  3.404030470604269*^9, 3.4040322905111666`*^9, 3.404032343006651*^9, 
  3.4040393206800528`*^9, 3.404040616002635*^9, 3.404043517424675*^9, 
  3.404043749248021*^9, 3.4040438675982*^9, 3.40404443616576*^9, 
  3.404044880614846*^9, 3.404044956203538*^9, 3.41139991321875*^9, 
  3.411400021640625*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"n", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "p"}], ")"}]}], 
  SuperscriptBox["p", "2"]]], "Output",
 CellChangeTimes->{3.4040251301250367`*^9, 3.4040263099415293`*^9, 
  3.404028179189376*^9, 3.404028273294693*^9, 3.4040288020550127`*^9, 
  3.404030470604269*^9, 3.4040322905111666`*^9, 3.404032343006651*^9, 
  3.4040393206800528`*^9, 3.404040616002635*^9, 3.404043517424675*^9, 
  3.404043749248021*^9, 3.4040438675982*^9, 3.40404443616576*^9, 
  3.404044880614846*^9, 3.404044956203538*^9, 3.41139991321875*^9, 
  3.411400021640625*^9}],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SqrtBox["n"], " ", 
   SqrtBox[
    RowBox[{"1", "-", "p"}]]}]]], "Output",
 CellChangeTimes->{3.4040251301250367`*^9, 3.4040263099415293`*^9, 
  3.404028179189376*^9, 3.404028273294693*^9, 3.4040288020550127`*^9, 
  3.404030470604269*^9, 3.4040322905111666`*^9, 3.404032343006651*^9, 
  3.4040393206800528`*^9, 3.404040616002635*^9, 3.404043517424675*^9, 
  3.404043749248021*^9, 3.4040438675982*^9, 3.40404443616576*^9, 
  3.404044880614846*^9, 3.404044956203538*^9, 3.41139991321875*^9, 
  3.411400021640625*^9}]
}, Open  ]],

Cell[TextData[{
 "We use these relationships to obtain ",
 StyleBox["n",
  FontSlant->"Italic"],
 " and ",
 StyleBox["p",
  FontSlant->"Italic"],
 " in terms of the mean coverage ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["c", "_"], TraditionalForm]]],
 " and the variance ratio ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "vr"], ":"}], TraditionalForm]]]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412421967869576*^9, 3.412422007085966*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"np", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"cbar", " ", "\[Equal]", "Mnb"}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"nvr", " ", "cbar"}], ")"}], " ", "\[Equal]", " ", "Vnb"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.404026057849038*^9, 3.4040260765058656`*^9}, {
  3.4040261135791745`*^9, 3.404026122732336*^9}, {3.404027169367323*^9, 
  3.4040271729524784`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"n", "\[Rule]", 
    FractionBox["cbar", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "nvr"}]]}], ",", 
   RowBox[{"p", "\[Rule]", 
    FractionBox["1", "nvr"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.404027394360848*^9, 3.404028179319563*^9, 
  3.4040282734649377`*^9, 3.4040288021952143`*^9, 3.4040304707945423`*^9, 
  3.4040322906713967`*^9, 3.404032343176896*^9, 3.4040393209504414`*^9, 
  3.4040406161628656`*^9, 3.4040435176049347`*^9, 3.4040437495885105`*^9, 
  3.4040438677784595`*^9, 3.4040444363360047`*^9, 3.404044880775077*^9, 
  3.4040449563437395`*^9, 3.41139991328125*^9, 3.4114000216875*^9}]
}, Open  ]],

Cell["\<\
We now define the negative binomial probability function in terms of these \
parameters:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124220201547585`*^9, 3.4124220410948687`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "[", 
   RowBox[{"nvr_", ",", "cbar_", ",", "c_"}], "]"}], " ", ":=", " ", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"FunctionExpand", "[", 
      RowBox[{
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"NegativeBinomialDistribution", "[", 
          RowBox[{"n", ",", "p"}], "]"}], ",", "c"}], "]"}], "/.", "np"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", " ", "\[Element]", " ", "Integers"}], ",", " ", 
       RowBox[{"c", "\[GreaterEqual]", "0"}]}], " ", "}"}]}], "]"}], 
   "]"}]}], "\n", 
 RowBox[{
  RowBox[{"P", "[", 
   RowBox[{"nvr", ",", "cbar", ",", "c"}], "]"}], " "}]}], "Input",
 CellChangeTimes->{{3.404026172834379*^9, 3.404026262132784*^9}, {
  3.404027239678426*^9, 3.4040272422621408`*^9}, {3.4040273413546286`*^9, 
  3.404027391707032*^9}, {3.4040281590404034`*^9, 3.4040281640075455`*^9}, {
  3.4040282527852015`*^9, 3.404028261207312*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", "nvr"], ")"}], 
    FractionBox["cbar", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "nvr"}]]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "nvr"}], "nvr"], ")"}], "c"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"c", "+", 
     FractionBox["cbar", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "nvr"}]]}], "]"}]}], 
  RowBox[{
   RowBox[{"c", "!"}], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox["cbar", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "nvr"}]], "]"}]}]]], "Output",
 CellChangeTimes->{3.4040273981362767`*^9, 3.4040281798803697`*^9, 
  3.404028274406291*^9, 3.4040288030664673`*^9, 3.4040304736085887`*^9, 
  3.404032291322333*^9, 3.4040323437677455`*^9, 3.4040393218216944`*^9, 
  3.404040616743701*^9, 3.404043518366029*^9, 3.404043750399677*^9, 
  3.404043868679755*^9, 3.4040444369068255`*^9, 3.4040448813258686`*^9, 
  3.404044959187829*^9, 3.4113999138125*^9, 3.41140002228125*^9}]
}, Open  ]],

Cell[TextData[{
 "Note that in the limit as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "vr"], " ", "\[Rule]", " ", "1"}], TraditionalForm]]],
 "we recover the Poisson probability function:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412422055245216*^9, 3.4124220812225695`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"P", "[", 
    RowBox[{"nvr", ",", "cbar", ",", "c"}], "]"}], ",", 
   RowBox[{"nvr", "\[Rule]", "1"}], ",", 
   RowBox[{"Direction", "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"cbar", ",", "c"}], "}"}], ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4040300235714674`*^9, 3.404030048016618*^9}, {
  3.4040301729963293`*^9, 3.404030194817707*^9}, {3.4040303244340863`*^9, 
  3.4040303402468243`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["cbar", "c"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "cbar"}]]}], 
  RowBox[{"c", "!"}]]], "Output",
 CellChangeTimes->{3.4040304766930237`*^9, 3.404032295378165*^9, 
  3.4040323462713456`*^9, 3.404039325076374*^9, 3.4040406194976606`*^9, 
  3.4040435218910975`*^9, 3.4040437547459264`*^9, 3.4040438725352993`*^9, 
  3.4040444392602096`*^9, 3.4040448836191664`*^9, 3.404044962041933*^9, 
  3.41139991659375*^9, 3.411400024859375*^9}]
}, Open  ]],

Cell[TextData[{
 "We plot the probability of coverage at points for a random (Poissonian) \
network and a clumpy (negative binomial) network, both with mean coverage ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["c", "_"], "=", " ", "10"}], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124220982370353`*^9, 3.4124221738958273`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"cbar", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"randomcoverage", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"PoissonDistribution", "[", "cbar", "]"}], ",", "c"}], 
        "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"c", ",", " ", "0", ",", " ", "30"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"clusteredcoverage", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"P", "[", 
        RowBox[{"2", ",", "cbar", ",", "c"}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"c", ",", " ", "0", ",", " ", "30"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"randomcoverage", ",", "clusteredcoverage"}], "}"}], ",", " ", 
     RowBox[{"Filling", "\[Rule]", "Axis"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"AbsolutePointSize", "[", "4", "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"randomcoverage", ",", "clusteredcoverage"}], "}"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "}"}], ",", "Dashed"}], "}"}]}]}], "]"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<c\>\"", ",", " ", "\"\<P(c)\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"cbar", "=."}]}], "Input",
 CellChangeTimes->{{3.4040279538854046`*^9, 3.4040279562387886`*^9}, {
  3.4040280111777873`*^9, 3.404028037846134*^9}, {3.4040283690624*^9, 
  3.4040286913057632`*^9}, {3.4040287691476946`*^9, 3.4040287884554577`*^9}, {
  3.411399896625*^9, 3.411399930015625*^9}}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJzt1e9LU1EYwPGxipQZiU4YtcLWWKbD1PljP68PCDWjKHoRDmTBMgyrpdWL
JH+VqbgaNAUL9kJtYVeDtDIVaTkKil4URT8wo9Ao1F7IQAIxkHbunh3Y8yfI
Duw5fHbvxmVfxtnlOn/slFwmk01GXmyPLX9D1dP6t5tLowqXvvAHNdMhG1oG
jqtjGR13XOgkKL3WVl+81oROhdN1y4qfzm60Eh1Aq0Df+Te5WjuCVoNwvLXP
vXUcnQnvcu7ZD358htbAg3OLCv+GEFpLrIMjNWLGpx1BdBb0VKSktZdNoLMh
Lfl+pWroMVoPtt4l8evgEDoXmqfKt/te9aPzwLlP7Soy9qDzQdnl8cm1HnQB
/GhrTPcpGtEGqGt+7V3scqML0U50ERxYXn1p2HkYXQyjig7dzctmdAm8WbBX
DWzcgzaCeHZe9OSmo02wZU7x7fvImhC1GSqck47n/nm0BaqtOTPTDR/QVuhe
aF9q+jeBtoFpMPB+2NyPFuDu3PUzf1baBVncOsp7R/dLvLc0W27w3lH7eW9p
qxjgvaXNPsx7S5v3Ce8dvX+M95a+LjjOe8dbK7nPO8Z7sxlqGeW92RTDj3hv
NvMqH/LebB4Ki7w3m7XLAd6bzRP6Xt6bzcCX27w3+w1WZ328N5ubHB7emz3e
7m2tvDd7vMXyK7x3ZIz8Ml3kvdmcmarhvSNj9vdJF+/NPh+UO9Bm5ludn2N9
LNL1lAv70Vbp+poY+3/amGsn3Aa0wLyiKdsb60lWmL4P8UwiTiVWEquI1cSZ
xBpiLbGOOIs4m1hPnEucR5xPXEBsIC4kLiIuJi4hNhKbiM3EFmIrsY1YIKYr
0Tve66934vxOnN+J83v9nd//AS/WsQE=
    "], {{{}, {}, {}, {}, {}, 
      {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{94, 1}], LineBox[{95, 2}], 
       LineBox[{96, 3}], LineBox[{97, 4}], LineBox[{98, 5}], LineBox[{99, 6}],
        LineBox[{100, 7}], LineBox[{101, 8}], LineBox[{102, 9}], 
       LineBox[{103, 10}], LineBox[{104, 11}], LineBox[{105, 12}], 
       LineBox[{106, 13}], LineBox[{107, 14}], LineBox[{108, 15}], 
       LineBox[{109, 16}], LineBox[{110, 17}], LineBox[{111, 18}], 
       LineBox[{112, 19}], LineBox[{113, 20}], LineBox[{114, 21}], 
       LineBox[{115, 22}], LineBox[{116, 23}], LineBox[{117, 24}], 
       LineBox[{118, 25}], LineBox[{119, 26}], LineBox[{120, 27}], 
       LineBox[{121, 28}], LineBox[{122, 29}], LineBox[{123, 30}], 
       LineBox[{124, 31}]}, {}, 
      {Hue[0.9060679774997897, 0.6, 0.6], Opacity[0.2], LineBox[{63, 32}], 
       LineBox[{64, 33}], LineBox[{65, 34}], LineBox[{66, 35}], 
       LineBox[{67, 36}], LineBox[{68, 37}], LineBox[{69, 38}], 
       LineBox[{70, 39}], LineBox[{71, 40}], LineBox[{72, 41}], 
       LineBox[{73, 42}], LineBox[{74, 43}], LineBox[{75, 44}], 
       LineBox[{76, 45}], LineBox[{77, 46}], LineBox[{78, 47}], 
       LineBox[{79, 48}], LineBox[{80, 49}], LineBox[{81, 50}], 
       LineBox[{82, 51}], LineBox[{83, 52}], LineBox[{84, 53}], 
       LineBox[{85, 54}], LineBox[{86, 55}], LineBox[{87, 56}], 
       LineBox[{88, 57}], LineBox[{89, 58}], LineBox[{90, 59}], 
       LineBox[{91, 60}], LineBox[{92, 61}], LineBox[{93, 62}]}}, {{}, 
      {Hue[0.67, 0.6, 0.6], AbsolutePointSize[4], 
       PointBox[{125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 
        137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
        151, 152, 153, 154, 155}]}, 
      {Hue[0.9060679774997897, 0.6, 0.6], AbsolutePointSize[4], 
       PointBox[{156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 
        168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 
        182, 183, 184, 185, 186}]}, {}}}], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{0., 0.000045399929762484854`}, {1., 0.00045399929762484856`}, {
      2., 0.0022699964881242427`}, {3., 0.007566654960414142}, {4., 
      0.018916637401035358`}, {5., 0.037833274802070715`}, {6., 
      0.06305545800345119}, {7., 0.09007922571921598}, {8., 
      0.11259903214901998`}, {9., 0.1251100357211333}, {10., 
      0.1251100357211333}, {11., 0.1137363961101212}, {12., 
      0.09478033009176765}, {13., 0.07290794622443666}, {14., 
      0.05207710444602618}, {15., 0.03471806963068413}, {16., 
      0.021698793519177577`}, {17., 0.012763996187751515`}, {18., 
      0.007091108993195287}, {19., 0.0037321626279975197`}, {20., 
      0.0018660813139987598`}, {21., 0.000888610149523219}, {22., 
      0.00040391370432873584`}, {23., 0.0001756146540559721}, {24., 
      0.00007317277252332172}, {25., 0.000029269109009328688`}, {26., 
      0.00001125734961897257}, {27., 4.169388747767619*^-6}, {28., 
      1.4890674099170067`*^-6}, {29., 5.134715206610368*^-7}, {30., 
      1.7115717355367894`*^-7}}]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{Small, Small}], 
     LineBox[{{0., 0.0009765625}, {1., 0.0048828125}, {2., 0.013427734375}, {
      3., 0.02685546875}, {4., 0.04364013671875}, {5., 0.06109619140625}, {6.,
       0.0763702392578125}, {7., 0.0872802734375}, {8., 
      0.09273529052734375}, {9., 0.09273529052734375}, {10., 
      0.08809852600097656}, {11., 0.08008956909179688}, {12., 
      0.07007837295532227}, {13., 0.05929708480834961}, {14., 
      0.048708319664001465`}, {15., 0.03896665573120117}, {16., 
      0.030442699790000916`}, {17., 0.023279711604118347`}, {18., 
      0.01745978370308876}, {19., 0.012865103781223297`}, {20., 
      0.00932720024138689}, {21., 0.006662285886704922}, {22., 
      0.004693883238360286}, {23., 0.0032653100788593292`}, {24., 
      0.002244900679215789}, {25., 0.0015265324618667364`}, {26., 
      0.0010274737724103034`}, {27., 0.0006849825149402022}, {28., 
      0.00045257773308549076`}, {29., 0.0002965164458146319}, {30., 
      0.00019273568977951072`}}]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"c\"", TraditionalForm], 
    FormBox["\"P(c)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0., 30.}, {0., 0.1251100357211333}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.4040287806742687`*^9, 3.404028803306813*^9}, 
   3.4040304773139167`*^9, 3.404032295628525*^9, 3.404032346471634*^9, 
   3.404039325647195*^9, 3.404040620058467*^9, 3.404043522802408*^9, 
   3.4040437555270495`*^9, 3.404043872825717*^9, 3.404044439470512*^9, 
   3.4040448838394833`*^9, 3.404044962282278*^9, {3.411399916828125*^9, 
   3.411399931203125*^9}, 3.4114000250625*^9}]
}, Open  ]],

Cell[TextData[{
 "The skewness of the distribution increases with increasing variance ratio, \
",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "vr"], TraditionalForm]]],
 " and decreases with increasing mean coverage:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124222022666225`*^9, 3.41242222984628*^9}, 
   3.412935146829419*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"sk", " ", "=", " ", 
  RowBox[{"PowerExpand", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Skewness", "[", 
     RowBox[{
      RowBox[{"NegativeBinomialDistribution", "[", 
       RowBox[{"n", ",", "p"}], "]"}], "/.", "np"}], "]"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{"sk", ",", " ", 
   RowBox[{"{", 
    RowBox[{"nvr", ",", " ", "1", ",", " ", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"cbar", ",", "1", ",", "10"}], "}"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(n\), \(vr\)]\)\>\"", ",", 
      "\"\<\!\(\*OverscriptBox[\(c\), \(_\)]\)\>\"", ",", " ", "\"\<Sk\>\""}],
      "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.3890081637673535`*^9, 3.389008168904741*^9}, {
  3.404027579396917*^9, 3.4040275890808415`*^9}, {3.404030625667238*^9, 
  3.4040307118611794`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"2", " ", "nvr"}]}], 
  RowBox[{
   SqrtBox["cbar"], " ", 
   SqrtBox["nvr"]}]]], "Output",
 CellChangeTimes->{3.4040310321116767`*^9, 3.40403229570864*^9, 
  3.4040323465517488`*^9, 3.4040393257473392`*^9, 3.4040406201586113`*^9, 
  3.404043522872509*^9, 3.4040437555971503`*^9, 3.4040438729058323`*^9, 
  3.404044439550627*^9, 3.404044883909584*^9, 3.404044962372408*^9, 
  3.411399916921875*^9, 3.411400025125*^9}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nXlYTd/3+G91m+eJSlK55iIioZyT+ZoiFKLMSpN5eJtVqAgZQ6OSeQhF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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmnf8V9Mfx++5597slBYatDeljBSVShqohBClPZAQShmREomMUlp2UfYK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         "]], Polygon3DBox[CompressedData["
1:eJw1mmPAJFfXRatv3Y5tJxPrje0JJ7bNiW3btjGxbdu2bdvJt1Z2fT/qeWr1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         "]], Polygon3DBox[CompressedData["
1:eJwt13W8VVUWAOD7LveChSICdhDqiKggiIKIjYJgECol0t08pUFKGqUbJaWR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         "]]}]}, {}, {}, {}}, {
     Line3DBox[{298, 1, 281, 227, 772, 16, 780, 31, 791, 46, 806, 61, 821, 76,
       836, 91, 852, 853, 106, 881, 121, 896, 136, 911, 151, 926, 166, 941, 
      181, 956, 196, 1088, 242, 300, 211, 296, 253, 505, 212, 506, 213, 507, 
      214, 508, 215, 509, 216, 510, 217, 511, 512, 218, 513, 219, 514, 220, 
      515, 221, 516, 222, 517, 223, 518, 224, 738, 244, 301, 225, 297, 254, 
      983, 210, 969, 195, 954, 180, 939, 165, 924, 150, 909, 135, 894, 120, 
      879, 878, 105, 849, 90, 834, 75, 819, 60, 804, 45, 789, 30, 1085, 239, 
      299, 15, 295, 251, 324, 14, 292, 323, 13, 289, 322, 12, 287, 321, 11, 
      768, 285, 10, 767, 282, 9, 317, 8, 314, 313, 7, 311, 6, 309, 5, 307, 4, 
      305, 3, 303, 2, 739, 245, 298}], {
      Line3DBox[{772, 1081, 1122, 1448, 771, 1235, 984, 773, 1236, 985, 774, 
       1237, 986, 775, 1238, 987, 776, 1239, 988, 777, 1240, 1123, 1339, 778, 
       1118, 1241, 989, 1119, 1120, 1121, 1090, 1233, 1449, 990, 1096, 1109, 
       1110, 1091, 1453, 1105, 991, 1097, 1111, 1112, 1242, 1092, 1106, 992, 
       1098, 1113, 1454, 1234, 1093, 1107, 993, 1099, 1114, 1455, 1115, 1094, 
       1108, 994, 1100, 1450, 1116, 1117, 1095, 995, 1085}], 
      Line3DBox[{780, 1124, 1340, 779, 1243, 996, 781, 1244, 997, 782, 1245, 
       998, 783, 1246, 999, 784, 1247, 1000, 785, 1248, 1125, 1341, 786, 1126,
        1342, 787, 1082, 1249, 1001, 788, 1083, 1250, 1002, 1101, 1229, 1251, 
       1003, 1102, 1230, 1252, 1004, 1103, 1451, 1084, 1005, 1104, 1452, 1086,
        1006, 789}], 
      Line3DBox[{791, 1127, 1343, 790, 1128, 1344, 792, 1253, 1007, 793, 1254,
        1008, 794, 1255, 1009, 795, 1256, 1010, 796, 1257, 1129, 1345, 797, 
       1130, 1346, 798, 1131, 1347, 799, 1258, 1011, 800, 1259, 1012, 801, 
       1260, 1013, 802, 1261, 1014, 803, 1262, 1015, 804}], 
      Line3DBox[{806, 1132, 1348, 805, 1133, 1349, 807, 1134, 1350, 808, 557, 
       809, 1263, 1016, 810, 1264, 1017, 811, 1265, 1135, 1351, 812, 1136, 
       1352, 813, 1137, 1353, 814, 1138, 1354, 815, 1266, 1018, 816, 1267, 
       1019, 817, 1268, 1020, 818, 1269, 1021, 819}], 
      Line3DBox[{821, 1139, 1355, 820, 1140, 1356, 822, 1141, 1357, 823, 1142,
        1358, 824, 1270, 1022, 825, 1271, 1023, 826, 1272, 1143, 1359, 827, 
       1144, 1360, 828, 1145, 1361, 829, 1146, 1362, 830, 1147, 1363, 831, 
       1273, 1024, 832, 1274, 1025, 833, 1275, 1026, 834}], 
      Line3DBox[{836, 1148, 1364, 835, 1149, 1365, 837, 1150, 1366, 838, 1151,
        1367, 839, 1152, 1368, 840, 1276, 1027, 841, 1277, 1153, 1369, 842, 
       1154, 1370, 843, 1155, 1371, 844, 1156, 1372, 845, 1157, 1373, 846, 
       1158, 1374, 847, 1278, 1028, 848, 1279, 1029, 849}], 
      Line3DBox[{853, 1280, 1030, 851, 1281, 1031, 855, 1282, 1032, 857, 1283,
        1033, 859, 1284, 1034, 861, 1285, 1035, 863, 1287, 606, 865, 1288, 
       1036, 867, 1289, 1037, 869, 1290, 1038, 871, 1291, 1039, 873, 1292, 
       1040, 875, 1293, 1041, 877, 1295, 1043, 879}], 
      Line3DBox[{878, 1042, 1294, 876, 1387, 1171, 874, 1386, 1170, 872, 1385,
        1169, 870, 1384, 1168, 868, 1383, 1167, 866, 1382, 1166, 864, 1381, 
       1165, 1286, 862, 1380, 1164, 860, 1379, 1163, 858, 1378, 1162, 856, 
       1377, 1161, 854, 1376, 1160, 850, 1375, 1159, 852}], 
      Line3DBox[{881, 1172, 1388, 880, 1296, 1044, 882, 1297, 1045, 883, 1298,
        1046, 884, 1299, 1047, 885, 1300, 1048, 886, 1301, 1173, 1389, 887, 
       1302, 1049, 888, 1303, 1050, 889, 1304, 1051, 890, 1305, 1052, 891, 
       1306, 1053, 892, 1307, 1054, 893, 1308, 1055, 894}], 
      Line3DBox[{896, 1174, 1390, 895, 1175, 1391, 897, 1309, 1056, 898, 1310,
        1057, 899, 1311, 1058, 900, 1312, 1059, 901, 1313, 1176, 1392, 902, 
       1177, 1393, 903, 638, 904, 1314, 1060, 905, 1315, 1061, 906, 1316, 
       1062, 907, 1317, 1063, 908, 1318, 1064, 909}], 
      Line3DBox[{911, 1178, 1394, 910, 1179, 1395, 912, 1180, 1396, 913, 1319,
        1065, 914, 1320, 1066, 915, 1321, 1067, 916, 1322, 1181, 1397, 917, 
       1182, 1398, 918, 1183, 1399, 919, 654, 920, 1323, 1068, 921, 1324, 
       1069, 922, 1325, 1070, 923, 1326, 1071, 924}], 
      Line3DBox[{926, 1184, 1400, 925, 1185, 1401, 927, 1186, 1402, 928, 1187,
        1403, 929, 1327, 1072, 930, 1328, 1073, 931, 1329, 1188, 1404, 932, 
       1189, 1405, 933, 1190, 1406, 934, 1191, 1407, 935, 1192, 1408, 936, 
       1330, 1074, 937, 1331, 1075, 938, 1332, 1076, 939}], 
      Line3DBox[{941, 1193, 1409, 940, 1194, 1410, 942, 1195, 1411, 943, 1196,
        1412, 944, 1197, 1413, 945, 1333, 1077, 946, 1334, 1198, 1414, 947, 
       1199, 1415, 948, 1200, 1416, 949, 1201, 1417, 950, 1202, 1418, 951, 
       1203, 1419, 952, 1335, 1078, 953, 1336, 1079, 954}], 
      Line3DBox[{956, 1204, 1420, 955, 1205, 1421, 957, 1206, 1422, 958, 1207,
        1423, 959, 1208, 1424, 960, 1209, 1425, 961, 1337, 1210, 1426, 962, 
       1211, 1427, 963, 1212, 1428, 964, 1213, 1429, 965, 1214, 1430, 966, 
       1215, 1431, 967, 1216, 1432, 968, 1338, 1080, 969}], 
      Line3DBox[{983, 1089, 1447, 1232, 982, 1446, 1228, 981, 1445, 1227, 980,
        1444, 1226, 979, 1443, 1225, 978, 1442, 1224, 977, 1441, 1223, 976, 
       1440, 1439, 1222, 975, 1438, 1221, 974, 1437, 1220, 973, 1436, 1219, 
       972, 1435, 1218, 971, 1434, 1217, 970, 1231, 1433, 1087, 1088}]}, {
      Line3DBox[{303, 520, 1235, 304, 529, 1243, 326, 1344, 540, 341, 1349, 
       555, 356, 1356, 570, 371, 1365, 585, 386, 1376, 600, 1281, 401, 615, 
       1296, 416, 1391, 630, 431, 1395, 645, 446, 1401, 660, 461, 1410, 675, 
       476, 1421, 690, 491, 1434, 705, 506}], 
      Line3DBox[{305, 521, 1236, 306, 530, 1244, 327, 541, 1253, 342, 1350, 
       556, 357, 1357, 571, 372, 1366, 586, 387, 1377, 601, 1282, 402, 616, 
       1297, 417, 631, 1309, 432, 1396, 646, 447, 1402, 661, 462, 1411, 676, 
       477, 1422, 691, 492, 1435, 706, 507}], 
      Line3DBox[{307, 522, 1237, 308, 531, 1245, 328, 542, 1254, 343, 557, 
       358, 1358, 572, 373, 1367, 587, 388, 1378, 602, 1283, 403, 617, 1298, 
       418, 632, 1310, 433, 647, 1319, 448, 1403, 662, 463, 1412, 677, 478, 
       1423, 692, 493, 1436, 707, 508}], 
      Line3DBox[{309, 523, 1238, 310, 532, 1246, 329, 543, 1255, 344, 558, 
       1263, 359, 573, 1270, 374, 1368, 588, 389, 1379, 603, 1284, 404, 618, 
       1299, 419, 633, 1311, 434, 648, 1320, 449, 663, 1327, 464, 1413, 678, 
       479, 1424, 693, 494, 1437, 708, 509}], 
      Line3DBox[{311, 524, 1239, 312, 533, 1247, 330, 544, 1256, 345, 559, 
       1264, 360, 574, 1271, 375, 589, 1276, 390, 1380, 604, 1285, 405, 619, 
       1300, 420, 634, 1312, 435, 649, 1321, 450, 664, 1328, 465, 679, 1333, 
       480, 1425, 694, 495, 1438, 709, 510}], 
      Line3DBox[{313, 525, 1240, 315, 534, 1248, 331, 545, 1257, 346, 560, 
       1265, 361, 575, 1272, 376, 590, 1277, 391, 605, 1286, 1287, 406, 620, 
       1301, 421, 635, 1313, 436, 650, 1322, 451, 665, 1329, 466, 680, 1334, 
       481, 695, 1337, 496, 1439, 710, 511}], 
      Line3DBox[{317, 765, 766, 527, 1241, 318, 1342, 536, 333, 1346, 547, 
       348, 1352, 562, 363, 1360, 577, 378, 1370, 592, 393, 1382, 607, 1288, 
       408, 622, 1302, 423, 1393, 637, 438, 1398, 652, 453, 1405, 667, 468, 
       1415, 682, 483, 1427, 697, 498, 1441, 712, 513}], 
      Line3DBox[{321, 769, 723, 746, 724, 1242, 759, 740, 725, 751, 726, 1251,
        336, 550, 1259, 351, 565, 1266, 366, 1363, 580, 381, 1373, 595, 396, 
       1385, 610, 1291, 411, 625, 1305, 426, 640, 1315, 441, 655, 1323, 456, 
       1408, 670, 471, 1418, 685, 486, 1430, 700, 501, 1444, 715, 516}], 
      Line3DBox[{322, 770, 727, 747, 728, 760, 1454, 741, 729, 752, 730, 1252,
        337, 551, 1260, 352, 566, 1267, 367, 581, 1273, 382, 1374, 596, 397, 
       1386, 611, 1292, 412, 626, 1306, 427, 641, 1316, 442, 656, 1324, 457, 
       671, 1330, 472, 1419, 686, 487, 1431, 701, 502, 1445, 716, 517}], 
      Line3DBox[{323, 293, 748, 272, 1455, 742, 731, 753, 1451, 732, 338, 552,
        1261, 353, 567, 1268, 368, 582, 1274, 383, 597, 1278, 398, 1387, 612, 
       1293, 413, 627, 1307, 428, 642, 1317, 443, 657, 1325, 458, 672, 1331, 
       473, 687, 1335, 488, 1432, 702, 503, 1446, 717, 518}], 
      Line3DBox[{324, 761, 762, 749, 764, 1450, 763, 743, 733, 754, 1452, 734,
        339, 553, 1262, 354, 568, 1269, 369, 583, 1275, 384, 598, 1279, 399, 
       613, 1294, 1295, 414, 628, 1308, 429, 643, 1318, 444, 658, 1326, 459, 
       673, 1332, 474, 688, 1336, 489, 703, 1338, 504, 1447, 736, 737, 738}], 
      Line3DBox[{505, 704, 735, 1433, 490, 689, 1420, 475, 674, 1409, 460, 
       659, 1400, 445, 644, 1394, 430, 629, 1390, 415, 614, 1388, 400, 1280, 
       599, 1375, 385, 584, 1364, 370, 569, 1355, 355, 554, 1348, 340, 539, 
       1343, 325, 528, 1340, 302, 519, 1448, 718, 739}], 
      Line3DBox[{512, 711, 1440, 497, 696, 1426, 482, 681, 1414, 467, 666, 
       1404, 452, 651, 1397, 437, 636, 1392, 422, 621, 1389, 407, 606, 1381, 
       392, 591, 1369, 377, 576, 1359, 362, 561, 1351, 347, 546, 1345, 332, 
       535, 1341, 316, 526, 1339, 314}], 
      Line3DBox[{514, 713, 1442, 499, 698, 1428, 484, 683, 1416, 469, 668, 
       1406, 454, 653, 1399, 439, 638, 424, 1303, 623, 409, 1289, 608, 1383, 
       394, 593, 1371, 379, 578, 1361, 364, 563, 1353, 349, 548, 1347, 334, 
       1249, 537, 720, 319, 1449, 756, 755, 744, 719, 767}], 
      Line3DBox[{515, 714, 1443, 500, 699, 1429, 485, 684, 1417, 470, 669, 
       1407, 455, 654, 440, 1314, 639, 425, 1304, 624, 410, 1290, 609, 1384, 
       395, 594, 1372, 380, 579, 1362, 365, 564, 1354, 350, 1258, 549, 335, 
       1250, 538, 750, 722, 320, 758, 1453, 757, 745, 721, 768}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJx0unk0lW/0No5ShkimTCUpiSZDUtEmDQqhMiSzTJlKxlLJUESilEiFyDyT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    "]],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(n\\), \\(vr\\)]\\)\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*OverscriptBox[\\(c\\), \\(_\\)]\\)\"", TraditionalForm], 
    FormBox["\"Sk\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{1, 5}, {1, 10}, {0.31622791170747605`, 4.024920925222399}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4040310321116767`*^9, 3.40403229570864*^9, 
  3.4040323465517488`*^9, 3.4040393257473392`*^9, 3.4040406201586113`*^9, 
  3.404043522872509*^9, 3.4040437555971503`*^9, 3.4040438729058323`*^9, 
  3.404044439550627*^9, 3.404044883909584*^9, 3.404044962372408*^9, 
  3.411399916921875*^9, 3.411400025265625*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pinholes", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.404031289461728*^9, 3.404031290883773*^9}}],

Cell["\<\
The probability of a pinhole is the probability of coverage zero:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412422257235664*^9, 3.412422270574845*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProbPinhole", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"P", "[", 
     RowBox[{"nvr", ",", "cbar", ",", "0"}], "]"}], ",", " ", 
    RowBox[{"nvr", ">", "1"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.3890082074101086`*^9, 3.3890082078307133`*^9}, {
  3.3890765289216175`*^9, 3.389076535240704*^9}, {3.4040313354178095`*^9, 
  3.4040313500889053`*^9}, {3.404032241440606*^9, 3.404032241771082*^9}}],

Cell[BoxData[
 SuperscriptBox["nvr", 
  RowBox[{"-", 
   FractionBox["cbar", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "nvr"}]]}]]], "Output",
 CellChangeTimes->{3.38900820939296*^9, 3.389076535661309*^9, 
  3.4040313516311235`*^9, 3.4040322648142157`*^9, 3.404032295999058*^9, 
  3.404032346832152*^9, 3.4040393264283185`*^9, 3.4040406207694893`*^9, 
  3.4040435237337475`*^9, 3.404043756037784*^9, 3.404043873206264*^9, 
  3.4040448842500734`*^9, 3.4040449626828547`*^9}]
}, Open  ]],

Cell[TextData[{
 "We recover the result for a random network in the limit as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", 
     RowBox[{"vr", " "}]], "\[Rule]", " ", "1"}], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124222764332685`*^9, 3.412422297894128*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"ProbPinhole", ",", 
   RowBox[{"nvr", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4040313731921263`*^9, 3.4040313792508383`*^9}}],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", "cbar"}]]], "Output",
 CellChangeTimes->{3.404031381013373*^9, 3.404032265244835*^9, 
  3.404032296079173*^9, 3.4040323469222813`*^9, 3.4040393265284624`*^9, 
  3.404040620859619*^9, 3.4040435238138623`*^9, 3.404043756107885*^9, 
  3.4040438732963934`*^9, 3.404044884320174*^9, 3.4040449627629695`*^9}]
}, Open  ]],

Cell["\<\
The probability of pinholes increases with increasing variance ratio and \
decreases with increasing mean coverage:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124224421115026`*^9, 3.4124224791948256`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ProbPinhole", "/.", 
      RowBox[{"cbar", "\[Rule]", "5"}]}], ",", 
     RowBox[{"ProbPinhole", "/.", 
      RowBox[{"cbar", "\[Rule]", "10"}]}], ",", 
     RowBox[{"ProbPinhole", "/.", 
      RowBox[{"cbar", "\[Rule]", "15"}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"nvr", ",", " ", "1", ",", " ", "4"}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", 
      RowBox[{"{", "}"}], ",", "Dotted"}], "}"}]}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(n\), \(vr\)]\)\>\"", ",", "\"\<P(0)\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.383045544646302*^9, 3.38304560427204*^9}, {
  3.3830456364883647`*^9, 3.383045640494125*^9}, {3.3830457997931857`*^9, 
  3.383045805751754*^9}, {3.383045847321528*^9, 3.383045945883253*^9}, {
  3.3830459915589314`*^9, 3.3830460624508686`*^9}, {3.3830461009462223`*^9, 
  3.38304610332965*^9}, {3.3830462456342735`*^9, 3.383046276859173*^9}, {
  3.3830474119813986`*^9, 3.383047420533696*^9}, {3.383047520227048*^9, 
  3.3830475928514767`*^9}, {3.3830477586398687`*^9, 3.383047759070488*^9}, {
  3.3830478229223022`*^9, 3.383047823513152*^9}, {3.383048655779893*^9, 
  3.3830486895083923`*^9}, {3.3842519024256353`*^9, 3.3842519164257665`*^9}, {
  3.38425211665368*^9, 3.3842521442032948`*^9}, {3.3890082407380323`*^9, 
  3.389008258663808*^9}, {3.4040314209908576`*^9, 3.4040315056626096`*^9}, {
  3.4040322448955746`*^9, 3.404032249972875*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVx39czHccwPHrfn3vR3XXXbWwU+iHCRelyeL7IS6hZClXra50Sj0iu2bh
VnoksSnRjwcy1S3lKOmSisT7jBrTsvFIbvGwU9tcHcelX6rbZ3+8Hq/Hc872
tC93UCkUSgju/58LTeNTKCayeteNDxaLEIboA8/u0kzkpdD0iOopIfhfj6r6
njCR2f0e32z8KATdHImvkGciR68P958ZEYKj+dOv3GebyF0tq0+SRiGcKH1w
YZO/iSTWwK3LOiHk6NzIM/tMpF9Bz0NBsxAS5X27lr4zkeKDrcWDu4UQ75Jx
on7kHfk8vvKc7LkADOK6hh7De9JF1hzpJRPA8it1bT46M8nwXvS0cNAOWnt0
x/qeD5OnGEeUvt/aQceWqkivRx/IWHf53myeHTD3nhnq6hkh28uPZvTV8IHL
ik5R9Y6SudLIw34SPlS8aR5wuT9G1nQe6eDoeSDPRO6GrnHSz5svFHjzoFUm
l8u0E+TSglWP55+2hd81YQWcho9k14Ag8ThhC7Pq9igtjZOkteXCO3eFDQyP
eyRVnp8iUw9u/rDSaA2Wt9ZOxy5Nk3mLRdqWBGvoDm+/WltrITVXPOJ69Vw4
ReS63wymIHboA8fbaVyIXQ7hnd0U9FNJm6v9GAeMRfcPzQ+yQlJFmcaQz4FS
bXJJ/UMrRHZGtSaLOOCsTivrDqYir+oAfUgTG/a0rqmQdFCRWL/DyhDOBt2P
dXn69TTk2KCs2GJmAbf2VeqTOzTUXO8jKCljgfPX2evjV9BRxc6Xv+VIWLCJ
28QU3qSjxS+Tnux8QwDqbvp55jIG2hCWy39fTkBw0qaEwFYGunHTZr96IwH+
LUFjtn5MtGTD4LOzk0wwe9nnL9QwUfh958ZF15hwJ2svNc2bQKLKzx1mpDAh
cqQqg7hMoNfzIwrnuTPhD7fl+hWuLMSQDTSmDDBA/lmCuLiahW4zaht8VQxo
j4hWrp7NRsbtF/TyBAaIpYaL9io2SurUTQTMZcDOQ5KnK2dxUGf61k7Xf+iQ
m8iasCrmoOKwlBeN9XS4Loq3GOy5qD8mRjYjnQ7XpvNoC45zkXLG6K9v/enw
4GqAocDOGjUpCu/dpdFB65LYkV9kjQ4HrVrg3EWD7JZw1V8cG3QiKDcr+SwN
pHP7YqMLbJCYOHmgJ5EGo83iWZ6ELeKJXA6bfWmwj/b6YWmWLQpg0uod2DQQ
uPrFu1F4yDMwxqzspUL67ohhzn4eSi3tXSSuo4Ixn5PiMMlDn1BUrHWZVHDK
XW3vhv3qByKLxF6r3HfLB1vhrDD7YZcl/y3Yin17R9iLxdgSyZ22IuyyREmT
E3a5Zb8Nf4qH5i57Ezf0HRU2K143cKZ5iN2/tr0Y+0CyS/RM7LvnFnofx66J
28ZYgK2Oc7p4FHsy5F5kEPZTq8mSTGy1p4p6FDtEY05NwqYMSLcyLDwkh/Oi
L7A9+wqn7bF3c7qKl2FHPO5Qu2KHx4yzvbDrtD5TAdhVotgRV2xpOb8mB1tL
SLttsQ+VBoYWYXucrlzHxq7Pz5pQYa9bYmyjYdOVQyFa7MLMIvWYkgpixbzx
R9gar8HZZuyo5Kiql9gZQ4GlRuy8uJPBJuw/G9Tcf7E1234ZtWD3Ztrk6LH/
A7QwPKA=
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx38803kcwPExM+bH3H4wNBtDTj+myKVT30+pyRXpRMMxsogH6eY61Y7z
kNRdfpQfj0oX9hCtSCahpN7riqvL6a4eklOPbnF3jdVq8ivsPvfH6/F6PF13
ZX6525REIoXh/v+58Ew7EklP1Gfc+GA0CmDcbPTZXbKeuBSeFVU/L4DA6zF1
P1D1RN7I4m+2fBTAkKvIn0nXE1PXJ0bOTArA3rDoK08XPZHRsf4koRPAicoH
F7YG6gnqBrh1eUgA+UMexJkDeiKgeOAho10AydLhjJXv9ITw+87ysb0CSORn
n2iefEc8T6w9J3nuBlphU8uA9j3Bl7RH+0jcYPWVpi6/IQNB8V32tHTMFToH
ho4PP58gTlGOyv2/dYWe7XXRPo8+EPGe0v15dFcw339mvG9gkuiuPpY93MAH
K4vYNMXgFFEgjj4SIOJDzZv2Uf79aaKh92gPTcMDaQ7y1PbNEGt87ZgMXx50
SqRSiXqWWFm87rHXaRf4XRVRTGv5SPSNMpJLqC7g3LRPbmydI6yNF955yrgw
MbM4pfb8PJH+/bYPa3WLwPjWmnP80gJRuJyr7khaBP2R3VcbG42E6srihEGN
M5yiFnjeDCUhWvgD+9uZzhC/GiJ7+0lIUdHlzpp2Al3Z/cNeISZILKtSaYuc
oFKdWtH80ASt643pTOU6AU+ZWdUfaop86oM0YW2OsK9zQ42oxxQJNbtNtJGO
MPRTU6FmMxk5tMhrths4YNX4Kv3JHTJqb/ZjVFRxgPd13ubENWaoZs/L3/JF
HNhq1WbOvGmGlr9MebLnjQOg/rafnVZRUEhEgd37agcITdmaFNxJQTdu2hxU
bnGAwI6QadsAc7Tii7FnZ+fsweDDKlqqMkeR93mty67Zw53c/aaZvlTErf2M
7ZhmD9GTddnUy1T02iuqVOBpD394rNascbdAFMloa9ooG6SfJgnL6y3QbUpj
i7+CDd1RsfL1LpZIt+uCRprEBqFYe5GlsEQpvUOzQW5s2HNY9HStMw31Zu3o
df+HBQXJFrMm5TRUHpH2orWZBde5iUYtywqNxMVJHLNYcG2hkOxdYoUOOU79
+jaQBQ+uBmmLP7FG12Sl9+6SWaDmJ/cUlVmjIyHrvHl9TMjriFT8RbNBJ0IK
clPPMkHsNhwfW2yDhNSThwaSmTDVLnReQrVFdC7/iMGfCQfIrx9W5tqiIHNy
M9uSCQz3gEQPEh15B8cZ5IMMyNobNUE7SEfplYPLhE0M0BXR0thzdORAUlhs
ymEAp2A9ywP71Y/UXAJ7o/zALT9sGU9mCMCuSv2bsQP79u6IF8uxRaI7XWXY
VcmiNg52tfGgjd08HbmtepMw/h0Dtslet9AW6MhyZGN3OfahVH6sE/bdc0t9
S7AbEnZSvLGVCZyLx7Dnwu5Fh2A/NZmryMFWLlGYHsMOUxnSU7BJo+IdFCMd
SeE893PsJcOlCyzsDFpf+SrsqMc9SnfsyLgZSx/sJrXffBB2HTd+0h1bXG3X
kI+tpor7bbEPVwaHl2F7na7dZIndXJQ7q8DeuELXRcY2k4+HqbFLcsqU03IG
CGWCmUfYKp8xFwN2TGpM3Uvs7PHgSh12YcLJUD32ny1Kq3+xVTt/mTJiP8ux
yddg/wd4JEF+
     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{0, Small}], 
    LineBox[CompressedData["
1:eJwVx38803kcwPFhP9jGVON6tJnNWDI7demouO/H5fx6bNJdfp8k0q2HTL8e
Ux56uJTrxygkD/0gD6KyZOnCUb39SPTQravD5fSohrQdNXJC2H3uj9fj9XgK
dii+32lOIpFCcf//cpjClkQyEsrKYqPJJIEx8siLDgsjQZpVm6XPS8CnKabi
JM1IQN/GLydmJDAgCPh6GctITNor+t9OSMD+I/dHEc9ICAt10a+GJHC26HG1
1MdIWCXyS8ldEjg64EKUpBuJvud+a7n5EkhOGtzz1YSReHT/XFyCSAIJfOXZ
2ukJoqcgLYUldQeDh7quzzBJaPLyc7ryxOB9S93sOfCR+KWnvS3yjRs09g2c
Hnw5Rew4EdK0ZY0bdG6piF799F8id719HSpeBdSDJWNP+qYJzntpfcicKzAs
Y3eX//WJeEimBkXIXaHs/d0RfvcMca93hH1CvxKSMpHI8GSWSBFJ82TJK6Ex
PikpvnWOeKtPLeVNiuAPzQ+59LrPRIx7Xs+N4yLgqNMyTLfniWCT77rLdiKY
ml2560rlApFf9ln5XuMCpg/M5advLBLDut6n3SEuoA2/V19TYyIetjsEORmc
oZh2TNQiIyFayxdbtIXOsM0bwh9pSejQLRWHtcEZxgu6s12DzVBr71pKnV4I
Ra3yc7U9Zkhh5x/COi8Ex2uKC1qZORpuvr1qY6AQ0hq/LQvoNEcVcubPCpIQ
Bi6pc3RBFmhJxyWvzLtOwKgZSvmzzQJZZldbf9jvBI57s4ISNpCRMtSVo/N0
AinjDnVZCxkJ38nKfp8UANLeaV+xjoLSv0lUrWsQgGyXNDGwkYJUsscx99MF
4NMQPGOznoquKtOGDvgK4ONqtspdQ0Wk/uLvdDQBtB05aK5YS0N2jXptgZYP
0dMVStpNGrpVmlVz4RIfnrl46zY4WyJ/mjvVNoUPSasSPQqvWqLN/llkvTcf
7kXEZvjxrNCaUwvXT9P54BFluM4ut0JccdDMznpH+Ck7oN+XQ0c3bi66NcQ4
wrFkyzmzQjqKyyyTMamO0OSQYDKwGaifyWRVqXnw62KOhVseA3lVTWp2xfLg
cf0mQ+4SJmK5R7pWU3jQyk/uVBUwUWBq3IPaegfIaggvf0O3RpGpnb48uQNE
OQ1ui821Rl2nXjT4rXCAT3c9OGKaDTovrgvc84wL6Rb6nqIjNijpJPn4lVwu
LHVen+BCYqEHBsZ4kz8X9qdGTNEPsZDT646OAHMujKvou+3mWUiQNaEabebA
8mN+bBfsiDCG7yts/4z0+57Ybh7i8T7sC/K3S7dily7PlHViBwS0NRdgj5bI
ba5il5oOWdsusNCdzTvzd2Bv3qevoy+ykHXE6MWXv3HgsJwfuwK7eqxN2otd
tT2S4oY9f7ZyoQd7PvRhdDB2u/nh+Bbsa+Jy8xPYUyf3CC9ik0aitlJMLHSe
r1RHYYsHzyyysSvP1MeFYUc877zmjG1iTNsEYatbPRc2YR9wz93rhR1Valt1
FLucQfayx84uCgwrwN44nPbOGrtWdWSuHHu0e6iEgk3OGAttxQ5v+Xt+qokD
HvuEs0+x6d3ba8ewY+QxFa+xNbp/4oexc7bny4zYwVaZSwaxNZFdn0zYHT7s
9ufY/wGZcE2P
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(n\\), \\(vr\\)]\\)\"", TraditionalForm], 
    FormBox["\"P(0)\"", TraditionalForm]},
  AxesOrigin->{1, -14.999999540816345`},
  FrameTicks->{{{{-16.11809565095832, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox[
           RowBox[{"-", "7"}], Power, Editable -> True, Selectable -> True]], 
         
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {-13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox[
           RowBox[{"-", "6"}], Power, Editable -> True, Selectable -> True]], 
         
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {-11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox[
           RowBox[{"-", "5"}], Power, Editable -> True, Selectable -> True]], 
         
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {-9.210340371976182, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox[
           RowBox[{"-", "4"}], Power, Editable -> True, Selectable -> True]], 
         
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {-6.907755278982137, 
       FormBox["0.001`", TraditionalForm]}, {-4.605170185988091, 
       FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["0.1`", TraditionalForm]}, {-15.424948470398375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.01948336229021, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.73180128983843, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.508657738524219`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.326336181730264`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.172185501903007`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.038654109278484`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.9208710736221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.716898269296165`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.429216196844383`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.02375108873622, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.86960040890896, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.736069016284437`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.618285980628055`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.414313176302118`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.126631103850338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.721165995742174, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.567015315914915, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.433483923290392, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.315700887634009, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.111728083308073, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.824046010856292, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.418580902748127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.264430222920869, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.1308988302963465`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.013115794639964, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.214608098422191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.809142990314028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.521460917862246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.298317366548036, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.115995809754082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.961845129926823, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.8283137373023015`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.710530701645918, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.506557897319982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.659260036932778, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-16.11809565095832, 
       FormBox["\" \"", TraditionalForm]}, {-13.815510557964274`, 
       FormBox["\" \"", TraditionalForm]}, {-11.512925464970229`, 
       FormBox["\" \"", TraditionalForm]}, {-9.210340371976182, 
       FormBox["\" \"", TraditionalForm]}, {-6.907755278982137, 
       FormBox["\" \"", TraditionalForm]}, {-4.605170185988091, 
       FormBox["\" \"", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["\" \"", TraditionalForm]}, {-15.424948470398375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.01948336229021, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.73180128983843, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.508657738524219`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.326336181730264`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.172185501903007`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.038654109278484`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.9208710736221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.716898269296165`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.429216196844383`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.02375108873622, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.86960040890896, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.736069016284437`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.618285980628055`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.414313176302118`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.126631103850338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.721165995742174, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.567015315914915, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.433483923290392, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.315700887634009, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.111728083308073, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.824046010856292, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.418580902748127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.264430222920869, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.1308988302963465`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.013115794639964, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.214608098422191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.809142990314028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.521460917862246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.298317366548036, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.115995809754082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.961845129926823, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.8283137373023015`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.710530701645918, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.506557897319982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.659260036932778, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, Automatic}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{1, 4}, {-14.999999540816345`, -2.31049062350915}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->FrontEndValueCache[{Automatic, {{-16.11809565095832, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox[
           RowBox[{"-", "7"}], Power, Editable -> True, Selectable -> True]], 
         
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {-13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox[
           RowBox[{"-", "6"}], Power, Editable -> True, Selectable -> True]], 
         
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {-11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox[
           RowBox[{"-", "5"}], Power, Editable -> True, Selectable -> True]], 
         
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {-9.210340371976182, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox[
           RowBox[{"-", "4"}], Power, Editable -> True, Selectable -> True]], 
         
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {-6.907755278982137, 
       FormBox["0.001`", TraditionalForm]}, {-4.605170185988091, 
       FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["0.1`", TraditionalForm]}, {-15.424948470398375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.01948336229021, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.73180128983843, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.508657738524219`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.326336181730264`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.172185501903007`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.038654109278484`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.9208710736221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.716898269296165`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.429216196844383`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.02375108873622, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.86960040890896, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.736069016284437`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.618285980628055`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.414313176302118`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.126631103850338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.721165995742174, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.567015315914915, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.433483923290392, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.315700887634009, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.111728083308073, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.824046010856292, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.418580902748127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.264430222920869, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.1308988302963465`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.013115794639964, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.214608098422191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.809142990314028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.521460917862246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.298317366548036, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.115995809754082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.961845129926823, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.8283137373023015`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.710530701645918, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.506557897319982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.659260036932778, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, {{-16.11809565095832, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox[
           RowBox[{"-", "7"}], Power, Editable -> True, Selectable -> True]], 
         
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {-13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox[
           RowBox[{"-", "6"}], Power, Editable -> True, Selectable -> True]], 
         
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {-11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox[
           RowBox[{"-", "5"}], Power, Editable -> True, Selectable -> True]], 
         
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {-9.210340371976182, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox[
           RowBox[{"-", "4"}], Power, Editable -> True, Selectable -> True]], 
         
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {-6.907755278982137, 
       FormBox["0.001`", TraditionalForm]}, {-4.605170185988091, 
       FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["0.1`", TraditionalForm]}, {-15.424948470398375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.01948336229021, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.73180128983843, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.508657738524219`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.326336181730264`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.172185501903007`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.038654109278484`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.9208710736221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.716898269296165`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.429216196844383`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.02375108873622, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.86960040890896, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.736069016284437`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.618285980628055`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.414313176302118`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.126631103850338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.721165995742174, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.567015315914915, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.433483923290392, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.315700887634009, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.111728083308073, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.824046010856292, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.418580902748127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.264430222920869, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.1308988302963465`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.013115794639964, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.214608098422191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.809142990314028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.521460917862246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.298317366548036, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.115995809754082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.961845129926823, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.8283137373023015`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.710530701645918, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.506557897319982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.659260036932778, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}]]], "Output",
 CellChangeTimes->{
  3.3890082606066017`*^9, {3.404031450262949*^9, 3.404031478703845*^9}, 
   3.4040317220437503`*^9, 3.404032265585325*^9, 3.4040322962394032`*^9, 
   3.4040323470624833`*^9, 3.404039326768808*^9, 3.404040621059907*^9, 
   3.4040435240642223`*^9, 3.404043756268115*^9, 3.404043873436595*^9, 
   3.4040448844503613`*^9, 3.4040449629131856`*^9}]
}, Open  ]],

Cell[TextData[{
 "If we assume that the diameter of a pinhole is 10 \[Mu]m, then a \
probability of pinholes of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "6"}]], TraditionalForm]]],
 "corresponds to about ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "4"], TraditionalForm]]],
 " pinholes per square meter:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124224944667854`*^9, 3.412422568753605*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"PinholeArea", " ", "=", 
   RowBox[{"\[Pi]", " ", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"10", " ", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ")"}], "2"], "/", "4."}]}]}], " ", 
  RowBox[{"(*", 
   SuperscriptBox["m", "2"], "*)"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ProbPinholes", " ", "=", " ", 
   SuperscriptBox["10", 
    RowBox[{"-", "6"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"nPinholes", " ", "=", " ", 
  RowBox[{"ProbPinholes", "/", "PinholeArea"}]}]}], "Input",
 CellChangeTimes->{{3.383047840257229*^9, 3.38304784624584*^9}, {
   3.3890083521882896`*^9, 3.389008357305648*^9}, 3.3890083983546734`*^9, {
   3.4040338206313715`*^9, 3.404033871484494*^9}, {3.4040339150070767`*^9, 
   3.404034035890899*^9}, {3.4040341330806513`*^9, 3.404034133150752*^9}}],

Cell[BoxData["12732.395447351624`"], "Output",
 CellChangeTimes->{3.40403426579148*^9, 3.404039326888981*^9, 
  3.404040621109979*^9, 3.40404352410428*^9, 3.4040437562981586`*^9, 
  3.4040438734966817`*^9, 3.4040448844703903`*^9, 3.4040449629432287`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inter-crossing Distances", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.4040344496458497`*^9, 3.404034454963496*^9}}],

Cell[TextData[{
 "To derive the probability density of inter-crossing distances, we assume \
that the negative exponential distribution describes the frequency of \
crossings along a line with \[Mu] crossings per unit length. The expected \
number of crossings in an interval of length ",
 StyleBox["g",
  FontSlant->"Italic"],
 " is \[Mu] ",
 StyleBox["g, ",
  FontSlant->"Italic"],
 "so the probability of there being no crossings in an interval of length ",
 StyleBox["g",
  FontSlant->"Italic"],
 " is:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412422599457755*^9, 3.4124227234860992`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pzero", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"P", "[", 
     RowBox[{"nvr", ",", 
      RowBox[{"\[Mu]", " ", "g"}], ",", " ", "0"}], "]"}], ",", " ", 
    RowBox[{"nvr", ">", "1"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.40403497672375*^9, 3.4040350022404413`*^9}, {
  3.404035199614251*^9, 3.404035201276642*^9}, {3.4040362305466595`*^9, 
  3.4040362366754723`*^9}, {3.4040363681845727`*^9, 3.404036370217496*^9}}],

Cell[BoxData[
 SuperscriptBox["nvr", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"g", " ", "\[Mu]"}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", "nvr"}]]}]]], "Output",
 CellChangeTimes->{
  3.404035002971493*^9, 3.40403520329955*^9, 3.4040362372162495`*^9, {
   3.4040363718198*^9, 3.404036384868563*^9}, 3.404039326949067*^9, 
   3.40404062118008*^9, 3.4040435241643667`*^9, 3.4040437563482304`*^9, 
   3.404043873556768*^9, 3.4040448845304766`*^9, 3.404044963003315*^9}]
}, Open  ]],

Cell[TextData[{
 "The probability density of ",
 StyleBox["g",
  FontSlant->"Italic"],
 " is therefore:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412422732499059*^9, 3.412422744536368*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdfg", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"Pzero", "/", 
    RowBox[{"Integrate", "[", 
     RowBox[{"Pzero", ",", " ", 
      RowBox[{"{", 
       RowBox[{"g", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ",
       
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"nvr", ">", "1"}], " ", "&&", " ", 
        RowBox[{"\[Mu]", ">", "0"}]}]}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.404036461969429*^9, 3.404036541303506*^9}, 
   3.4040365798789744`*^9, {3.404036631593336*^9, 3.404036634147008*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["nvr", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"g", " ", "\[Mu]"}], 
      RowBox[{
       RowBox[{"-", "1"}], "+", "nvr"}]]}]], " ", "\[Mu]", " ", 
   RowBox[{"Log", "[", "nvr", "]"}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", "nvr"}]]], "Output",
 CellChangeTimes->{3.404036637471789*^9, 3.404039327770248*^9, 
  3.4040406220012608`*^9, 3.4040435251257486`*^9, 3.4040437571293535`*^9, 
  3.4040438742477617`*^9, 3.4040448849711103`*^9, 3.404044963554107*^9}]
}, Open  ]],

Cell["The mean is given by", "Text",
 Editable->False,
 CellChangeTimes->{{3.412422760238947*^9, 3.4124227675494595`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"g", " ", "pdfg"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"g", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"nvr", ">", "1"}], " ", "&&", " ", 
      RowBox[{"\[Mu]", ">", "0"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4040367107671824`*^9, 3.4040367797363553`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", "nvr"}], 
  RowBox[{"\[Mu]", " ", 
   RowBox[{"Log", "[", "nvr", "]"}]}]]], "Output",
 CellChangeTimes->{3.404036790652051*^9, 3.4040393284812703`*^9, 
  3.404040622732312*^9, 3.404043525796714*^9, 3.4040437577602606`*^9, 
  3.404043874778525*^9, 3.404044885581989*^9, 3.404044964225072*^9}]
}, Open  ]],

Cell["\<\
Solving for \[Mu] and substituting back into our pdf yields the final \
expression for the probability density of inter-crossing distances in a \
clustered network, which we recognise as the probability density of the \
exponential distribution:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412422778254853*^9, 3.4124228485158834`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"gb", " ", "\[Equal]", " ", "gbar"}], ",", " ", "\[Mu]"}], "]"}], 
  "[", 
  RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"pdfg", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"pdfg", "/.", "%"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4040368542535057`*^9, 3.4040369300124416`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Mu]", "\[Rule]", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", "nvr"}], 
    RowBox[{"gbar", " ", 
     RowBox[{"Log", "[", "nvr", "]"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.404037029385333*^9, 3.404039328541357*^9, 
  3.4040406227723694`*^9, 3.404043525836771*^9, 3.404043757840376*^9, 
  3.4040438749788127`*^9, 3.404044885632061*^9, 3.404044964285158*^9}],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox["g", "gbar"]}]], "gbar"]], "Output",
 CellChangeTimes->{3.404037029385333*^9, 3.404039328541357*^9, 
  3.4040406227723694`*^9, 3.404043525836771*^9, 3.404043757840376*^9, 
  3.4040438749788127`*^9, 3.404044885632061*^9, 3.4040449643652735`*^9}]
}, Open  ]],

Cell[TextData[{
 "The probability density of the length of intervals containing ",
 StyleBox["n",
  FontSlant->"Italic"],
 " crossings in a ",
 StyleBox["random",
  FontSlant->"Italic"],
 " network is:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412422931385043*^9, 3.4124229535268817`*^9}, {
  3.4124230253802013`*^9, 3.4124230301971283`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdfgn", "=", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"PoissonDistribution", "[", 
      RowBox[{"\[Mu]", " ", "g"}], "]"}], ",", " ", "n"}], "]"}], "/", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"PoissonDistribution", "[", 
        RowBox[{"\[Mu]", " ", "g"}], "]"}], ",", " ", "n"}], "]"}], ",", " ", 
     
     RowBox[{"{", 
      RowBox[{"g", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
     
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"n", ">", "0"}], "&&", 
       RowBox[{"\[Mu]", ">", "0"}]}]}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "g"}], " ", "\[Mu]"}]], " ", "\[Mu]", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"g", " ", "\[Mu]"}], ")"}], "n"]}], 
  RowBox[{"n", "!"}]]], "Output",
 CellChangeTimes->{3.4040380797957487`*^9, 3.4040393291322064`*^9, 
  3.4040406233331757`*^9, 3.40404352660788*^9, 3.404043758431226*^9, 
  3.4040438755796766`*^9, 3.4040448862729826`*^9, 3.404044964946109*^9}]
}, Open  ]],

Cell["with mean", "Text",
 Editable->False,
 CellChangeTimes->{{3.412422958794456*^9, 3.412422961197912*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"g", " ", "pdfgn"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"g", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"n", ">", "0"}], "&&", 
     RowBox[{"\[Mu]", ">", "0"}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4040377872150383`*^9, 3.404037814424163*^9}, {
  3.4040378816708593`*^9, 3.4040378902431855`*^9}, {3.404037930130541*^9, 
  3.4040379742339582`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", "n"}], "\[Mu]"]], "Output",
 CellChangeTimes->{3.404038169695018*^9, 3.4040393296329265`*^9, 
  3.404040623753781*^9, 3.4040435270885715`*^9, 3.4040437588718596`*^9, 
  3.4040438759301805`*^9, 3.4040448867236304`*^9, 3.404044965406771*^9}]
}, Open  ]],

Cell[TextData[{
 "Solving for \[Mu] and substituting into our expression ",
 StyleBox["pdfgn", "Input"],
 ", we obtain the probability density in terms of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["g", "_"], TraditionalForm]]],
 " and ",
 StyleBox["n",
  FontSlant->"Italic"],
 " only:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412422980355459*^9, 3.4124230567352877`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pdfgn", " ", "=", " ", 
  RowBox[{"PowerExpand", "[", 
   RowBox[{"FunctionExpand", "[", 
    RowBox[{"pdfgn", "/.", 
     RowBox[{"\[Mu]", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"1", "/", "gbar"}], ")"}]}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4040389846168175`*^9, 3.4040389863593235`*^9}, {
  3.4040392837970176`*^9, 3.404039287292043*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox["g", "gbar"]}]], " ", 
   SuperscriptBox["g", "n"], " ", 
   SuperscriptBox["gbar", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "n"}]]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "n"}], "]"}]]], "Output",
 CellChangeTimes->{3.404038994240656*^9, 3.4040393296829987`*^9, 
  3.404040623783824*^9, 3.4040435271386433`*^9, 3.404043758931946*^9, 
  3.4040438761204543`*^9, 3.404044886783717*^9, 3.4040449654868865`*^9}]
}, Open  ]],

Cell[TextData[{
 "This pdf is the same at that of a gamma distribution with mean (",
 StyleBox["n",
  FontSlant->"Italic"],
 "+1)",
 Cell[BoxData[
  FormBox[
   OverscriptBox["g", "_"], TraditionalForm]]],
 " and coefficient of variation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    SqrtBox[
     RowBox[{"n", "+", "1"}]]}], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124230646466637`*^9, 3.412423111734373*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"GammaDistribution", "[", 
    RowBox[{
     RowBox[{"n", "+", "1"}], ",", " ", "gbar"}], "]"}], ",", "g"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4040391989049487`*^9, 3.4040392535635443`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox["g", "gbar"]}]], " ", 
   SuperscriptBox["g", "n"], " ", 
   SuperscriptBox["gbar", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "n"}]]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "n"}], "]"}]]], "Output",
 CellChangeTimes->{3.4040393297631135`*^9, 3.404040623813867*^9, 
  3.404043527208744*^9, 3.404043758992032*^9, 3.4040438761705265`*^9, 
  3.4040448868237743`*^9, 3.4040449655469728`*^9}]
}, Open  ]],

Cell[TextData[{
 "For our clustered network we cannot obtain a closed form for any integer ",
 StyleBox["n",
  FontSlant->"Italic"],
 ", so consider small integer values only. In the case when ",
 StyleBox["n",
  FontSlant->"Italic"],
 " = 1 we have:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124231187043953`*^9, 3.4124231978782415`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P1", " ", "=", " ", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"P", "[", 
      RowBox[{"nvr", ",", 
       RowBox[{"\[Mu]", " ", "g"}], ",", " ", "1"}], "]"}], ",", " ", 
     RowBox[{"nvr", ">", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pdfg1", " ", "=", " ", 
   RowBox[{"P1", "/", 
    RowBox[{"Integrate", "[", 
     RowBox[{"P1", ",", " ", 
      RowBox[{"{", 
       RowBox[{"g", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ",
       
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"nvr", ">", "1"}], " ", "&&", " ", 
        RowBox[{"\[Mu]", ">", "0"}]}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gb", " ", "=", " ", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"g", " ", "pdfg1"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"g", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
     
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"nvr", ">", "1"}], " ", "&&", " ", 
       RowBox[{"\[Mu]", ">", "0"}]}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"gb", "\[Equal]", 
      RowBox[{"(", 
       RowBox[{"2", "gbar"}], ")"}]}], ",", " ", "\[Mu]"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pdfg1", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"pdfg1", "/.", "%"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"TrueQ", "[", 
  RowBox[{
   RowBox[{"pdfg1", " ", "==", "pdfgn"}], "/.", 
   RowBox[{"n", "\[Rule]", "1"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.4040397080771027`*^9, 3.404039763516821*^9}, {
  3.4040398698997917`*^9, 3.404039956344093*^9}, {3.404039993858035*^9, 
  3.4040400122645025`*^9}, {3.404040058721304*^9, 3.404040101653037*^9}, {
  3.4040401384559565`*^9, 3.4040401613989472`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox["g", "gbar"]}]], " ", "g"}], 
  SuperscriptBox["gbar", "2"]]], "Output",
 CellChangeTimes->{
  3.404039708858226*^9, 3.4040397642178288`*^9, 3.4040398716923695`*^9, {
   3.404039907223461*^9, 3.4040399589378223`*^9}, {3.4040400006778417`*^9, 
   3.4040400134361873`*^9}, {3.4040400638186336`*^9, 
   3.4040400799217887`*^9}, {3.4040401466277075`*^9, 3.4040401908512974`*^9}, 
   3.4040406248353357`*^9, 3.404043528240227*^9, 3.404043760023515*^9, 
   3.404043877191995*^9, 3.404044887915344*^9, 3.4040449666084995`*^9}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.404039708858226*^9, 3.4040397642178288`*^9, 3.4040398716923695`*^9, {
   3.404039907223461*^9, 3.4040399589378223`*^9}, {3.4040400006778417`*^9, 
   3.4040400134361873`*^9}, {3.4040400638186336`*^9, 
   3.4040400799217887`*^9}, {3.4040401466277075`*^9, 3.4040401908512974`*^9}, 
   3.4040406248353357`*^9, 3.404043528240227*^9, 3.404043760023515*^9, 
   3.404043877191995*^9, 3.404044887915344*^9, 3.404044966668586*^9}]
}, Open  ]],

Cell[TextData[{
 "When ",
 StyleBox["n",
  FontSlant->"Italic"],
 " = 2, we obtain:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412423210075781*^9, 3.4124232211617217`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P2", " ", "=", " ", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"P", "[", 
      RowBox[{"nvr", ",", 
       RowBox[{"\[Mu]", " ", "g"}], ",", " ", "2"}], "]"}], ",", " ", 
     RowBox[{"nvr", ">", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pdfg2", " ", "=", " ", 
   RowBox[{"P2", "/", 
    RowBox[{"Integrate", "[", 
     RowBox[{"P2", ",", " ", 
      RowBox[{"{", 
       RowBox[{"g", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ",
       
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"nvr", ">", "1"}], " ", "&&", " ", 
        RowBox[{"\[Mu]", ">", "0"}]}]}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"gb", " ", "=", " ", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"g", " ", "pdfg2"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"g", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
     
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"nvr", ">", "1"}], " ", "&&", " ", 
       RowBox[{"\[Mu]", ">", "0"}]}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"gb", "\[Equal]", 
      RowBox[{"(", 
       RowBox[{"3", "gbar"}], ")"}]}], ",", " ", "\[Mu]"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pdfg2", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"pdfg2", "/.", "%"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4040397080771027`*^9, 3.404039763516821*^9}, {
   3.4040398698997917`*^9, 3.404039956344093*^9}, {3.404039993858035*^9, 
   3.4040400122645025`*^9}, {3.404040058721304*^9, 3.404040101653037*^9}, {
   3.4040401384559565`*^9, 3.4040401613989472`*^9}, {3.404040274832056*^9, 
   3.4040403409471245`*^9}, 3.4040403875841856`*^9, {3.4040404392584896`*^9, 
   3.4040404460782957`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"4", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "g", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"Log", "[", "nvr", "]"}]}], ")"}]}], 
       RowBox[{"3", " ", "gbar", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", 
          RowBox[{"Log", "[", "nvr", "]"}]}], ")"}]}]]}]], " ", "g", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"Log", "[", "nvr", "]"}]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "g"}], "+", 
      RowBox[{
       RowBox[{"Log", "[", "nvr", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "g"}], "+", 
         RowBox[{"6", " ", "gbar"}], "+", 
         RowBox[{"3", " ", "gbar", " ", 
          RowBox[{"Log", "[", "nvr", "]"}]}]}], ")"}]}]}], ")"}]}], ")"}], 
  "/", 
  RowBox[{"(", 
   RowBox[{"27", " ", 
    SuperscriptBox["gbar", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"Log", "[", "nvr", "]"}]}], ")"}], "4"]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.4040403084904547`*^9, 3.4040404037173843`*^9, {3.404040440149771*^9, 
   3.4040404475003405`*^9}, 3.4040406279798574`*^9, 3.404043531785325*^9, 
   3.4040437638189726`*^9, 3.4040438803265023`*^9, 3.4040448911099377`*^9, 
   3.404044969783064*^9}]
}, Open  ]],

Cell["When n = 3, we obtain :", "Text",
 Editable->False,
 CellChangeTimes->{3.412423233659693*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P3", " ", "=", " ", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"P", "[", 
      RowBox[{"nvr", ",", 
       RowBox[{"\[Mu]", " ", "g"}], ",", " ", "3"}], "]"}], ",", " ", 
     RowBox[{"nvr", ">", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pdfg3", " ", "=", " ", 
   RowBox[{"P3", "/", 
    RowBox[{"Integrate", "[", 
     RowBox[{"P3", ",", " ", 
      RowBox[{"{", 
       RowBox[{"g", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ",
       
      RowBox[{"Assumptions", "\[Rule]", 
       RowBox[{
        RowBox[{"nvr", ">", "1"}], " ", "&&", " ", 
        RowBox[{"\[Mu]", ">", "0"}]}]}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"gb", " ", "=", " ", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"g", " ", "pdfg3"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"g", ",", " ", "0", ",", " ", "\[Infinity]"}], "}"}], ",", " ", 
     
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"nvr", ">", "1"}], " ", "&&", " ", 
       RowBox[{"\[Mu]", ">", "0"}]}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"gb", "\[Equal]", 
      RowBox[{"(", 
       RowBox[{"4", "gbar"}], ")"}]}], ",", " ", "\[Mu]"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pdfg3", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"pdfg3", "/.", "%"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4040397080771027`*^9, 3.404039763516821*^9}, {
   3.4040398698997917`*^9, 3.404039956344093*^9}, {3.404039993858035*^9, 
   3.4040400122645025`*^9}, {3.404040058721304*^9, 3.404040101653037*^9}, {
   3.4040401384559565`*^9, 3.4040401613989472`*^9}, {3.404040274832056*^9, 
   3.4040403409471245`*^9}, 3.4040403875841856`*^9, {3.4040404392584896`*^9, 
   3.4040404460782957`*^9}, {3.4040405537531247`*^9, 3.4040405767762303`*^9}}],\


Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"g", " ", 
        RowBox[{"(", 
         RowBox[{"12", "+", 
          RowBox[{
           RowBox[{"Log", "[", "nvr", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{"9", "+", 
             RowBox[{"2", " ", 
              RowBox[{"Log", "[", "nvr", "]"}]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"4", " ", "gbar", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{
           RowBox[{"Log", "[", "nvr", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"Log", "[", "nvr", "]"}]}], ")"}]}]}], ")"}]}]]}]], " ", 
    "g", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"12", "+", 
       RowBox[{
        RowBox[{"Log", "[", "nvr", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", 
          RowBox[{"2", " ", 
           RowBox[{"Log", "[", "nvr", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
    
    RowBox[{"(", 
     RowBox[{
      RowBox[{"12", " ", "g"}], "+", 
      RowBox[{
       RowBox[{"Log", "[", "nvr", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", "g"}], "+", 
         RowBox[{"12", " ", "gbar"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"Log", "[", "nvr", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"g", "+", 
            RowBox[{"6", " ", "gbar"}], "+", 
            RowBox[{"2", " ", "gbar", " ", 
             RowBox[{"Log", "[", "nvr", "]"}]}]}], ")"}]}]}], ")"}]}]}], 
     ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"12", " ", "g"}], "+", 
      RowBox[{
       RowBox[{"Log", "[", "nvr", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", "g"}], "+", 
         RowBox[{"24", " ", "gbar"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"Log", "[", "nvr", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"g", "+", 
            RowBox[{"12", " ", "gbar"}], "+", 
            RowBox[{"4", " ", "gbar", " ", 
             RowBox[{"Log", "[", "nvr", "]"}]}]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"512", " ", 
    SuperscriptBox["gbar", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{
        RowBox[{"Log", "[", "nvr", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"Log", "[", "nvr", "]"}]}], ")"}]}]}], ")"}], "5"]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.404040585638974*^9, 3.4040406352903695`*^9, 
  3.404043539997133*^9, 3.4040437710693984`*^9, 3.404043887426712*^9, 
  3.4040449068726034`*^9, 3.404044977123619*^9}]
}, Open  ]],

Cell[TextData[{
 "We compute the coefficient of variation for these cases using numerical \
methods, and plot these against the variance ratio ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "vr"], ":"}], TraditionalForm]]]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412423256061906*^9, 3.4124232871966753`*^9}, {
  3.412423707350827*^9, 3.4124237074309425`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"gbar", " ", "=", " ", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cvg0", " ", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cvg1", " ", "=", " ", 
   RowBox[{"1", "/", 
    SqrtBox["2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cvg2", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"nvr", ",", 
       RowBox[{
        SqrtBox[
         RowBox[{"NIntegrate", "[", 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"g", " ", "-", 
               RowBox[{"3", "gbar"}]}], ")"}], "2"], " ", "pdfg2"}], ",", " ",
            
           RowBox[{"{", 
            RowBox[{"g", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]], "/",
         
        RowBox[{"(", 
         RowBox[{"3", " ", "gbar"}], ")"}]}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"nvr", ",", " ", "1", ",", " ", "5", ",", " ", ".1"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cvg3", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"nvr", ",", 
       RowBox[{
        SqrtBox[
         RowBox[{"NIntegrate", "[", 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"g", " ", "-", 
               RowBox[{"4", "gbar"}]}], ")"}], "2"], " ", "pdfg3"}], ",", " ",
            
           RowBox[{"{", 
            RowBox[{"g", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]], "/",
         
        RowBox[{"(", 
         RowBox[{"4", " ", "gbar"}], ")"}]}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"nvr", ",", " ", "1", ",", " ", "5", ",", " ", ".1"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"cvg0", ",", "cvg1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"nvr", ",", " ", "1", ",", " ", "5"}], "}"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "}"}], ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"cvg2", ",", "cvg3"}], "}"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Dotted", ",", "DotDashed"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(n\), \(vr\)]\)\>\"", ",", 
      "\"\<cv(\!\(\*SubscriptBox[\(g\), \(n\)]\))\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"gbar", " ", "=."}]}], "Input",
 CellChangeTimes->{{3.404042505189152*^9, 3.4040426072759457`*^9}, {
   3.404042649877203*^9, 3.404042681672923*^9}, {3.4040427342385087`*^9, 
   3.4040429298097267`*^9}, {3.404042995273859*^9, 3.4040431305583887`*^9}, 
   3.404043465990717*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{1.000000081632653, 1.}, {1.0392573632193876`, 1.}, {
      1.0785146448061218`, 1.}, {1.1636334283418348`, 1.}, {
      1.2431115342806087`, 1.}, {1.3210305952755046`, 1.}, {1.405553876632645,
       1.}, {1.484436480392846, 1.}, {1.5699233045152916`, 1.}, {
      1.6538510836938594`, 1.}, {1.7321381852754878`, 1.}, {
      1.8170295072193607`, 1.}, {1.8962801515662944`, 1.}, {
      1.9739717509693502`, 1.}, {2.05826757073465, 1.}, {2.136922712903011, 
      1.}, {2.2221820754336163`, 1.}, {2.305882393020344, 1.}, {
      2.383942033010132, 1.}, {2.468605893362165, 1.}, {2.5476290761172584`, 
      1.}, {2.6332564792345963`, 1.}, {2.7173248374080563`, 1.}, {
      2.7957525179845772`, 1.}, {2.8807844189233425`, 1.}, {
      2.9601756422651686`, 1.}, {3.038007820663117, 1.}, {3.1224442194233095`,
       1.}, {3.201239940586563, 1.}, {3.286639882112061, 1.}, {
      3.370480778693681, 1.}, {3.4486809976783617`, 1.}, {3.533485437025287, 
      1.}, {3.612649198775273, 1.}, {3.6902539155813807`, 1.}, {
      3.7744628527497333`, 1.}, {3.8530311123211463`, 1.}, {3.938203592254804,
       1.}, {4.017735394591522, 1.}, {4.095708151984363, 1.}, {
      4.180285129739448, 1.}, {4.259221429897594, 1.}, {4.344761950417984, 
      1.}, {4.428743425994496, 1.}, {4.507084223974069, 1.}, {
      4.592029242315887, 1.}, {4.671333583060765, 1.}, {4.7490788788617655`, 
      1.}, {4.8334283950250105`, 1.}, {4.9121372335913165`, 1.}, {
      4.997450292519867, 1.}, {4.998725105443607, 1.}, {4.999999918367347, 
      1.}}]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{Small, Small}], 
     LineBox[{{1.000000081632653, 0.7071067811865475}, {1.0392573632193876`, 
      0.7071067811865475}, {1.0785146448061218`, 0.7071067811865475}, {
      1.1636334283418348`, 0.7071067811865475}, {1.2431115342806087`, 
      0.7071067811865475}, {1.3210305952755046`, 0.7071067811865475}, {
      1.405553876632645, 0.7071067811865475}, {1.484436480392846, 
      0.7071067811865475}, {1.5699233045152916`, 0.7071067811865475}, {
      1.6538510836938594`, 0.7071067811865475}, {1.7321381852754878`, 
      0.7071067811865475}, {1.8170295072193607`, 0.7071067811865475}, {
      1.8962801515662944`, 0.7071067811865475}, {1.9739717509693502`, 
      0.7071067811865475}, {2.05826757073465, 0.7071067811865475}, {
      2.136922712903011, 0.7071067811865475}, {2.2221820754336163`, 
      0.7071067811865475}, {2.305882393020344, 0.7071067811865475}, {
      2.383942033010132, 0.7071067811865475}, {2.468605893362165, 
      0.7071067811865475}, {2.5476290761172584`, 0.7071067811865475}, {
      2.6332564792345963`, 0.7071067811865475}, {2.7173248374080563`, 
      0.7071067811865475}, {2.7957525179845772`, 0.7071067811865475}, {
      2.8807844189233425`, 0.7071067811865475}, {2.9601756422651686`, 
      0.7071067811865475}, {3.038007820663117, 0.7071067811865475}, {
      3.1224442194233095`, 0.7071067811865475}, {3.201239940586563, 
      0.7071067811865475}, {3.286639882112061, 0.7071067811865475}, {
      3.370480778693681, 0.7071067811865475}, {3.4486809976783617`, 
      0.7071067811865475}, {3.533485437025287, 0.7071067811865475}, {
      3.612649198775273, 0.7071067811865475}, {3.6902539155813807`, 
      0.7071067811865475}, {3.7744628527497333`, 0.7071067811865475}, {
      3.8530311123211463`, 0.7071067811865475}, {3.938203592254804, 
      0.7071067811865475}, {4.017735394591522, 0.7071067811865475}, {
      4.095708151984363, 0.7071067811865475}, {4.180285129739448, 
      0.7071067811865475}, {4.259221429897594, 0.7071067811865475}, {
      4.344761950417984, 0.7071067811865475}, {4.428743425994496, 
      0.7071067811865475}, {4.507084223974069, 0.7071067811865475}, {
      4.592029242315887, 0.7071067811865475}, {4.671333583060765, 
      0.7071067811865475}, {4.7490788788617655`, 0.7071067811865475}, {
      4.8334283950250105`, 0.7071067811865475}, {4.9121372335913165`, 
      0.7071067811865475}, {4.997450292519867, 0.7071067811865475}, {
      4.998725105443607, 0.7071067811865475}, {4.999999918367347, 
      0.7071067811865475}}]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], Dashing[{0, Small}], 
     LineBox[{{1., 0.5773502691891762}, {1.1, 0.5860368972927851}, {1.2, 
      0.5931977777107624}, {1.3, 0.5992182967607141}, {1.4, 
      0.6043623850624109}, {1.5, 0.6088171747604689}, {1.6, 
      0.6127192302198347}, {1.7, 0.6161706733717862}, {1.8, 
      0.619249483002583}, {1.9000000000000001`, 0.6220162907035846}, {2., 
      0.624518992993516}, {2.1, 0.6267959590704903}, {2.2, 
      0.6288783105042568}, {2.3000000000000003`, 0.6307915727096703}, {2.4, 
      0.6325568919779444}, {2.5, 0.6341919462636474}, {2.6, 
      0.6357116363402081}, {2.7, 0.6371286169607406}, {2.8000000000000003`, 
      0.6384537097989453}, {2.9, 0.6396962278948746}, {3., 
      0.6408642330617904}, {3.1, 0.6419647419473041}, {3.2, 
      0.6430038923672277}, {3.3000000000000003`, 0.6439870786110811}, {
      3.4000000000000004`, 0.6449190623006137}, {3.5, 0.6458040638291723}, {
      3.6, 0.6466458382578524}, {3.7, 0.6474477386817987}, {
      3.8000000000000003`, 0.648212769428047}, {3.9000000000000004`, 
      0.648943630949245}, {4., 0.649642757895496}, {4.1000000000000005`, 
      0.6503123515506191}, {4.2, 0.6509544075881663}, {4.3, 
      0.6515707399211401}, {4.4, 0.6521630012758779}, {4.5, 
      0.6527327010064414}, {4.6000000000000005`, 0.6532812205745107}, {4.7, 
      0.6538098270462707}, {4.8, 0.6543196848983235}, {4.9, 
      0.6548118663763127}, {5., 0.6552873606104355}}]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{0, Small, Small, Small}], 
     LineBox[{{1., 0.4999999999862312}, {1.1, 0.5116165707015516}, {1.2, 
      0.5216715373045371}, {1.3, 0.5304383422673996}, {1.4, 
      0.5381412377469917}, {1.5, 0.5449603959060928}, {1.6, 
      0.5510399636198057}, {1.7, 0.5564955964870776}, {1.8, 
      0.5614206540946273}, {1.9000000000000001`, 0.5658910605367361}, {2., 
      0.56996905085036}, {2.1, 0.5737060450081595}, {2.2, 
      0.5771448557456982}, {2.3000000000000003`, 0.5803213929623048}, {2.4, 
      0.5832659876335547}, {2.5, 0.5860044276356186}, {2.6, 
      0.5885587742037223}, {2.7, 0.590948010302245}, {2.8000000000000003`, 
      0.5931885592993862}, {2.9, 0.595294702649144}, {3., 
      0.5972789196505025}, {3.1, 0.5991521631145378}, {3.2, 
      0.6009240875064622}, {3.3000000000000003`, 0.6026032367409796}, {
      3.4000000000000004`, 0.6041972004266648}, {3.5, 0.6057127444378694}, {
      3.6, 0.60715592059232}, {3.7, 0.6085321592259539}, {3.8000000000000003`,
       0.6098463476937136}, {3.9000000000000004`, 0.61110289722914}, {4., 
      0.6123058001278662}, {4.1000000000000005`, 0.6134586788506751}, {4.2, 
      0.6145648283489259}, {4.3, 0.6156272526795192}, {4.4, 
      0.6166486967909415}, {4.5, 0.617631674207907}, {4.6000000000000005`, 
      0.618578491220612}, {4.7, 0.6194912680840237}, {4.8, 
      0.6203719576508111}, {4.9, 0.6212223617942529}, {5., 
      0.6220441459219496}}]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(n\\), \\(vr\\)]\\)\"", TraditionalForm], 
    FormBox[
    "\"cv(\\!\\(\\*SubscriptBox[\\(g\\), \\(n\\)]\\))\"", TraditionalForm]},
  AxesOrigin->{1., 0.75},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.404043456637267*^9, 3.4040435408884144`*^9, 
  3.404043771940651*^9, 3.4040438882679214`*^9, 3.4040449143834033`*^9, 
  3.4040449779247713`*^9}]
}, Open  ]],

Cell["\<\
Note that the probability densities we have derived are well approximated by \
gamma distributions with the same mean and variance:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412423727189354*^9, 3.4124237503927183`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nvr", " ", "=", " ", "3"}], ";", 
  RowBox[{"gbar", " ", "=", " ", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cv2", "=", 
   RowBox[{
    SqrtBox[
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"g", " ", "-", 
           RowBox[{"3", "gbar"}]}], ")"}], "2"], " ", "pdfg2"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"g", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]], "/", 
    RowBox[{"(", 
     RowBox[{"3", " ", "gbar"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cv3", " ", "=", " ", 
   RowBox[{
    SqrtBox[
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"g", " ", "-", 
           RowBox[{"4", "gbar"}]}], ")"}], "2"], " ", "pdfg3"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"g", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]], "/", 
    RowBox[{"(", 
     RowBox[{"4", " ", "gbar"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pdfg2", ",", "\[IndentingNewLine]", 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"GammaDistribution", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          SuperscriptBox["cv2", "2"]}], ",", " ", 
         RowBox[{"3", " ", "gbar", " ", 
          SuperscriptBox["cv2", "2"]}]}], "]"}], ",", "g"}], "]"}], ",", 
     "pdfg3", ",", "\[IndentingNewLine]", 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"GammaDistribution", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          SuperscriptBox["cv3", "2"]}], ",", " ", 
         RowBox[{"4", " ", "gbar", " ", 
          SuperscriptBox["cv3", "2"]}]}], "]"}], ",", "g"}], "]"}]}], "}"}], 
   ",", " ", 
   RowBox[{"{", 
    RowBox[{"g", ",", " ", "0", ",", " ", "10"}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "Dashed"}], "}"}]}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(g\), \(n\)]\)\>\"", ",", 
      "\"\<pdf(\!\(\*SubscriptBox[\(g\), \(n\)]\))\>\""}], "}"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.4040440365611567`*^9, 3.4040443455154114`*^9}, {
  3.404044394776245*^9, 3.4040443998034735`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8Vf8fB/BrNjRoKBIXhShSGr6N16EhI8muFCFC3VIpq9RXZZRcokRR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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{Small, Small}], 
    LineBox[CompressedData["
1:eJwV13k0Vd0bB/BrqNcUoVRkTkiUaFR9T8bXEDL2KkRlqkyVEqKJVOomesmU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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nlcTWsXB/DOsJuJJDSeBqFJZQhhLZokdZvDTdJEpZKKRpJcnZKGq0Gj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     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], Dashing[{Small, Small}], 
    LineBox[CompressedData["
1:eJwV1nc8V98fB/DPFD5llVEJGSlUpDIq72OUZCQr45NsoUQhVMpKHxGJiGQk
SYRC+CLb51pZleyyCpmRmd/9/XUfz8e55zzuPff9fp272+aqgT2JQCCIEwmE
/18T/WxY5OweqKQbv9rWn3/mRE2HiM55ESeYI52U2ELuUdmoKw8UEfGBiE9J
AiWBf1U4ogpz2bsC4MxaYpfgRVZIrAgXpoowwIPLcEn5yjaQmbZ7uOEYAXlp
EoV5vkLQx/H839rXKKCKyQUriUiAeDrb0ZXVGNjlajff9lkaLp/wvPJX+ClM
JgTdF34jB+87B9P+qD+DgMIwDovmI7DiotM765gEjDDxiud6ypBM7GX8PZkC
RMXzVSoyABrNjyQWv6bC58F3X8fk1OBnnGblH6c0iOsvMwxf1oAwu3X6/OpL
+Ig1yLNPakLH6qXoGeHXkDzJ8rNJVw+86oVkp/Mygc68lZHVpw87Hnc2/lbP
ghNmkQpiGQZgI4XIE445MGZQP5XuZQLeWbTiua/vQEe70j5+xhLORI2yzCW/
h/vh/OWvEq1A0LvSaNYpH3Ze+LoY2WgNFeo3ZqZXC2CvOyP2HrKDTT0/JH8L
F0PACQNe3wdO0FVR5jn5sxj0Qv3mSmedITM9rnoirwSyV9sDYi5eBr1rehfH
1UuhvSnPKf7cVXjCVvJkzPEjtEWUGW2uuwY8z5ik2a9VwGYueWk01QdWOQpf
ux2vBocrH6oGwnxh2P+F/kxyNcQRXS+P+dyEQke/59NONcC79UPBMv02mMsf
Vp5arYVfywIBW17chZSGJPcJYQxUrnS47mkJgj9xBVIDYRgM94SQ9tkHwynH
xqH2ZQzkFJbMUteDYZL817ikowE8jD5wjRwKAcUTesqMkCZoaWAJEHnLgNac
NZLk9CdQvaegbjD0EO40yJyRu9gBRRtxmuq8MfA2h9Fz+UA35Id9bCn6mgzj
PONhZ6y7of80S58jWwpIep1R2RvdDRdTW+ePHEuB5OO0lKHlbjju+Fpof1IK
RGFhDua1PcB50/2796VU8BqKmNWk98FZBwdLXkIaJNEaA7lPDkI+x/gObvQK
HKHt6eS1IWg3lMy/OZENriP7hvLf/gKjTt8t6Q8KgH13kOSA4gzMhNjyB5wr
hYdcjVIpVvNwKWWRNWi9AooVdhXouc7DsqZv8BxrJQxbXoW1m/Owd8zazWxb
JRzL3mp0PnYexAh0fy7pSvipRb+9pWUeZDI1xcRMK0E98Pcnn2N/4PTfw4e+
5lbC0gKnpwHfAszqyNXY0qvApsfoI7lpETiG3SWDEqqBPeH7Ffdvi3CXXda6
Ma0a3pm7Cg6MLoKVj2YZ+9tqIHeH+JQQ/0L7qMQ394pqSOsqkXdX+AtU152h
34erYfSzSEZ/6l/42CiodkqmBpxbJyOLfZZgNTrMRLSgBngifUAyZAk6DVQG
L5fVQMlZlqno6CWYnmr0z6mtAdonYW23nCUQ3aq2ZdeXGshqNqBKjizB1NZX
Ok8Xa2CqocgnWn8ZKhoOl/EdrQX32iCbq5IrwJmVpr0vpxaEhk+xLMqvQO1L
DlgpqIVGElvmLbQCCnJEm5rSWpBA4bMMsxW4frxJSaOhFr6VxNxNe7ACvwup
WnPDtaCam/782/QKbE33zmfdXgfcCcxu9aJV0M3NZN9zqw7Ki0P9GmpWoVXB
5qtQQB24dOmInmtbhS+S/Qtc9+uglrfNyXJ8FV5pOu///rgOfCK/LXkLrsHp
4pAsuTd18D14nO/t3TWQP5AiFt1VB3lumw0FtNZh+fmSvdOBemiK3+qTbbIO
ZlcH+f/J18NozY4kNbt1SLgyLflAqR52bN83cfnOOpwNOu7yUKMegipPBlYW
rMPJ3hulSub1YMJz572z6D/gag4Lkgiqh5X3s1vLVv9B4IlJRZv2etjWv6Rk
wLYBVfb+Mpu+1sMBVoLVGN8GWB5JaUjrqQdbOkcW96EN4JYc4GoYxp+HIq3h
cGkDgrOCOMoW6+G5sZ0H5+cNuO7QJqK5nQkpN13GZc8TkFe2WvE/UybIVrAt
hVwgIPFNjW/86EyooGRQB2wJyO7W5XtLF5kwGD4sEu5GQKfibNe/OTBBKPnC
+V8MAmoVMj5s5MGE+JqzNSmlBPTTIaVX8iETpNim2paqCEhTmctV8xETinXD
Bs5iBMQZNLTFOpoJXV+YK+uf8flbfAMC4pnA90tVznyagDYiNgL90pkQteXw
cx5RIrqzR4b7QhkTRA3a3zjtJSLdVMVcoQom5D1xK644QER9cRDcXcWEVuHs
TtdjRLQ+r9WDmEzgOLSH1mhERFwHR24z25kQaiLgHRhCRJ00wc+1o0wISFo7
92eSiJyk/EtC2THQly1yl54nIgH1bZXhmzEQqrz+yGaZiN6d07j3gAODkh/j
ra1UErKXNDO5wYPBnMS3s9lCJBQUFGLAtQMDm6wCXQd9EhKwNR3V2ouB7An3
K4kmJCRZPryxvA+Df80y4Z10EvpxoHYjTRqD+OkXTWpOJGTr5186cQCD9kNR
2sIBJGSitHL1+BEMVItdtbrek5BETevMJMKA44yUE2cJCW3xt3ymo4ZBb/fI
/VMVJOS14WzySh0D7zU6M7+JhFZ28BP0TmGQC9qaj0ZIaMcvFzcrbQz8Wlkc
mRMkxPos8UucDgY61lX3NmZJKIUUeLFJF4OfAUp1V/6R0Ft0f0hcHwOROsmT
Z/jJaA3ZrSYYYTBlMmTnv4uMAp9uL882xqB07HlQkRgZdX6u+1BigoEpG1/N
HlkyEso7YF5nikGkDkWdrEVGF5s0UtPoGFj2fbRRPktG/3UxbSMvYCDjejPA
3ZiM2vmi3W5YYsCMmKscsCajYJDyUrDCgNAxiEp9yWjC2N/7ji0GQb/KU3z9
yQjznPI3scOAjZBIUrpPRrqFZ7fvtceAZ79ZTUEMGX2+/vtfiQMGseoKEh7P
yEgr8LXhLUcMBM157x16QUbd7abqipcwkAhp08zJJSN6RSQh2QmDzMScjCsf
yCj24NNObWcMDuSHs8mUk9HhW9H6c7gVv2s1ZjSSkbWGre7ByxicOVallzpK
Rhvz9AInVwxaziXnWP0mo8j3f8UmcBte8uMS/oOvbxto5HgVA3qMcnsCkYKk
dV1Y9d0wGHwjIG/OSkGxu09FleK2r1p8LMBJQfv4OCfE3DFwnX5nHCNIQWPH
HPmGcM9RHxUailFQHMFjWvkaBjcEr/LzSFHQ+03OaeG41w7perfKUlBRQYhi
D+67WtLfHipQkLMaLUfsOgZUKzZlXRUK8i88RHPEHeo1Fk87SUGmv47pv8TN
EV67imlTUKqfnX8/7scvXtDvG1CQyPCvFB4PDARK/MtOmVGQy1m2AlXcz1ov
ClGtKCj9v40yF9y7x07cqXagoNNjbBWRuNPXdw76X6GgiXN25bm4pbatIORB
QVuUtUsbcedIdaX886WgyfiV0u+4D6sWksr8KchQ6m31HO6i89G2N+9TkJdJ
Ssc/3Mddr9UoRVDQJ3XOGaonBpVB+hJLMRS00nBIkBX3qYQD9wqf4fvpdcri
/+MNeZvHPF5QEPIPyl3H5+sxxzXlMymI3rFHeBZ3Rz8zYzaXgkSJjpkDuE0X
0tlyP1BQ0Gk/Ywx3Ly3Y2bWcgnZHvBR7i9tK1LZRppaCtK14BR7iHlFUlZlo
pKCFcepRJ9zOZ4XDX7dTUOXG27uAe8p+/bfjNwpa5zi9yoX7+q0evT2DFJS1
h/V1H76/S1HFOcOjFBQ/IxH+//0nVni6W/+hoGuqhlRJ3Pe+GLYLr1KQEW9L
0iD+Pdl/y8n3E6koXO727Rjc23ZM/THnpKILh85wzuL1ESfbZLydj4oeLnzC
YnHv0sws/CpIRbElZp1KuPd4OHgbSVHRJLvG6FW83vYrDxgmyVKR/NRpAxru
wwTTg+NHqUiLcis/Fa9XtTCt0TvqVMQv1mhfi9ezZZqM0Rs6FcncDKvpxuvf
3vnlwUUbKlr7FCRlgvuyrBBN1YmKhrdZJjS7YOBbyln1xRNfT5OakYv3z5PO
uYOkCCoyX9Au0MT7LzHehaYbQ0Wdqh4lL/D+TLMaHo1NwO8HvoFVvH/fTX5O
3J9BRUsetEfJeH+3UIppZpVUpJvsN/CfDV7PR+6M5cxTkZm+iO1xPF82r/6t
WlmmIo2OiSgLCzwPKt2enySwoMOeNNoNczzPdG2MezazIIi63J+K59Nx+5PV
LHtY0N7MJNMWPN88YmhJF0xZUAy/WasXno83LYJ8MyxZENed/HwLPD8Ddq8b
z9uxoDs2pWwnzuD5lj21meHOggLdOjkXNDHIqm3zzQ9lQSpq29uV8TweXog1
oZWxINGGdLqwEgapqvLX+6pZkIvMm+4cBQwuhrdE5DSwoK2zg6bHj2LQLU7F
DLtYkE3iVRsteQzaDK8dezbPgpZ+txEP78egPE9HZL/UJlQ6EyqjJ4Ln2xXi
uF7sJtRRoPHtDRkDo+JnLLufb0JPS7usq4j4+1MVxebTNqF3TLru5w0mPHzm
So99twkp03XNZlaZENTY0zLQvAlPe/Wnq/NMcNtX+N6NwoqaJrrMnIaYcGbE
+XaUOyvKGE7OLPzIhFO3xbI0vFnRrqExE2f8PFbj7e1e9GNFP98t/9jxHxOU
T+oqWoSxohui115eK8TP/5cH58VesaJ3vjIi61lMoNn/uVTQy4qES/bo3n3K
hKbh20ZdmmxocquDgYEbE/SGI6WFhNiRd0cTpYgXH5ce7qSLsyOCurjFJA8T
tK8r+CVIsaOovx9ChbiYcJrU3yqgwI5+5ifcvsWOP4+ItNdWfXa066H5uNBG
PRyh11awBrCj/v59iRtj9SDYuWw8P8KOUgUqJFWK6mG82uYuM5uG7s1uoe00
xP+nuL/sUr+4BfmXP6wqs64Ddliw7p3nQNK0igfOLrWg+dv8r6gxF2K6b77/
Sb8GuqrsiOYy3Cgossm4RK4aCu7XWIoscKOt8nynWUWrwIHqOdjSwoN2cnb4
3F2tANtrNws2x29F0e+VOSO+foSDjtItOtbb0LWD7280N5fBJx4ZmqcSL1rL
nzZ1yvgP/nsbkCBD5kPZ6EOre0kx3CRK6Tf18aHQYCl+7pIPwN7re9o1nx9l
7GXLEuwtgJH03dFJtwTQ6Wr9B0VH8iF673ZKsfF2dCtX+1lV8DuIjHeotxbZ
gewfnty5j5YH5tEXWjaP7UATDrw8HRdyYEnj5XJS+U60+Mt5yfJZFgyNqHlX
hQgi3qyNH/yKmZB6Qm5ns/UudO+NvlFi6yvIDvbkdtwvhCy2yfoZlr2EEGNb
bfKCEDLJSkk63vMCjvSmvA5pFkaae9988lpOgbh9CdnN2iKoMkJs7BQ9Ge5U
hMdpF4sg55TwxJjARNDdafyyQXw3CjzawM2dFg+qrvUW3IzdKLtOaSRWNg6S
BG3EmxZ2o/An+Q1J1TEgXv3qiZ6FKMq92uyc9P4xRO6vkmovF0WnfZ529nU/
Aod5ShsmJYZ8giUVTVgjwSZvToQRIYZe1CRJqa6EAbOBNbB0TQy945Xmr55l
wGX175EY7g81ecvOuLlKi59/wT1VfbaPB7dptnPJDO4n6W2vbGYYMBbRNCu+
LoYIrya1SNMMYDGOtArHfXDoVpXqJAPUB/hVLP+Jocy6maDKUQaMnp/RdsFt
GmIR6oQ7tJVp5o174EhfJDfu9kofzyjcR/UlUqxHGGCT1pNVh5tLnNlCHGbA
XaeknQc3xFBHnLGl2ncGiP+4se847qq6/Z7jgwxgmusraOF2zBMMj8LNpUM0
tMWdmatS8WOAAUkHbENjcS8QHssH9jNA7dWxuDTcfeUihtK4R4W3pefh/iVS
e72jj4H3Q21lI+6TteeKxHC3MxI/deG+RlTubexlgBfJq28Et/9nRaIH7h03
9SbmcF9W0ZMUxF0+v2d5A7egkq9eTQ8D/gei/o4Y
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(g\\), \\(n\\)]\\)\"", TraditionalForm], 
    FormBox[
    "\"pdf(\\!\\(\\*SubscriptBox[\\(g\\), \\(n\\)]\\))\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0, 10}, {0., 0.2552692268058242}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.404044366014888*^9, 3.404044914683835*^9, 
  3.404044978145088*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Absolute Contact States", "Subsubsection",
 Editable->False,
 CellChangeTimes->{{3.4040469494396706`*^9, 3.4040469556485987`*^9}}],

Cell[TextData[{
 "We repeat our derivation of the absolute contact states, as given in \
Section 4.3.4 using the negative binomial distribution for coverage at \
points. We define the probability function in terms of our variables ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", 
    RowBox[{"vr", " "}]], TraditionalForm]]],
 "and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["c", "_"], TraditionalForm]]],
 ":"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.412426355829152*^9, 3.41242643805739*^9}, 
   3.412935150054056*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"P", "[", "c_", "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], " ", "+", " ", "nvr"}], ")"}], "c"], " ", 
     SuperscriptBox["nvr", 
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"c", " ", "+", " ", 
         RowBox[{"cbar", "/", 
          RowBox[{"(", 
           RowBox[{"nvr", "-", "1"}], ")"}]}]}], ")"}]}]], 
     RowBox[{"Gamma", "[", 
      RowBox[{"c", " ", "+", " ", 
       RowBox[{"cbar", "/", 
        RowBox[{"(", 
         RowBox[{"nvr", "-", "1"}], ")"}]}]}], "]"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"c", "!"}], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"cbar", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], " ", "+", " ", "nvr"}], ")"}]}], "]"}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.4040470013943777`*^9, 3.404047018559059*^9}, 
   3.404047177327357*^9, 3.4040473799186687`*^9}],

Cell["\<\
We consider only the two-dimensional case. The fraction of the total fibre \
length making no contact with other fibres is\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412426464835896*^9, 3.412426503311221*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C0", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"P", "[", "1", "]"}], "/", "cbar"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4040472835500975`*^9, 3.4040474556976337`*^9}, {
   3.4040475567028723`*^9, 3.4040475754898863`*^9}, 3.4040481493750925`*^9}],

Cell[BoxData[
 SuperscriptBox["nvr", 
  RowBox[{
   RowBox[{"-", "1"}], "-", 
   FractionBox["cbar", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "nvr"}]]}]]], "Output",
 CellChangeTimes->{3.404048183123621*^9, 3.4041322963308735`*^9, 
  3.4118129860550766`*^9, 3.4118130330626707`*^9}]
}, Open  ]],

Cell["\<\
The fraction making contact with other fibres on one side only is: \
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412426507096664*^9, 3.41242651726128*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C1", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"2", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"P", "[", "0", "]"}], "-", 
       RowBox[{"P", "[", "1", "]"}]}], ")"}], "/", "cbar"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.4040472835500975`*^9, 3.4040474556976337`*^9}, {
  3.4040475567028723`*^9, 3.4040475754898863`*^9}, {3.4040481493750925`*^9, 
  3.404048150827181*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{
      SuperscriptBox["nvr", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        FractionBox["cbar", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "nvr"}]]}]], " ", 
      RowBox[{"(", 
       RowBox[{"cbar", "+", "nvr"}], ")"}]}]}], ")"}]}], "cbar"]], "Output",
 CellChangeTimes->{3.404048185677293*^9, 3.4041323012779875`*^9, 
  3.411812990140952*^9, 3.4118130333130302`*^9}]
}, Open  ]],

Cell["\<\
and the fraction making contact with other fibres on both sides is:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124265204158163`*^9, 3.4124265333844643`*^9}, 
   3.4129351540097437`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C2", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "-", "2"}], ")"}], 
       RowBox[{
        RowBox[{"P", "[", "c", "]"}], "/", "cbar"}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"c", ",", " ", "3", ",", " ", "\[Infinity]"}], "}"}]}], "]"}], 
    ",", " ", 
    RowBox[{
     RowBox[{"cbar", ">", "0"}], "&&", 
     RowBox[{"nvr", ">", "1"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4040472835500975`*^9, 3.4040474556976337`*^9}, {
  3.4040475567028723`*^9, 3.4040475754898863`*^9}, {3.4040481493750925`*^9, 
  3.404048150827181*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "2"}], "+", "cbar", "+", 
   RowBox[{
    SuperscriptBox["nvr", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      FractionBox["cbar", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "nvr"}]]}]], " ", 
    RowBox[{"(", 
     RowBox[{"cbar", "+", 
      RowBox[{"2", " ", "nvr"}]}], ")"}]}]}], "cbar"]], "Output",
 CellChangeTimes->{{3.4040472994229217`*^9, 3.404047320673478*^9}, {
   3.4040473627139297`*^9, 3.404047415850336*^9}, 3.4040474565989294`*^9, 
   3.404047578333976*^9, 3.4040482176032*^9, 3.4041323743730927`*^9, 
   3.4118129985230045`*^9, 3.4118130618039985`*^9}]
}, Open  ]],

Cell["We check that these fractions sum to 1:", "Text",
 Editable->False,
 CellChangeTimes->{{3.4124265380011024`*^9, 3.412426545652104*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrueQ", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"C0", "+", "C1", "+", "C2"}], "]"}], "\[Equal]", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4040482079092607`*^9, 3.404048219135403*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.4040482198964977`*^9, 3.4041323746134386`*^9, 
  3.411813061974243*^9}]
}, Open  ]],

Cell[TextData[{
 "and that we recover our expressions for random (Poissonian) networks when \
",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "vr"], " ", "\[Rule]", " ", 
    RowBox[{"1", ":"}]}], TraditionalForm]]]
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4124265506893473`*^9, 3.4124265739427843`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"C0", ",", "C1", ",", "C2"}], "}"}], ",", " ", 
   RowBox[{"nvr", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4040481636155696`*^9, 3.4040481792079906`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "cbar"}]], ",", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "cbar"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "cbar", "+", 
       SuperscriptBox["\[ExponentialE]", "cbar"]}], ")"}]}], "cbar"], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "cbar"}]], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "cbar", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", "cbar"]}], "+", 
       RowBox[{"cbar", " ", 
        SuperscriptBox["\[ExponentialE]", "cbar"]}]}], ")"}]}], "cbar"]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.404048221659032*^9, 3.404132375604864*^9, 
  3.4118130623147326`*^9}]
}, Open  ]],

Cell["\<\
We generate surfaces showing the dependence of these absolute contact states \
on the mean coverage and the variance ratio:\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.412426587221878*^9, 3.412426616273653*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plot3D", "[", 
  RowBox[{"C0", ",", " ", 
   RowBox[{"{", 
    RowBox[{"nvr", ",", " ", "1", ",", " ", "4"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"cbar", ",", " ", "1", ",", " ", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(n\), \(vr\)]\)\>\"", ",", " ", 
      "\"\<\!\(\*OverscriptBox[\(c\), \(_\)]\)\>\"", ",", " ", 
      "\"\<C(0)\>\""}], "}"}]}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{"C1", ",", " ", 
   RowBox[{"{", 
    RowBox[{"nvr", ",", " ", "1", ",", " ", "4"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"cbar", ",", " ", "1", ",", " ", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(n\), \(vr\)]\)\>\"", ",", " ", 
      "\"\<\!\(\*OverscriptBox[\(c\), \(_\)]\)\>\"", ",", " ", 
      "\"\<C(1)\>\""}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{"C2", ",", " ", 
   RowBox[{"{", 
    RowBox[{"nvr", ",", " ", "1", ",", " ", "4"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"cbar", ",", " ", "1", ",", " ", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(n\), \(vr\)]\)\>\"", ",", " ", 
      "\"\<\!\(\*OverscriptBox[\(c\), \(_\)]\)\>\"", ",", " ", 
      "\"\<C(2)\>\""}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.4118122667808113`*^9, 3.4118123582022686`*^9}, {
  3.411813005052394*^9, 3.41181302104539*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nHc4Vv/7wCkZpdIQRbLTViRa55AURcPeZCUee6TIJjsqFLKl7D3KzMwq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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXngFtMXxufOvd9QKqXsVKQNLShZfkoIpUUqS1pFpQ0hW6FUUrJkaZEQ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         "]], Polygon3DBox[CompressedData["
1:eJwtmnXgFVUXRWfmDoiKhWB3F1jY2C12YHcndheC3d2Kitjd3d3d9dndXd9a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         "]], Polygon3DBox[CompressedData["
1:eJwt13fclfMbB/D7ec5pUspIZTS0iZK2pgaRSMOqqJTRpKWJ0qDIT7LK+BH1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         "]]}]}, {}, {}, {}}, {
     Line3DBox[{246, 1, 242, 227, 661, 16, 675, 31, 690, 46, 705, 61, 720, 76,
       735, 91, 751, 752, 106, 780, 121, 795, 136, 810, 151, 825, 166, 840, 
      181, 855, 196, 993, 231, 248, 211, 244, 236, 445, 212, 446, 213, 447, 
      214, 448, 215, 449, 216, 450, 217, 451, 218, 452, 219, 453, 220, 454, 
      221, 455, 222, 456, 223, 457, 224, 658, 233, 249, 225, 245, 237, 882, 
      210, 868, 195, 853, 180, 838, 165, 823, 150, 808, 135, 793, 120, 778, 
      777, 105, 748, 90, 733, 75, 718, 60, 703, 45, 688, 30, 991, 229, 247, 
      15, 243, 235, 275, 14, 273, 13, 271, 12, 269, 11, 267, 10, 265, 9, 263, 
      8, 261, 7, 259, 6, 257, 5, 255, 4, 253, 3, 251, 2, 659, 234, 246}], {
      Line3DBox[{661, 990, 1096, 883, 660, 1097, 884, 662, 1098, 885, 663, 
       1099, 886, 664, 1100, 887, 665, 1101, 888, 666, 1102, 889, 667, 1103, 
       890, 668, 1104, 891, 669, 1105, 892, 670, 1106, 893, 671, 1107, 894, 
       672, 1108, 895, 673, 1093, 1109, 896, 991}], 
      Line3DBox[{675, 995, 1203, 674, 1110, 897, 676, 1111, 898, 677, 1112, 
       899, 678, 1113, 900, 679, 1114, 901, 680, 1115, 902, 681, 996, 1204, 
       682, 1116, 903, 683, 1117, 904, 684, 1118, 905, 685, 1119, 906, 686, 
       1120, 907, 687, 1121, 908, 688}], 
      Line3DBox[{690, 997, 1205, 689, 998, 1206, 691, 1122, 909, 692, 1123, 
       910, 693, 1124, 911, 694, 1125, 912, 695, 1126, 913, 696, 999, 1207, 
       697, 1000, 1208, 698, 1001, 1209, 699, 1127, 914, 700, 1128, 915, 701, 
       1129, 916, 702, 1130, 917, 703}], 
      Line3DBox[{705, 1002, 1210, 704, 1003, 1211, 706, 1004, 1212, 707, 1131,
        918, 708, 1132, 919, 709, 1133, 920, 710, 1134, 921, 711, 1005, 1213, 
       712, 1006, 1214, 713, 1007, 1215, 714, 1008, 1216, 715, 1135, 922, 716,
        1136, 923, 717, 1137, 924, 718}], 
      Line3DBox[{720, 1009, 1217, 719, 1010, 1218, 721, 1011, 1219, 722, 1012,
        1220, 723, 1138, 925, 724, 1139, 926, 725, 1140, 927, 726, 1013, 1221,
        727, 1014, 1222, 728, 1015, 1223, 729, 1016, 1224, 730, 1017, 1225, 
       731, 1141, 928, 732, 1142, 929, 733}], 
      Line3DBox[{735, 1018, 1226, 734, 1019, 1227, 736, 1020, 1228, 737, 1021,
        1229, 738, 1022, 1230, 739, 1143, 930, 740, 1144, 931, 741, 1023, 
       1231, 742, 1024, 1232, 743, 1025, 1233, 744, 1026, 1234, 745, 1027, 
       1235, 746, 539, 747, 1145, 932, 748}], 
      Line3DBox[{752, 1146, 933, 750, 1147, 934, 754, 1148, 935, 756, 1149, 
       936, 758, 1150, 937, 760, 1151, 938, 762, 1153, 940, 764, 1154, 941, 
       766, 1155, 942, 768, 1156, 943, 770, 1157, 944, 772, 1158, 945, 774, 
       1159, 946, 776, 1160, 947, 778}], 
      Line3DBox[{777, 1248, 1040, 775, 1247, 1039, 773, 1246, 1038, 771, 1245,
        1037, 769, 1244, 1036, 767, 1243, 1035, 765, 1242, 1034, 763, 939, 
       1152, 761, 1241, 1033, 759, 1240, 1032, 757, 1239, 1031, 755, 1238, 
       1030, 753, 1237, 1029, 749, 1236, 1028, 751}], 
      Line3DBox[{780, 555, 779, 1161, 948, 781, 1162, 949, 782, 1163, 950, 
       783, 1164, 951, 784, 1165, 952, 785, 1166, 953, 786, 562, 787, 1167, 
       954, 788, 1168, 955, 789, 1169, 956, 790, 1170, 957, 791, 1171, 958, 
       792, 1172, 959, 793}], 
      Line3DBox[{795, 1041, 1249, 794, 1042, 1250, 796, 1173, 960, 797, 1174, 
       961, 798, 1175, 962, 799, 1176, 963, 800, 1177, 964, 801, 1043, 1251, 
       802, 1044, 1252, 803, 1178, 965, 804, 1179, 966, 805, 1180, 967, 806, 
       1181, 968, 807, 1182, 969, 808}], 
      Line3DBox[{810, 1045, 1253, 809, 1046, 1254, 811, 1047, 1255, 812, 1183,
        970, 813, 1184, 971, 814, 1185, 972, 815, 1186, 973, 816, 1048, 1256, 
       817, 1049, 1257, 818, 1050, 1258, 819, 1187, 974, 820, 1188, 975, 821, 
       1189, 976, 822, 1190, 977, 823}], 
      Line3DBox[{825, 1051, 1259, 824, 1052, 1260, 826, 1053, 1261, 827, 1054,
        1262, 828, 1191, 978, 829, 1192, 979, 830, 1193, 980, 831, 1055, 1263,
        832, 1056, 1264, 833, 1057, 1265, 834, 1058, 1266, 835, 1194, 981, 
       836, 1195, 982, 837, 1196, 983, 838}], 
      Line3DBox[{840, 1059, 1267, 839, 1060, 1268, 841, 1061, 1269, 842, 1062,
        1270, 843, 1063, 1271, 844, 1197, 984, 845, 1198, 985, 846, 1064, 
       1272, 847, 1065, 1273, 848, 1066, 1274, 849, 1067, 1275, 850, 1068, 
       1276, 851, 1199, 986, 852, 1200, 987, 853}], 
      Line3DBox[{855, 1069, 1277, 854, 1070, 1278, 856, 1071, 1279, 857, 1072,
        1280, 858, 1073, 1281, 859, 1074, 1282, 860, 1201, 988, 861, 1075, 
       1283, 862, 1076, 1284, 863, 1077, 1285, 864, 1078, 1286, 865, 1079, 
       1287, 866, 1080, 1288, 867, 1202, 989, 868}], 
      Line3DBox[{882, 994, 1302, 1095, 881, 1301, 1092, 880, 1300, 1091, 879, 
       1299, 1090, 878, 1298, 1089, 877, 1297, 1088, 876, 1296, 1087, 875, 
       1295, 1086, 874, 1294, 1085, 873, 1293, 1084, 872, 1292, 1083, 871, 
       1291, 1082, 870, 1290, 1081, 869, 1094, 1289, 992, 993}]}, {
      Line3DBox[{251, 459, 1097, 252, 472, 1110, 278, 1206, 486, 292, 1211, 
       500, 306, 1218, 514, 320, 1227, 528, 334, 1237, 542, 1147, 348, 556, 
       1161, 362, 1250, 570, 376, 1254, 584, 390, 1260, 598, 404, 1268, 612, 
       418, 1278, 626, 432, 1290, 640, 446}], 
      Line3DBox[{253, 460, 1098, 254, 473, 1111, 279, 487, 1122, 293, 1212, 
       501, 307, 1219, 515, 321, 1228, 529, 335, 1238, 543, 1148, 349, 557, 
       1162, 363, 571, 1173, 377, 1255, 585, 391, 1261, 599, 405, 1269, 613, 
       419, 1279, 627, 433, 1291, 641, 447}], 
      Line3DBox[{255, 461, 1099, 256, 474, 1112, 280, 488, 1123, 294, 502, 
       1131, 308, 1220, 516, 322, 1229, 530, 336, 1239, 544, 1149, 350, 558, 
       1163, 364, 572, 1174, 378, 586, 1183, 392, 1262, 600, 406, 1270, 614, 
       420, 1280, 628, 434, 1292, 642, 448}], 
      Line3DBox[{257, 462, 1100, 258, 475, 1113, 281, 489, 1124, 295, 503, 
       1132, 309, 517, 1138, 323, 1230, 531, 337, 1240, 545, 1150, 351, 559, 
       1164, 365, 573, 1175, 379, 587, 1184, 393, 601, 1191, 407, 1271, 615, 
       421, 1281, 629, 435, 1293, 643, 449}], 
      Line3DBox[{259, 463, 1101, 260, 476, 1114, 282, 490, 1125, 296, 504, 
       1133, 310, 518, 1139, 324, 532, 1143, 338, 1241, 546, 1151, 352, 560, 
       1165, 366, 574, 1176, 380, 588, 1185, 394, 602, 1192, 408, 616, 1197, 
       422, 1282, 630, 436, 1294, 644, 450}], 
      Line3DBox[{261, 464, 1102, 262, 477, 1115, 283, 491, 1126, 297, 505, 
       1134, 311, 519, 1140, 325, 533, 1144, 339, 547, 1152, 1153, 353, 561, 
       1166, 367, 575, 1177, 381, 589, 1186, 395, 603, 1193, 409, 617, 1198, 
       423, 631, 1201, 437, 1295, 645, 451}], 
      Line3DBox[{8, 667, 23, 681, 38, 696, 53, 711, 68, 726, 83, 741, 98, 763,
        764, 113, 786, 128, 801, 143, 816, 158, 831, 173, 846, 188, 861, 203, 
       875, 218}], 
      Line3DBox[{263, 465, 1103, 264, 1204, 478, 284, 1207, 492, 298, 1213, 
       506, 312, 1221, 520, 326, 1231, 534, 340, 1242, 548, 1154, 354, 562, 
       368, 1251, 576, 382, 1256, 590, 396, 1263, 604, 410, 1272, 618, 424, 
       1283, 632, 438, 1296, 646, 452}], 
      Line3DBox[{265, 466, 1104, 266, 479, 1116, 285, 1208, 493, 299, 1214, 
       507, 313, 1222, 521, 327, 1232, 535, 341, 1243, 549, 1155, 355, 563, 
       1167, 369, 1252, 577, 383, 1257, 591, 397, 1264, 605, 411, 1273, 619, 
       425, 1284, 633, 439, 1297, 647, 453}], 
      Line3DBox[{267, 467, 1105, 268, 480, 1117, 286, 1209, 494, 300, 1215, 
       508, 314, 1223, 522, 328, 1233, 536, 342, 1244, 550, 1156, 356, 564, 
       1168, 370, 578, 1178, 384, 1258, 592, 398, 1265, 606, 412, 1274, 620, 
       426, 1285, 634, 440, 1298, 648, 454}], 
      Line3DBox[{269, 468, 1106, 270, 481, 1118, 287, 495, 1127, 301, 1216, 
       509, 315, 1224, 523, 329, 1234, 537, 343, 1245, 551, 1157, 357, 565, 
       1169, 371, 579, 1179, 385, 593, 1187, 399, 1266, 607, 413, 1275, 621, 
       427, 1286, 635, 441, 1299, 649, 455}], 
      Line3DBox[{271, 469, 1107, 272, 482, 1119, 288, 496, 1128, 302, 510, 
       1135, 316, 1225, 524, 330, 1235, 538, 344, 1246, 552, 1158, 358, 566, 
       1170, 372, 580, 1180, 386, 594, 1188, 400, 608, 1194, 414, 1276, 622, 
       428, 1287, 636, 442, 1300, 650, 456}], 
      Line3DBox[{273, 470, 1108, 274, 483, 1120, 289, 497, 1129, 303, 511, 
       1136, 317, 525, 1141, 331, 539, 345, 1247, 553, 1159, 359, 567, 1171, 
       373, 581, 1181, 387, 595, 1189, 401, 609, 1195, 415, 623, 1199, 429, 
       1288, 637, 443, 1301, 651, 457}], 
      Line3DBox[{275, 653, 654, 1109, 276, 484, 1121, 290, 498, 1130, 304, 
       512, 1137, 318, 526, 1142, 332, 540, 1145, 346, 1248, 554, 1160, 360, 
       568, 1172, 374, 582, 1182, 388, 596, 1190, 402, 610, 1196, 416, 624, 
       1200, 430, 638, 1202, 444, 1302, 656, 657, 658}], 
      Line3DBox[{445, 639, 655, 1289, 431, 625, 1277, 417, 611, 1267, 403, 
       597, 1259, 389, 583, 1253, 375, 569, 1249, 361, 555, 347, 1146, 541, 
       1236, 333, 527, 1226, 319, 513, 1217, 305, 499, 1210, 291, 485, 1205, 
       277, 471, 1203, 250, 1096, 458, 652, 659}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJxc23c4V2/8P3BNlFCKtCgZERlRSC8ZSdlk7733ysheIXuH7Oy947ZJFFmh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